/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.ComposedGeom;
import org.postgis.Geometry;
import org.postgis.LineString;

public class MultiLineString
extends ComposedGeom {
    private static final long serialVersionUID = 256L;
    double len = -1.0;

    public int hashCode() {
        return super.hashCode() ^ (int)this.length();
    }

    public MultiLineString() {
        super(5);
    }

    public MultiLineString(LineString[] lineStringArray) {
        super(5, lineStringArray);
    }

    public MultiLineString(String string) throws SQLException {
        this(string, false);
    }

    public MultiLineString(String string, boolean bl) throws SQLException {
        super(5, string, bl);
    }

    protected Geometry createSubGeomInstance(String string, boolean bl) throws SQLException {
        return new LineString(string, bl);
    }

    protected Geometry[] createSubGeomArray(int n) {
        return new LineString[n];
    }

    public int numLines() {
        return this.subgeoms.length;
    }

    public LineString[] getLines() {
        return (LineString[])this.subgeoms.clone();
    }

    public LineString getLine(int n) {
        if (n >= 0 & n < this.subgeoms.length) {
            return (LineString)this.subgeoms[n];
        }
        return null;
    }

    public double length() {
        if (this.len < 0.0) {
            LineString[] lineStringArray = (LineString[])this.subgeoms;
            if (lineStringArray.length < 1) {
                this.len = 0.0;
            } else {
                double d = 0.0;
                for (int i = 0; i < lineStringArray.length; ++i) {
                    d += lineStringArray[i].length();
                }
                this.len = d;
            }
        }
        return this.len;
    }
}

