/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.sql.SQLException;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public abstract class PGboxbase
extends PGobject {
    private static final long serialVersionUID = 256L;
    protected Point llb;
    protected Point urt;

    public abstract String getPrefix();

    public abstract String getPGtype();

    public PGboxbase() {
        this.setType(this.getPGtype());
    }

    public PGboxbase(Point point, Point point2) {
        this();
        this.llb = point;
        this.urt = point2;
    }

    public PGboxbase(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public void setValue(String string) throws SQLException {
        Object object;
        int n = -1;
        if ((string = string.trim()).startsWith("SRID=")) {
            object = PGgeometry.splitSRID(string);
            string = object[1].trim();
            n = Integer.parseInt(((String)object[0]).substring(5));
        }
        if (string.startsWith((String)(object = this.getPrefix()))) {
            string = string.substring(((String)object).length()).trim();
        }
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara((String)string), ',');
        this.llb = new Point(pGtokenizer.getToken(0));
        this.urt = new Point(pGtokenizer.getToken(1));
        if (n != -1) {
            this.llb.setSrid(n);
            this.urt.setSrid(n);
        }
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        this.outerWKT(stringBuffer);
        return stringBuffer.toString();
    }

    private void outerWKT(StringBuffer stringBuffer) {
        stringBuffer.append(this.getPrefix());
        stringBuffer.append('(');
        this.llb.innerWKT(stringBuffer);
        stringBuffer.append(',');
        this.urt.innerWKT(stringBuffer);
        stringBuffer.append(')');
    }

    public String toString() {
        return this.getValue();
    }

    public Point getLLB() {
        return this.llb;
    }

    public Point getURT() {
        return this.urt;
    }

    public boolean equals(Object object) {
        if (object instanceof PGboxbase) {
            PGboxbase pGboxbase = (PGboxbase)((Object)object);
            return PGboxbase.compareLazyDim(this.llb, pGboxbase.llb) && PGboxbase.compareLazyDim(this.urt, pGboxbase.urt);
        }
        return false;
    }

    protected static boolean compareLazyDim(Point point, Point point2) {
        return !(point.x != point2.x || point.y != point2.y || (point.dimension != 2 && point.z != 0.0 || point2.dimension != 2 && point2.z != 0.0) && point.z != point2.z);
    }

    public Object clone() {
        PGboxbase pGboxbase = this.newInstance();
        pGboxbase.llb = this.llb;
        pGboxbase.urt = this.urt;
        pGboxbase.setType(this.type);
        return pGboxbase;
    }

    protected abstract PGboxbase newInstance();
}

