/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import tim.prune.data.DataPoint;
import tim.prune.data.Photo;

public class PointPair {
    private Photo _photo = null;
    private DataPoint _pointBefore = null;
    private DataPoint _pointAfter = null;
    private long _secondsBefore = 1L;
    private long _secondsAfter = -1L;

    public PointPair(Photo photo) {
        this._photo = photo;
    }

    public void addPoint(DataPoint dataPoint, long l) {
        if (l <= 0L && (l > this._secondsBefore || this._secondsBefore > 0L)) {
            this._pointBefore = dataPoint;
            this._secondsBefore = l;
        }
        if (l >= 0L && (l < this._secondsAfter || this._secondsAfter < 0L)) {
            this._pointAfter = dataPoint;
            this._secondsAfter = l;
        }
    }

    public Photo getPhoto() {
        return this._photo;
    }

    public DataPoint getPointBefore() {
        return this._pointBefore;
    }

    public long getSecondsBefore() {
        return this._secondsBefore;
    }

    public DataPoint getPointAfter() {
        return this._pointAfter;
    }

    public long getSecondsAfter() {
        return this._secondsAfter;
    }

    public boolean isValid() {
        return this.getPointBefore() != null && this.getPointAfter() != null;
    }

    public double getFraction() {
        if (this._secondsAfter == 0L) {
            return 0.0;
        }
        return (double)(-this._secondsBefore) * 1.0 / (double)(-this._secondsBefore + this._secondsAfter);
    }

    public long getMinSeconds() {
        return Math.min(this._secondsAfter, -this._secondsBefore);
    }

    public double getMinRadians() {
        double d = DataPoint.calculateRadiansBetween(this._pointBefore, this._pointAfter);
        double d2 = this.getFraction();
        return d * Math.min(d2, 1.0 - d2);
    }
}

