/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.ImageIcon;

public abstract class ImageUtils {
    private static final float SMOOTH_FACTOR = 0.008f;
    private static ConvolveOp CONVOLVER = null;

    static {
        float[] fArray = new float[]{0.0f, 0.008f, 0.0f, 0.008f, 0.968f, 0.008f, 0.0f, 0.008f, 0.0f};
        CONVOLVER = new ConvolveOp(new Kernel(3, 3, fArray));
    }

    public static BufferedImage createScaledImage(Image image, int n, int n2) {
        Image image2 = image.getScaledInstance(n, n2, 4);
        Image image3 = new ImageIcon(image2).getImage();
        image3.getWidth(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(image2, 0, 0, n, n2, null);
        graphics.dispose();
        image2 = null;
        image3 = null;
        bufferedImage = CONVOLVER.filter(bufferedImage, null);
        return bufferedImage;
    }

    public static Dimension getThumbnailSize(int n, int n2, int n3, int n4) {
        double d;
        if (n3 <= 0 || n4 <= 0) {
            return new Dimension(0, 0);
        }
        double d2 = (double)n3 * 1.0 / (double)n;
        double d3 = (double)n4 * 1.0 / (double)n2;
        double d4 = d = d2 > d3 ? d3 : d2;
        if (d > 1.0) {
            return new Dimension(n, n2);
        }
        return new Dimension((int)(d * (double)n), (int)(d * (double)n2));
    }
}

