/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.Config;

public class MapTileConfig {
    private int _index = Config.getMapServerIndex();
    private String _url = MapTileConfig.fixUrl(Config.getMapServerUrl());
    private static final String[] SERVER_URLS = new String[]{"http://tile.openstreetmap.org/", "http://tah.openstreetmap.org/Tiles/tile/", "http://andy.sandbox.cloudmade.com/tiles/cycle/"};
    private static final int OTHER_SERVER_NUM = 3;

    public MapTileConfig() {
        if (this._index < 0 || this._index > 3 || this._index == 3 && (this._url == null || this._url.length() < 5)) {
            this._index = 0;
        }
    }

    public String getUrl() {
        if (this._index == 3) {
            return this._url;
        }
        return SERVER_URLS[this._index];
    }

    private static String fixUrl(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        String string2 = string;
        try {
            new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = "http://" + string2;
        }
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(string2) + "/";
        }
        return string2;
    }

    public boolean equals(MapTileConfig mapTileConfig) {
        if (mapTileConfig == null || mapTileConfig._index != this._index) {
            return false;
        }
        if (this._index == 3) {
            return mapTileConfig._url.equals(this._url);
        }
        return true;
    }
}

