/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.Field;
import tim.prune.load.xml.XmlHandler;

public class KmlHandler
extends XmlHandler {
    private boolean _insidePlacemark = false;
    private boolean _insideName = false;
    private boolean _insideCoordinates = false;
    private String _name = null;
    private StringBuffer _coordinates = null;
    private ArrayList<String[]> _pointList = new ArrayList();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("Placemark")) {
            this._insidePlacemark = true;
        } else if (string4.equalsIgnoreCase("coordinates")) {
            this._insideCoordinates = true;
            this._coordinates = null;
        } else if (string4.equalsIgnoreCase("name")) {
            this._insideName = true;
            this._name = null;
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4 == null || string4.equals("")) {
            string4 = string3;
        }
        if (string4.equalsIgnoreCase("Placemark")) {
            this.processPlacemark();
            this._insidePlacemark = false;
        } else if (string4.equalsIgnoreCase("coordinates")) {
            this._insideCoordinates = false;
        } else if (string4.equalsIgnoreCase("name")) {
            this._insideName = false;
        }
        super.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._insidePlacemark && (this._insideName || this._insideCoordinates)) {
            String string = new String(cArray, n, n2);
            if (this._insideName) {
                this._name = string;
            } else if (this._insideCoordinates) {
                if (this._coordinates == null) {
                    this._coordinates = new StringBuffer();
                }
                this._coordinates.append(string);
            }
        }
        super.characters(cArray, n, n2);
    }

    private void processPlacemark() {
        if (this._coordinates == null) {
            return;
        }
        String string = this._coordinates.toString();
        String[] stringArray = string.split("[ \n]");
        int n = stringArray.length;
        if (n == 1) {
            this._pointList.add(KmlHandler.makeStringArray(string, this._name));
        } else if (n > 1) {
            boolean bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2] != null && stringArray[n2].trim().length() > 3) {
                    String[] stringArray2 = KmlHandler.makeStringArray(stringArray[n2], null);
                    if (bl) {
                        stringArray2[4] = "1";
                    }
                    bl = false;
                    this._pointList.add(stringArray2);
                }
                ++n2;
            }
        }
    }

    private static String[] makeStringArray(String string, String string2) {
        String[] stringArray = new String[5];
        String[] stringArray2 = string.split(",");
        if (stringArray2.length == 3) {
            System.arraycopy(stringArray2, 0, stringArray, 0, 3);
        }
        stringArray[3] = string2;
        return stringArray;
    }

    public Field[] getFieldArray() {
        Field[] fieldArray = new Field[]{Field.LONGITUDE, Field.LATITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.NEW_SEGMENT};
        return fieldArray;
    }

    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }
}

