/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.load.GenericFileFilter;

public class GpxExporter
extends GenericFunction
implements Runnable {
    private Track _track = null;
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _descriptionField = null;
    private JCheckBox _timestampsCheckbox = null;
    private JFileChooser _fileChooser = null;
    private File _exportFile = null;
    private static final String GPX_VERSION_NUMBER = "1.0";
    private static final String GPX_CREATOR = "Prune v7 activityworkshop.net";

    public GpxExporter(App app) {
        super(app);
        this._track = app.getTrackInfo().getTrack();
    }

    public String getNameKey() {
        return "function.exportgpx";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._nameField = new JTextField(10);
        jPanel3.add(this._nameField);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JTextField(10);
        jPanel3.add(this._descriptionField);
        jPanel2.add(jPanel3);
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        jPanel2.add(this._timestampsCheckbox);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this.startExport();
            }
        };
        jButton.addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void startExport() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
            this._fileChooser.setAcceptAllFileFilterUsed(false);
            File file = Config.getWorkingDirectory();
            if (file != null) {
                this._fileChooser.setCurrentDirectory(file);
            }
        }
        boolean bl = false;
        do {
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (!file.getName().toLowerCase().endsWith(".gpx")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                this._exportFile = file;
                new Thread(this).start();
                continue;
            }
            bl = true;
        } while (bl);
    }

    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            int n = GpxExporter.exportData(outputStreamWriter, this._track, this._nameField.getText(), this._descriptionField.getText(), this._timestampsCheckbox.isSelected());
            outputStreamWriter.close();
            Config.setWorkingDirectory(this._exportFile.getParentFile());
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    public static int exportData(OutputStreamWriter outputStreamWriter, Track track, String string, String string2, boolean bl) throws IOException {
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<gpx version=\"");
        outputStreamWriter.write(GPX_VERSION_NUMBER);
        outputStreamWriter.write("\" creator=\"");
        outputStreamWriter.write(GPX_CREATOR);
        outputStreamWriter.write("\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n");
        String string3 = "PruneTrack";
        if (string != null && !string.equals("")) {
            string3 = string;
            outputStreamWriter.write("\t<name>");
            outputStreamWriter.write(string3);
            outputStreamWriter.write("</name>\n");
        }
        outputStreamWriter.write("\t<desc>");
        if (string2 != null && !string2.equals("")) {
            outputStreamWriter.write(string2);
        } else {
            outputStreamWriter.write("Export from Prune");
        }
        outputStreamWriter.write("</desc>\n");
        int n = 0;
        DataPoint dataPoint = null;
        boolean bl2 = false;
        int n2 = track.getNumPoints();
        n = 0;
        while (n < n2) {
            dataPoint = track.getPoint(n);
            if (dataPoint.isWaypoint()) {
                GpxExporter.exportWaypoint(dataPoint, outputStreamWriter, bl);
            } else {
                bl2 = true;
            }
            ++n;
        }
        if (bl2) {
            boolean bl3 = true;
            outputStreamWriter.write("\t<trk><name>" + string3 + "</name><number>1</number><trkseg>\n");
            n = 0;
            while (n < n2) {
                dataPoint = track.getPoint(n);
                if (dataPoint.getSegmentStart() && !bl3) {
                    outputStreamWriter.write("\t</trkseg>\n\t<trkseg>\n");
                }
                if (!dataPoint.isWaypoint()) {
                    GpxExporter.exportTrackpoint(dataPoint, outputStreamWriter, bl);
                    bl3 = false;
                }
                ++n;
            }
            outputStreamWriter.write("\t</trkseg></trk>\n");
        }
        outputStreamWriter.write("</gpx>\n");
        return n2;
    }

    private static void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>\n");
        }
        writer.write("\t\t<name>");
        writer.write(dataPoint.getWaypointName().trim());
        writer.write("</name>\n");
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("\t\t<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>\n");
        }
        writer.write("\t</wpt>\n");
    }

    private static void exportTrackpoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">");
        if (dataPoint.hasAltitude()) {
            writer.write("<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>");
        }
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>");
        }
        writer.write("</trkpt>\n");
    }
}

