/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.Config;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.ImageUtils;
import tim.prune.load.GenericFileFilter;

public class KmlExporter
extends GenericFunction
implements Runnable {
    private TrackInfo _trackInfo = null;
    private Track _track = null;
    private JDialog _dialog = null;
    private JTextField _descriptionField = null;
    private JCheckBox _altitudesCheckbox = null;
    private JCheckBox _kmzCheckbox = null;
    private JCheckBox _exportImagesCheckbox = null;
    private JProgressBar _progressBar = null;
    private JFileChooser _fileChooser = null;
    private File _exportFile = null;
    private static final String KML_FILENAME_IN_KMZ = "doc.kml";
    private static final int THUMBNAIL_WIDTH = 240;
    private static final int THUMBNAIL_HEIGHT = 180;

    public KmlExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
        this._track = this._trackInfo.getTrack();
    }

    public String getNameKey() {
        return "function.exportkml";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.enableCheckboxes();
        this._progressBar.setVisible(false);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportkml.text")));
        this._descriptionField = new JTextField(20);
        jPanel3.add(this._descriptionField);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this._altitudesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.altitude"));
        this._altitudesCheckbox.setHorizontalTextPosition(2);
        jPanel2.add(this._altitudesCheckbox);
        this._kmzCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.kmz"));
        this._kmzCheckbox.setHorizontalTextPosition(2);
        this._kmzCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this.enableCheckboxes();
            }
        });
        jPanel2.add(this._kmzCheckbox);
        this._exportImagesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.exportimages"));
        this._exportImagesCheckbox.setHorizontalTextPosition(2);
        jPanel2.add(this._exportImagesCheckbox);
        jPanel2.add(Box.createVerticalStrut(10));
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setVisible(false);
        jPanel2.add(this._progressBar);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this.startExport();
            }
        };
        jButton.addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel4.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void enableCheckboxes() {
        boolean bl = this._track.hasData(Field.ALTITUDE);
        if (!bl) {
            this._altitudesCheckbox.setSelected(false);
        }
        boolean bl2 = this._trackInfo.getPhotoList() != null && this._trackInfo.getPhotoList().getNumPhotos() > 0;
        this._exportImagesCheckbox.setSelected(bl2 && this._kmzCheckbox.isSelected());
        this._exportImagesCheckbox.setEnabled(bl2 && this._kmzCheckbox.isSelected());
    }

    private void startExport() {
        Object object;
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.kmlkmz", new String[]{"kml", "kmz"}));
            object = Config.getWorkingDirectory();
            if (object != null) {
                this._fileChooser.setCurrentDirectory((File)object);
            }
        }
        object = null;
        String string = null;
        if (this._kmzCheckbox.isSelected()) {
            object = ".kmz";
            string = ".kml";
        } else {
            object = ".kml";
            string = ".kmz";
        }
        this._fileChooser.setAcceptAllFileFilterUsed(false);
        boolean bl = false;
        do {
            Object[] objectArray;
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (file.getName().toLowerCase().endsWith(string)) {
                objectArray = file.getAbsolutePath();
                file = new File(String.valueOf(objectArray.substring(0, objectArray.length() - string.length())) + (String)object);
            } else if (!file.getName().toLowerCase().endsWith((String)object)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + (String)object);
            }
            objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                this._exportFile = file;
                new Thread(this).start();
                continue;
            }
            bl = true;
        } while (bl);
    }

    public void run() {
        this._progressBar.setVisible(true);
        this._progressBar.setValue(0);
        boolean bl = this._kmzCheckbox.isSelected();
        boolean bl2 = bl && this._exportImagesCheckbox.isSelected();
        this._progressBar.setMaximum(bl2 ? this.getNumPhotosToExport() : 1);
        OutputStreamWriter outputStreamWriter = null;
        ZipOutputStream zipOutputStream = null;
        try {
            if (!this._kmzCheckbox.isSelected()) {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this._exportFile));
                outputStreamWriter = new OutputStreamWriter(zipOutputStream);
                ZipEntry zipEntry = new ZipEntry(KML_FILENAME_IN_KMZ);
                zipOutputStream.putNextEntry(zipEntry);
            }
            int n = this.exportData(outputStreamWriter, bl2);
            this._progressBar.setValue(1);
            if (zipOutputStream != null) {
                outputStreamWriter.flush();
                zipOutputStream.closeEntry();
                if (bl2) {
                    this.exportThumbnails(zipOutputStream);
                }
            }
            outputStreamWriter.close();
            Config.setWorkingDirectory(this._exportFile.getParentFile());
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    private int exportData(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Folder>\n");
        outputStreamWriter.write("\t<name>");
        if (this._descriptionField != null && this._descriptionField.getText() != null && !this._descriptionField.getText().equals("")) {
            outputStreamWriter.write(this._descriptionField.getText());
        } else {
            outputStreamWriter.write("Export from Prune");
        }
        outputStreamWriter.write("</name>\n");
        boolean bl2 = this._altitudesCheckbox.isSelected();
        int n = 0;
        DataPoint dataPoint = null;
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = this._track.getNumPoints();
        int n3 = 0;
        n = 0;
        while (n < n2) {
            dataPoint = this._track.getPoint(n);
            if (dataPoint.isWaypoint()) {
                this.exportWaypoint(dataPoint, outputStreamWriter, bl2);
            } else if (dataPoint.getPhoto() == null) {
                bl3 = true;
            }
            if (dataPoint.getPhoto() != null) {
                if (!bl4) {
                    outputStreamWriter.write("<Style id=\"camera_icon\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/pal4/icon46.png</href></Icon></IconStyle></Style>");
                    bl4 = true;
                }
                this.exportPhotoPoint(dataPoint, outputStreamWriter, bl, ++n3, bl2);
            }
            ++n;
        }
        if (bl3) {
            String string = "\t<Placemark>\n\t\t<name>track</name>\n\t\t<Style>\n\t\t\t<LineStyle>\n\t\t\t\t<color>cc0000cc</color>\n\t\t\t\t<width>4</width>\n\t\t\t</LineStyle>\n\t\t\t<PolyStyle><color>33cc0000</color></PolyStyle>\n\t\t</Style>\n\t\t<LineString>\n";
            if (bl2) {
                string = String.valueOf(string) + "\t\t\t<extrude>1</extrude>\n\t\t\t<altitudeMode>absolute</altitudeMode>\n";
            }
            string = String.valueOf(string) + "\t\t\t<coordinates>";
            String string2 = "\t\t\t</coordinates>\n\t\t</LineString>\n\t</Placemark>";
            outputStreamWriter.write(string);
            boolean bl5 = true;
            n = 0;
            while (n < n2) {
                dataPoint = this._track.getPoint(n);
                if (dataPoint.getSegmentStart() && !bl5) {
                    outputStreamWriter.write(string2);
                    outputStreamWriter.write(string);
                }
                if (!dataPoint.isWaypoint() && dataPoint.getPhoto() == null) {
                    this.exportTrackpoint(dataPoint, outputStreamWriter, bl2);
                    bl5 = false;
                }
                ++n;
            }
            outputStreamWriter.write(string2);
        }
        outputStreamWriter.write("</Folder>\n</kml>");
        return n2;
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(dataPoint.getWaypointName().trim());
        writer.write("</name>\n");
        writer.write("\t\t<Point>\n");
        if (bl && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (bl && dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    private void exportPhotoPoint(DataPoint dataPoint, Writer writer, boolean bl, int n, boolean bl2) throws IOException {
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(dataPoint.getPhoto().getFile().getName());
        writer.write("</name>\n");
        if (bl) {
            Dimension dimension = dataPoint.getPhoto().getSize();
            Dimension dimension2 = ImageUtils.getThumbnailSize(dimension.width, dimension.height, 240, 180);
            writer.write("<description><![CDATA[<br/><table border='0'><tr><td><center><img src='images/image" + n + ".jpg' width='" + dimension2.width + "' height='" + dimension2.height + "'></center></td></tr>" + "<tr><td><center>Caption for the photo</center></td></tr></table>]]></description>");
        }
        writer.write("<styleUrl>#camera_icon</styleUrl>\n");
        writer.write("\t\t<Point>\n");
        if (bl2 && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (bl2 && dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    private void exportTrackpoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (bl && dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("\n");
    }

    private void exportThumbnails(ZipOutputStream zipOutputStream) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator == null || !iterator.hasNext()) {
            throw new IOException("no JPEG writer found");
        }
        ImageWriter imageWriter = iterator.next();
        int n = this._track.getNumPoints();
        DataPoint dataPoint = null;
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            dataPoint = this._track.getPoint(n3);
            if (dataPoint.getPhoto() != null) {
                ZipEntry zipEntry = new ZipEntry("images/image" + ++n2 + ".jpg");
                zipOutputStream.putNextEntry(zipEntry);
                ImageIcon imageIcon = new ImageIcon(dataPoint.getPhoto().getFile().getAbsolutePath());
                Dimension dimension = ImageUtils.getThumbnailSize(dataPoint.getPhoto().getWidth(), dataPoint.getPhoto().getHeight(), 240, 180);
                BufferedImage bufferedImage = ImageUtils.createScaledImage(imageIcon.getImage(), dimension.width, dimension.height);
                imageWriter.setOutput(ImageIO.createImageOutputStream(zipOutputStream));
                imageWriter.write(bufferedImage);
                zipOutputStream.closeEntry();
                this._progressBar.setValue(n2 + 1);
            }
            ++n3;
        }
    }

    private int getNumPhotosToExport() {
        int n = this._track.getNumPoints();
        int n2 = 0;
        DataPoint dataPoint = null;
        int n3 = 0;
        while (n3 < n) {
            dataPoint = this._track.getPoint(n3);
            if (dataPoint.getPhoto() != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }
}

