/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.PointScaler;
import tim.prune.data.Track;

public class ThreeDModel {
    private Track _track = null;
    private PointScaler _scaler = null;
    private double _modelSize;
    private int _altitudeCap = -1;
    private double _scaleFactor = 1.0;
    private double _altFactor = 1.0;
    private byte[] _pointTypes = null;
    private byte[] _pointHeights = null;
    private static final double DEFAULT_MODEL_SIZE = 10.0;
    public static final int MINIMUM_ALTITUDE_CAP = 100;
    public static final byte POINT_TYPE_WAYPOINT = 1;
    public static final byte POINT_TYPE_NORMAL_POINT = 2;
    public static final byte POINT_TYPE_SEGMENT_START = 3;

    public ThreeDModel(Track track) {
        this(track, 10.0);
    }

    public ThreeDModel(Track track, double d) {
        this._track = track;
        this._modelSize = d;
        if (this._modelSize <= 0.0) {
            this._modelSize = 10.0;
        }
    }

    public int getNumPoints() {
        if (this._track == null) {
            return 0;
        }
        return this._track.getNumPoints();
    }

    public void setAltitudeCap(int n) {
        this._altitudeCap = n;
        if (this._altitudeCap < 100) {
            this._altitudeCap = 100;
        }
    }

    public void scale() {
        this._scaler = new PointScaler(this._track);
        this._scaler.scale();
        this._scaleFactor = 1.0;
        if (this._scaler.getMaximumHoriz() > 0.0 || this._scaler.getMaximumVert() > 0.0) {
            this._scaleFactor = this._scaler.getMaximumHoriz() > this._scaler.getMaximumVert() ? this._modelSize / this._scaler.getMaximumHoriz() : this._modelSize / this._scaler.getMaximumVert();
        }
        this._altFactor = 1.0;
        if (this._scaler.getMaximumAlt() >= 0) {
            this._altFactor = this._scaler.getMaximumAlt() > this._altitudeCap ? this._modelSize / (double)this._scaler.getMaximumAlt() : this._modelSize / (double)this._altitudeCap;
        }
        this._scaler.calculateLatLongLines();
        this.calculatePointTypes();
    }

    private void calculatePointTypes() {
        int n = this.getNumPoints();
        this._pointTypes = new byte[n];
        this._pointHeights = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = this._track.getPoint(n2);
            this._pointTypes[n2] = dataPoint.isWaypoint() ? 1 : (dataPoint.getSegmentStart() ? 3 : 2);
            this._pointHeights[n2] = (byte)(dataPoint.getAltitude().getValue(Altitude.Format.METRES) / 500);
            ++n2;
        }
    }

    public double getScaledHorizValue(int n) {
        return this._scaler.getHorizValue(n) * this._scaleFactor;
    }

    public double getScaledVertValue(int n) {
        return this._scaler.getVertValue(n) * this._scaleFactor;
    }

    public double getScaledAltValue(int n) {
        int n2 = this._scaler.getAltValue(n);
        if (n2 < 0) {
            return 0.0;
        }
        return (double)n2 * this._altFactor;
    }

    public double[] getLatitudeLines() {
        return this._scaler.getLatitudeLines();
    }

    public double getScaledLatitudeLine(int n) {
        return this._scaler.getScaledLatitudeLines()[n] * this._scaleFactor;
    }

    public double[] getLongitudeLines() {
        return this._scaler.getLongitudeLines();
    }

    public double getScaledLongitudeLine(int n) {
        return this._scaler.getScaledLongitudeLines()[n] * this._scaleFactor;
    }

    public byte getPointType(int n) {
        return this._pointTypes[n];
    }

    public byte getPointHeightCode(int n) {
        return this._pointHeights[n];
    }

    public double getModelSize() {
        return this._modelSize;
    }
}

