/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.PhotoList;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoLoad
implements UndoOperation {
    private int _cropIndex = -1;
    private int _numLoaded = -1;
    private DataPoint[] _contents = null;
    private String _previousFilename = null;
    private PhotoList _photoList = null;

    public UndoLoad(int n, int n2) {
        this._cropIndex = n;
        this._numLoaded = n2;
        this._contents = null;
        this._previousFilename = null;
    }

    public UndoLoad(TrackInfo trackInfo, int n, PhotoList photoList) {
        this._cropIndex = -1;
        this._numLoaded = n;
        this._contents = trackInfo.getTrack().cloneContents();
        if (trackInfo.getFileInfo().getNumFiles() == 1) {
            this._previousFilename = trackInfo.getFileInfo().getFilename();
        }
        this._photoList = photoList;
    }

    public String getDescription() {
        String string = I18nManager.getText("undo.load");
        if (this._numLoaded > 0) {
            string = String.valueOf(string) + " (" + this._numLoaded + ")";
        }
        return string;
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getFileInfo().removeFile();
        if (this._previousFilename != null) {
            trackInfo.getFileInfo().setFile(this._previousFilename);
        }
        if (this._contents == null) {
            trackInfo.getTrack().cropTo(this._cropIndex);
        } else {
            if (this._photoList != null) {
                trackInfo.getPhotoList().restore(this._photoList);
            }
            if (!trackInfo.getTrack().replaceContents(this._contents)) {
                throw new UndoException(this.getDescription());
            }
        }
        trackInfo.getSelection().clearAll();
    }
}

