/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.Properties;
import tim.prune.config.ColourScheme;
import tim.prune.config.ConfigException;

public abstract class Config {
    private static File _configFile = null;
    private static Properties _configValues = new Properties();
    private static ColourScheme _colourScheme = new ColourScheme();
    private static final File DEFAULT_CONFIG_FILE = new File(".pruneconfig");
    public static final String KEY_TRACK_DIR = "prune.trackdirectory";
    public static final String KEY_PHOTO_DIR = "prune.photodirectory";
    public static final String KEY_LANGUAGE_CODE = "prune.languagecode";
    public static final String KEY_LANGUAGE_FILE = "prune.languagefile";
    public static final String KEY_GPS_DEVICE = "prune.gpsdevice";
    public static final String KEY_GPS_FORMAT = "prune.gpsformat";
    public static final String KEY_POVRAY_FONT = "prune.povrayfont";
    public static final String KEY_METRIC_UNITS = "prune.metricunits";
    public static final String KEY_MAPSERVERINDEX = "prune.mapserverindex";
    public static final String KEY_MAPSERVERURL = "prune.mapserverurl";
    public static final String KEY_SHOW_MAP = "prune.showmap";
    public static final String KEY_KMZ_IMAGE_WIDTH = "prune.kmzimagewidth";
    public static final String KEY_KMZ_IMAGE_HEIGHT = "prune.kmzimageheight";
    public static final String KEY_GPSBABEL_PATH = "prune.gpsbabelpath";
    public static final String KEY_GNUPLOT_PATH = "prune.gnuplotpath";
    public static final String KEY_EXIFTOOL_PATH = "prune.exiftoolpath";
    public static final String KEY_COLOUR_SCHEME = "prune.colourscheme";
    public static final String KEY_KML_TRACK_COLOUR = "prune.kmltrackcolour";

    public static void loadDefaultFile() {
        try {
            Config.loadFile(DEFAULT_CONFIG_FILE);
        }
        catch (ConfigException configException) {}
    }

    public static void loadFile(File file) throws ConfigException {
        boolean bl;
        Properties properties;
        block15: {
            properties = Config.getDefaultProperties();
            bl = false;
            FileInputStream fileInputStream = null;
            try {
                try {
                    fileInputStream = new FileInputStream(file);
                    properties.load(fileInputStream);
                }
                catch (Exception exception) {
                    bl = true;
                    if (fileInputStream != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        _configValues.putAll((Map<?, ?>)properties);
        _colourScheme.loadFromHex(_configValues.getProperty(KEY_COLOUR_SCHEME));
        if (bl) {
            throw new ConfigException();
        }
        _configFile = file;
    }

    private static Properties getDefaultProperties() {
        Properties properties = new Properties();
        properties.put(KEY_GPS_DEVICE, "usb:");
        properties.put(KEY_GPS_FORMAT, "garmin");
        properties.put(KEY_POVRAY_FONT, "crystal.ttf");
        properties.put(KEY_SHOW_MAP, "0");
        properties.put(KEY_EXIFTOOL_PATH, "exiftool");
        properties.put(KEY_GNUPLOT_PATH, "gnuplot");
        properties.put(KEY_GPSBABEL_PATH, "gpsbabel");
        properties.put(KEY_KMZ_IMAGE_WIDTH, "240");
        properties.put(KEY_KMZ_IMAGE_HEIGHT, "240");
        return properties;
    }

    private static int parseInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {}
        return n;
    }

    public static File getConfigFile() {
        return _configFile;
    }

    public static Properties getAllConfig() {
        return _configValues;
    }

    public static ColourScheme getColourScheme() {
        return _colourScheme;
    }

    public static void setConfigString(String string, String string2) {
        if (string2 == null || string2.equals("")) {
            _configValues.remove(string);
        } else {
            _configValues.put(string, string2);
        }
    }

    public static void setConfigBoolean(String string, boolean bl) {
        if (string != null && !string.equals("")) {
            _configValues.put(string, bl ? "1" : "0");
        }
    }

    public static void setConfigInt(String string, int n) {
        if (string != null && !string.equals("")) {
            _configValues.put(string, "" + n);
        }
    }

    public static String getConfigString(String string) {
        return _configValues.getProperty(string);
    }

    public static boolean getConfigBoolean(String string) {
        String string2 = _configValues.getProperty(string);
        return string2 == null || string2.equals("1");
    }

    public static int getConfigInt(String string) {
        return Config.parseInt(_configValues.getProperty(string));
    }

    public static boolean isKeyBoolean(String string) {
        return string != null && (string.equals(KEY_METRIC_UNITS) || string.equals(KEY_SHOW_MAP));
    }

    public static void updateColourScheme() {
        Config.setConfigString(KEY_COLOUR_SCHEME, _colourScheme.toString());
    }
}

