/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableModel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.correlate.OptionsChangedListener;
import tim.prune.correlate.PhotoPreviewTableModel;
import tim.prune.correlate.PhotoPreviewTableRow;
import tim.prune.correlate.PhotoSelectionTableModel;
import tim.prune.correlate.PhotoSelectionTableRow;
import tim.prune.correlate.PointPair;
import tim.prune.correlate.TimeIndexPair;
import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Field;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.data.TimeDifference;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoCorrelatePhotos;

public class PhotoCorrelator
extends GenericFunction {
    private JDialog _dialog;
    private JButton _nextButton = null;
    private JButton _backButton = null;
    private JButton _okButton = null;
    private JPanel _cards = null;
    private JTable _photoSelectionTable = null;
    private JLabel _tipLabel = null;
    private JTextField _offsetHourBox = null;
    private JTextField _offsetMinBox = null;
    private JTextField _offsetSecBox = null;
    private JRadioButton _photoLaterOption = null;
    private JRadioButton _pointLaterOption = null;
    private JRadioButton _timeLimitRadio = null;
    private JRadioButton _distLimitRadio = null;
    private JTextField _limitMinBox = null;
    private JTextField _limitSecBox = null;
    private JTextField _limitDistBox = null;
    private JComboBox _distUnitsDropdown = null;
    private JTable _previewTable = null;
    private boolean _firstTabAvailable = false;
    private boolean _previewEnabled = false;

    public PhotoCorrelator(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.correlatephotos";
    }

    public void begin() {
        Object[] objectArray;
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.getContentPane().add(this.makeDialogContents());
            this._dialog.pack();
        }
        if (!this._app.getTrackInfo().getTrack().hasData(Field.TIMESTAMP)) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.correlate.notimestamps"), I18nManager.getText(this.getNameKey()), 1);
            return;
        }
        if (!this.trackHasUncorrelatedPhotos()) {
            objectArray = new Object[]{I18nManager.getText("button.continue"), I18nManager.getText("button.cancel")};
            if (JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.correlate.nouncorrelatedphotos"), I18nManager.getText(this.getNameKey()), 0, 2, null, objectArray, objectArray[1]) == 1) {
                return;
            }
        }
        this._firstTabAvailable = (objectArray = PhotoCorrelator.makePhotoSelectionTableModel(this._app.getTrackInfo())) != null && objectArray.getRowCount() > 0;
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        if (this._firstTabAvailable) {
            cardLayout.first(this._cards);
            this._nextButton.setEnabled(true);
            this._backButton.setEnabled(false);
            this._tipLabel.setVisible(false);
            this._photoSelectionTable.setModel((TableModel)objectArray);
            this._previewEnabled = false;
            int n = 0;
            while (n < objectArray.getColumnCount()) {
                this._photoSelectionTable.getColumnModel().getColumn(n).setPreferredWidth(n == 3 ? 50 : 150);
                ++n;
            }
            n = objectArray.getRowCount() < 3 ? 0 : PhotoCorrelator.getMedianIndex((PhotoSelectionTableModel)objectArray);
            this._photoSelectionTable.getSelectionModel().setSelectionInterval(n, n);
            this._nextButton.requestFocus();
        } else {
            this._tipLabel.setVisible(true);
            this.setupSecondCard(null);
        }
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogContents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._cards = new JPanel();
        this._cards.setLayout(new CardLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add((Component)new JLabel(I18nManager.getText("dialog.correlate.photoselect.intro")), "North");
        this._photoSelectionTable = new JTable();
        JScrollPane jScrollPane = new JScrollPane(this._photoSelectionTable);
        jScrollPane.setPreferredSize(new Dimension(400, 100));
        jPanel2.add((Component)jScrollPane, "Center");
        this._cards.add((Component)jPanel2, "card1");
        OptionsChangedListener optionsChangedListener = new OptionsChangedListener(this);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this._tipLabel = new JLabel(I18nManager.getText("dialog.correlate.options.tip"));
        jPanel4.add(this._tipLabel);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.correlate.options.intro")));
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.correlate.options.offsetpanel")));
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        jPanel6.setBorder(null);
        jPanel6.add(new JLabel(String.valueOf(I18nManager.getText("dialog.correlate.options.offset")) + ": "));
        this._offsetHourBox = new JTextField(3);
        this._offsetHourBox.addKeyListener(optionsChangedListener);
        jPanel6.add(this._offsetHourBox);
        jPanel6.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.hours")));
        this._offsetMinBox = new JTextField(3);
        this._offsetMinBox.addKeyListener(optionsChangedListener);
        jPanel6.add(this._offsetMinBox);
        jPanel6.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.minutes")));
        this._offsetSecBox = new JTextField(3);
        this._offsetSecBox.addKeyListener(optionsChangedListener);
        jPanel6.add(this._offsetSecBox);
        jPanel6.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.seconds")));
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new FlowLayout());
        jPanel7.setBorder(null);
        this._photoLaterOption = new JRadioButton(I18nManager.getText("dialog.correlate.options.photolater"));
        this._pointLaterOption = new JRadioButton(I18nManager.getText("dialog.correlate.options.pointlater"));
        this._photoLaterOption.addItemListener(optionsChangedListener);
        this._pointLaterOption.addItemListener(optionsChangedListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._photoLaterOption);
        buttonGroup.add(this._pointLaterOption);
        jPanel7.add(this._photoLaterOption);
        jPanel7.add(this._pointLaterOption);
        jPanel5.add(jPanel7);
        jPanel5.setAlignmentX(0.0f);
        jPanel4.add(jPanel5);
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(BorderFactory.createTitledBorder(I18nManager.getText("dialog.correlate.options.limitspanel")));
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new FlowLayout());
        JRadioButton jRadioButton = new JRadioButton(I18nManager.getText("dialog.correlate.options.notimelimit"));
        jRadioButton.addItemListener(optionsChangedListener);
        jPanel9.add(jRadioButton);
        this._timeLimitRadio = new JRadioButton(String.valueOf(I18nManager.getText("dialog.correlate.options.timelimit")) + " : ");
        this._timeLimitRadio.addItemListener(optionsChangedListener);
        jPanel9.add(this._timeLimitRadio);
        PhotoCorrelator.groupRadioButtons(jRadioButton, this._timeLimitRadio);
        this._limitMinBox = new JTextField(3);
        this._limitMinBox.addKeyListener(optionsChangedListener);
        jPanel9.add(this._limitMinBox);
        jPanel9.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.minutes")));
        this._limitSecBox = new JTextField(3);
        this._limitSecBox.addKeyListener(optionsChangedListener);
        jPanel9.add(this._limitSecBox);
        jPanel9.add(new JLabel(I18nManager.getText("dialog.correlate.options.offset.seconds")));
        jPanel8.add(jPanel9);
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new FlowLayout());
        JRadioButton jRadioButton2 = new JRadioButton(I18nManager.getText("dialog.correlate.options.nodistancelimit"));
        jRadioButton2.addItemListener(optionsChangedListener);
        jPanel10.add(jRadioButton2);
        this._distLimitRadio = new JRadioButton(I18nManager.getText("dialog.correlate.options.distancelimit"));
        this._distLimitRadio.addItemListener(optionsChangedListener);
        jPanel10.add(this._distLimitRadio);
        PhotoCorrelator.groupRadioButtons(jRadioButton2, this._distLimitRadio);
        this._limitDistBox = new JTextField(4);
        this._limitDistBox.addKeyListener(optionsChangedListener);
        jPanel10.add(this._limitDistBox);
        String[] stringArray = new String[]{I18nManager.getText("units.kilometres"), I18nManager.getText("units.metres"), I18nManager.getText("units.miles")};
        this._distUnitsDropdown = new JComboBox<String>(stringArray);
        this._distUnitsDropdown.addItemListener(optionsChangedListener);
        jPanel10.add(this._distUnitsDropdown);
        jPanel8.add(jPanel10);
        jPanel8.setAlignmentX(0.0f);
        jPanel4.add(jPanel8);
        JButton jButton = new JButton(I18nManager.getText("button.preview"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoCorrelator.this.createPreview(true);
            }
        });
        jPanel4.add(jButton);
        jPanel3.add((Component)jPanel4, "North");
        this._previewTable = new JTable();
        JScrollPane jScrollPane2 = new JScrollPane(this._previewTable);
        jScrollPane2.setPreferredSize(new Dimension(300, 100));
        jPanel3.add((Component)jScrollPane2, "Center");
        this._cards.add((Component)jPanel3, "card2");
        jPanel.add((Component)this._cards, "Center");
        JPanel jPanel11 = new JPanel();
        this._backButton = new JButton(I18nManager.getText("button.back"));
        this._backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardLayout cardLayout = (CardLayout)PhotoCorrelator.this._cards.getLayout();
                cardLayout.previous(PhotoCorrelator.this._cards);
                PhotoCorrelator.this._backButton.setEnabled(false);
                PhotoCorrelator.this._nextButton.setEnabled(true);
                PhotoCorrelator.this._okButton.setEnabled(false);
                PhotoCorrelator.this._previewEnabled = false;
            }
        });
        this._backButton.setEnabled(false);
        jPanel11.add(this._backButton);
        this._nextButton = new JButton(I18nManager.getText("button.next"));
        this._nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = PhotoCorrelator.this._photoSelectionTable.getSelectedRow();
                if (n < 0) {
                    n = 0;
                }
                PhotoSelectionTableRow photoSelectionTableRow = ((PhotoSelectionTableModel)PhotoCorrelator.this._photoSelectionTable.getModel()).getRow(n);
                PhotoCorrelator.this.setupSecondCard(photoSelectionTableRow.getTimeDiff());
            }
        });
        jPanel11.add(this._nextButton);
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoCorrelator.this.finishCorrelation();
                PhotoCorrelator.this._dialog.dispose();
            }
        });
        this._okButton.setEnabled(false);
        jPanel11.add(this._okButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotoCorrelator.this._dialog.dispose();
            }
        });
        jPanel11.add(jButton2);
        jPanel.add((Component)jPanel11, "South");
        return jPanel;
    }

    private static PhotoSelectionTableModel makePhotoSelectionTableModel(TrackInfo trackInfo) {
        PhotoSelectionTableModel photoSelectionTableModel = new PhotoSelectionTableModel();
        int n = trackInfo.getPhotoList().getNumPhotos();
        int n2 = 0;
        while (n2 < n) {
            Photo photo = trackInfo.getPhotoList().getPhoto(n2);
            if (photo.getDataPoint() != null && photo.getDataPoint().hasTimestamp()) {
                long l = photo.getTimestamp().getSecondsSince(photo.getDataPoint().getTimestamp());
                photoSelectionTableModel.addPhoto(photo, l);
            }
            ++n2;
        }
        return photoSelectionTableModel;
    }

    private static void groupRadioButtons(JRadioButton jRadioButton, JRadioButton jRadioButton2) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        jRadioButton.setSelected(true);
    }

    private void setupSecondCard(TimeDifference timeDifference) {
        boolean bl;
        this._previewEnabled = false;
        boolean bl2 = bl = timeDifference != null;
        if (!bl) {
            timeDifference = this.getTimezoneOffset();
        }
        this._offsetHourBox.setText("" + timeDifference.getNumHours());
        this._offsetMinBox.setText("" + timeDifference.getNumMinutes());
        this._offsetSecBox.setText("" + timeDifference.getNumSeconds());
        this._photoLaterOption.setSelected(timeDifference.getIsPositive());
        this._pointLaterOption.setSelected(!timeDifference.getIsPositive());
        this.createPreview(timeDifference, true);
        CardLayout cardLayout = (CardLayout)this._cards.getLayout();
        cardLayout.last(this._cards);
        this._backButton.setEnabled(bl);
        this._nextButton.setEnabled(false);
        this._okButton.setEnabled(((PhotoPreviewTableModel)this._previewTable.getModel()).hasPhotosSelected());
        this._previewEnabled = true;
    }

    public void createPreview(boolean bl) {
        if (!this._previewEnabled) {
            return;
        }
        int n = PhotoCorrelator.getValue(this._offsetHourBox.getText());
        int n2 = PhotoCorrelator.getValue(this._offsetMinBox.getText());
        int n3 = PhotoCorrelator.getValue(this._offsetSecBox.getText());
        boolean bl2 = this._photoLaterOption.isSelected();
        this.createPreview(new TimeDifference(n, n2, n3, bl2), bl);
    }

    private void createPreview(TimeDifference timeDifference, boolean bl) {
        TimeDifference timeDifference2 = this.parseTimeLimit();
        double d = this.parseDistanceLimit();
        PhotoPreviewTableModel photoPreviewTableModel = new PhotoPreviewTableModel();
        PhotoList photoList = this._app.getTrackInfo().getPhotoList();
        int n = photoList.getNumPhotos();
        int n2 = 0;
        while (n2 < n) {
            Photo photo = photoList.getPhoto(n2);
            PointPair pointPair = PhotoCorrelator.getPointPairForPhoto(this._app.getTrackInfo().getTrack(), photo, timeDifference);
            PhotoPreviewTableRow photoPreviewTableRow = new PhotoPreviewTableRow(pointPair);
            boolean bl2 = pointPair.isValid();
            if (timeDifference2 != null && bl2) {
                long l = pointPair.getMinSeconds();
                boolean bl3 = bl2 = l <= timeDifference2.getTotalSeconds();
            }
            if (d > 0.0 && bl2) {
                double d2;
                double d3 = DataPoint.calculateRadiansBetween(pointPair.getPointBefore(), pointPair.getPointAfter());
                double d4 = pointPair.getFraction();
                if (d4 > 0.5) {
                    d4 = 1.0 - d4;
                }
                boolean bl4 = bl2 = (d2 = d3 * d4) < d;
            }
            if (pointPair.getSecondsBefore() == 0L && pointPair.getPointBefore().getPhoto() != null && pointPair.getPointBefore().getPhoto().equals(photo)) {
                bl2 = false;
            }
            photoPreviewTableRow.setCorrelateFlag(bl2);
            photoPreviewTableModel.addPhotoRow(photoPreviewTableRow);
            ++n2;
        }
        this._previewTable.setModel(photoPreviewTableModel);
        photoPreviewTableModel.setDistanceUnits(this.getSelectedDistanceUnits());
        this._previewTable.setAutoResizeMode(4);
        int[] nArray = new int[]{150, 160, 100, 100, 50};
        int n3 = 0;
        while (n3 < photoPreviewTableModel.getColumnCount()) {
            this._previewTable.getColumnModel().getColumn(n3).setPreferredWidth(nArray[n3]);
            ++n3;
        }
        this._okButton.setEnabled(photoPreviewTableModel.hasPhotosSelected());
        if (bl && !photoPreviewTableModel.hasPhotosSelected()) {
            JOptionPane.showMessageDialog(this._dialog, I18nManager.getText("dialog.correlate.alloutsiderange"), I18nManager.getText(this.getNameKey()), 0);
        }
    }

    private TimeDifference parseTimeLimit() {
        if (!this._timeLimitRadio.isSelected()) {
            return null;
        }
        int n = PhotoCorrelator.getValue(this._limitMinBox.getText());
        this._limitMinBox.setText("" + n);
        int n2 = PhotoCorrelator.getValue(this._limitSecBox.getText());
        this._limitSecBox.setText("" + n2);
        if (n <= 0 && n2 <= 0) {
            return null;
        }
        return new TimeDifference(0, n, n2, true);
    }

    private double parseDistanceLimit() {
        double d = -1.0;
        if (this._distLimitRadio.isSelected()) {
            try {
                d = Double.parseDouble(this._limitDistBox.getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (d <= 0.0) {
            this._limitDistBox.setText("0");
            return -1.0;
        }
        this._limitDistBox.setText("" + d);
        return Distance.convertDistanceToRadians(d, this.getSelectedDistanceUnits());
    }

    private Distance.Units getSelectedDistanceUnits() {
        Distance.Units[] unitsArray = new Distance.Units[]{Distance.Units.KILOMETRES, Distance.Units.METRES, Distance.Units.MILES};
        return unitsArray[this._distUnitsDropdown.getSelectedIndex()];
    }

    private static int getValue(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    private static PointPair getPointPairForPhoto(Track track, Photo photo, TimeDifference timeDifference) {
        PointPair pointPair = new PointPair(photo);
        Timestamp timestamp = photo.getTimestamp().createMinusOffset(timeDifference);
        int n = track.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            DataPoint dataPoint = track.getPoint(n2);
            Timestamp timestamp2 = dataPoint.getTimestamp();
            if (timestamp2 != null && timestamp2.isValid()) {
                long l = timestamp2.getSecondsSince(timestamp);
                pointPair.addPoint(dataPoint, l);
            }
            ++n2;
        }
        return pointPair;
    }

    private PointPair[] getPointPairs() {
        PhotoPreviewTableModel photoPreviewTableModel = (PhotoPreviewTableModel)this._previewTable.getModel();
        int n = photoPreviewTableModel.getRowCount();
        PointPair[] pointPairArray = new PointPair[n];
        int n2 = 0;
        while (n2 < n) {
            PhotoPreviewTableRow photoPreviewTableRow = photoPreviewTableModel.getRow(n2);
            if (photoPreviewTableRow.getCorrelateFlag().booleanValue()) {
                pointPairArray[n2] = photoPreviewTableRow.getPointPair();
            }
            ++n2;
        }
        return pointPairArray;
    }

    private TimeDifference getTimezoneOffset() {
        Calendar calendar = null;
        Photo photo = this._app.getTrackInfo().getPhotoList().getPhoto(0);
        calendar = photo != null && photo.getTimestamp() != null ? photo.getTimestamp().getCalendar() : Calendar.getInstance();
        TimeDifference timeDifference = new TimeDifference((calendar.get(15) + calendar.get(16)) / 1000);
        return timeDifference;
    }

    private static int getMedianIndex(PhotoSelectionTableModel photoSelectionTableModel) {
        Object object;
        TreeSet<TimeIndexPair> treeSet = new TreeSet<TimeIndexPair>();
        int n = photoSelectionTableModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            object = photoSelectionTableModel.getRow(n2);
            treeSet.add(new TimeIndexPair(((PhotoSelectionTableRow)object).getTimeDiff().getTotalSeconds(), n2));
            ++n2;
        }
        object = null;
        Iterator iterator = treeSet.iterator();
        n2 = 0;
        while (n2 < (n + 1) / 2) {
            object = (TimeIndexPair)iterator.next();
            ++n2;
        }
        return ((TimeIndexPair)object).getIndex();
    }

    public void disableOkButton() {
        if (this._okButton != null) {
            this._okButton.setEnabled(false);
        }
    }

    private boolean trackHasUncorrelatedPhotos() {
        PhotoList photoList = this._app.getTrackInfo().getPhotoList();
        int n = photoList.getNumPhotos();
        int n2 = 0;
        while (n2 < n) {
            Photo photo = photoList.getPhoto(n2);
            if (photo != null && photo.getDataPoint() == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void finishCorrelation() {
        Object object;
        PointPair[] pointPairArray = this.getPointPairs();
        if (pointPairArray == null || pointPairArray.length <= 0) {
            return;
        }
        UndoCorrelatePhotos undoCorrelatePhotos = new UndoCorrelatePhotos(this._app.getTrackInfo());
        int n = pointPairArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        PointPair pointPair = null;
        n2 = 0;
        while (n2 < n) {
            pointPair = pointPairArray[n2];
            if (pointPair != null && pointPair.isValid()) {
                if (pointPair.getMinSeconds() == 0L) {
                    object = pointPair.getPointBefore().getPhoto();
                    if (object == null) {
                        pointPair.getPointBefore().setPhoto(pointPair.getPhoto());
                        pointPair.getPhoto().setDataPoint(pointPair.getPointBefore());
                    } else if (!object.equals(pointPair.getPhoto())) {
                        ++n4;
                    }
                } else {
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
        if (n4 > 0) {
            object = new DataPoint[n4];
            int n5 = 0;
            DataPoint dataPoint = null;
            n2 = 0;
            while (n2 < n) {
                pointPair = pointPairArray[n2];
                if (pointPair != null && pointPair.isValid()) {
                    dataPoint = null;
                    if (pointPair.getMinSeconds() == 0L && pointPair.getPointBefore().getPhoto() != null && !pointPair.getPointBefore().getPhoto().equals(pointPair.getPhoto())) {
                        dataPoint = pointPair.getPointBefore().clonePoint();
                    } else if (pointPair.getMinSeconds() > 0L) {
                        dataPoint = DataPoint.interpolate(pointPair.getPointBefore(), pointPair.getPointAfter(), pointPair.getFraction());
                    }
                    if (dataPoint != null) {
                        dataPoint.setPhoto(pointPair.getPhoto());
                        pointPair.getPhoto().setDataPoint(dataPoint);
                        dataPoint.setSegmentStart(true);
                        object[n5] = dataPoint;
                        ++n5;
                    }
                }
                ++n2;
            }
            this._app.getTrackInfo().getTrack().appendPoints((DataPoint[])object);
        }
        undoCorrelatePhotos.setNumPhotosCorrelated(n3);
        this._app.completeFunction(undoCorrelatePhotos, n3 + " " + (n3 == 1 ? I18nManager.getText("confirm.correlate.single") : I18nManager.getText("confirm.correlate.multi")));
    }
}

