/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.correlate;

import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import tim.prune.I18nManager;
import tim.prune.correlate.PhotoPreviewTableRow;
import tim.prune.data.Distance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoPreviewTableModel
extends AbstractTableModel {
    private ArrayList<PhotoPreviewTableRow> _list = new ArrayList();
    private Distance.Units _distanceUnits = Distance.Units.KILOMETRES;
    private static final NumberFormat FORMAT_ONE_DP = NumberFormat.getNumberInstance();

    static {
        FORMAT_ONE_DP.setMaximumFractionDigits(1);
        FORMAT_ONE_DP.setMinimumFractionDigits(1);
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return I18nManager.getText("dialog.correlate.photoselect.photoname");
        }
        if (n == 1) {
            return I18nManager.getText("fieldname.timestamp");
        }
        if (n == 2) {
            return I18nManager.getText("dialog.correlate.photoselect.timediff");
        }
        if (n == 3) {
            return I18nManager.getText("fieldname.distance");
        }
        return I18nManager.getText("dialog.correlate.options.correlate");
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    public PhotoPreviewTableRow getRow(int n) {
        return this._list.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PhotoPreviewTableRow photoPreviewTableRow = this._list.get(n);
        if (n2 == 0) {
            return photoPreviewTableRow.getPhoto().getFile().getName();
        }
        if (n2 == 1) {
            return photoPreviewTableRow.getPhoto().getTimestamp().getText();
        }
        if (n2 == 2) {
            if (photoPreviewTableRow.getPointPair().isValid()) {
                return photoPreviewTableRow.getTimeDiff().getDescription();
            }
            return "";
        }
        if (n2 == 3) {
            if (photoPreviewTableRow.getPointPair().isValid()) {
                return FORMAT_ONE_DP.format(photoPreviewTableRow.getDistance(this._distanceUnits));
            }
            return "";
        }
        return photoPreviewTableRow.getCorrelateFlag();
    }

    public void setDistanceUnits(Distance.Units units) {
        this._distanceUnits = units;
    }

    public void reset() {
        this._list.clear();
    }

    public void addPhotoRow(PhotoPreviewTableRow photoPreviewTableRow) {
        this._list.add(photoPreviewTableRow);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 4) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (n2 == 4) {
            return true;
        }
        return super.isCellEditable(n, n2);
    }

    public boolean hasPhotosSelected() {
        int n = 0;
        while (n < this.getRowCount()) {
            if (this.getRow(n).getCorrelateFlag().booleanValue()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PhotoPreviewTableRow photoPreviewTableRow;
        if (n2 == 4 && (photoPreviewTableRow = this.getRow(n)).getPointPair().isValid()) {
            photoPreviewTableRow.setCorrelateFlag((Boolean)object);
        }
    }
}

