/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.NumberUtils;

public class Altitude {
    private boolean _valid = false;
    private int _value = 0;
    private Format _format = Format.NO_FORMAT;
    private String _stringValue = null;
    private static final double CONVERT_FEET_TO_METRES = 0.3048;
    private static final double CONVERT_METRES_TO_FEET = 3.28084;
    public static final Altitude NONE = new Altitude(null, Format.NO_FORMAT);

    public Altitude(String string, Format format) {
        if (string != null && !string.equals("")) {
            try {
                this._stringValue = string;
                this._value = (int)Double.parseDouble(string.trim());
                this._format = format;
                this._valid = true;
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public Altitude(int n, Format format) {
        this._value = n;
        this._format = format;
        this._valid = true;
    }

    public Altitude clone() {
        return new Altitude(this._stringValue, this._format);
    }

    public void reset(Altitude altitude) {
        this._value = altitude._value;
        this._format = altitude._format;
        this._valid = altitude._valid;
    }

    public boolean isValid() {
        return this._valid;
    }

    public int getValue() {
        return this._value;
    }

    public Format getFormat() {
        return this._format;
    }

    public int getValue(Format format) {
        if (format == this._format) {
            return this._value;
        }
        if (format == Format.METRES) {
            return (int)((double)this._value * 0.3048);
        }
        if (format == Format.FEET) {
            return (int)((double)this._value * 3.28084);
        }
        return this._value;
    }

    public String getStringValue(Format format) {
        if (!this._valid) {
            return "";
        }
        if (!(format != this._format && format != Format.NO_FORMAT || this._stringValue == null || this._stringValue.equals(""))) {
            return this._stringValue;
        }
        return "" + this.getValue(format);
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, int n, int n2) {
        return Altitude.interpolate(altitude, altitude2, 1.0 * (double)(n + 1) / (double)(n2 + 1));
    }

    public static Altitude interpolate(Altitude altitude, Altitude altitude2, double d) {
        if (altitude == null || altitude2 == null || !altitude.isValid() || !altitude2.isValid()) {
            return NONE;
        }
        Format format = altitude.getFormat();
        int n = altitude.getValue();
        int n2 = altitude2.getValue(format);
        int n3 = n + (int)((double)(n2 - n) * d);
        return new Altitude(n3, format);
    }

    public void addOffset(double d, Format format, int n) {
        int n2 = NumberUtils.getDecimalPlaces(this._stringValue);
        if (n2 < n) {
            n2 = n;
        }
        double d2 = d;
        if (format != this._format) {
            d2 = format == Format.FEET ? d * 0.3048 : d * 3.28084;
        }
        double d3 = Double.parseDouble(this._stringValue.trim()) + d2;
        this._value = (int)d3;
        this._stringValue = NumberUtils.formatNumber(d3, n2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        NO_FORMAT,
        METRES,
        FEET;

    }
}

