/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.Altitude;
import tim.prune.data.AltitudeRange;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Track;

public class PointScaler {
    private Track _track = null;
    private AltitudeRange _altRange = null;
    private DoubleRange _latRange = null;
    private DoubleRange _lonRange = null;
    private double _latMedian = 0.0;
    private double _lonMedian = 0.0;
    private int _minAltitude = 0;
    private int _maxAltitude = 0;
    private double _longFactor = 0.0;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private int[] _altValues = null;
    private double _maxX = 0.0;
    private double _maxY = 0.0;
    private double[] _latLinesDegs = null;
    private double[] _lonLinesDegs = null;
    private double[] _latLinesScaled = null;
    private double[] _lonLinesScaled = null;
    private static final double[] COORD_SEPARATIONS = new double[]{1.0, 0.5, 0.3333333333333333, 0.16666666666666666, 0.08333333333333333, 0.05, 0.03333333333333333, 0.016666666666666666};
    private static final int MAX_COORD_SEPARATION_INDEX = COORD_SEPARATIONS.length - 1;

    public PointScaler(Track track) {
        this._track = track;
        this._altRange = new AltitudeRange();
        this._latRange = new DoubleRange();
        this._lonRange = new DoubleRange();
    }

    public void scale() {
        this._altRange.clear();
        this._latRange.clear();
        this._lonRange.clear();
        int n = 0;
        int n2 = 0;
        DataPoint dataPoint = null;
        if (this._track != null && (n = this._track.getNumPoints()) > 0) {
            n2 = 0;
            while (n2 < n) {
                dataPoint = this._track.getPoint(n2);
                if (dataPoint != null) {
                    this._latRange.addValue(dataPoint.getLatitude().getDouble());
                    this._lonRange.addValue(dataPoint.getLongitude().getDouble());
                    this._altRange.addValue(dataPoint.getAltitude());
                }
                ++n2;
            }
            this._latMedian = (this._latRange.getMinimum() + this._latRange.getMaximum()) / 2.0;
            this._lonMedian = (this._lonRange.getMinimum() + this._lonRange.getMaximum()) / 2.0;
            this._minAltitude = this._altRange.getMinimum();
            this._longFactor = Math.cos(this._latMedian / 180.0 * Math.PI);
            if (this._xValues == null || this._xValues.length != n) {
                this._xValues = new double[n];
                this._yValues = new double[n];
                this._altValues = new int[n];
            }
            n2 = 0;
            while (n2 < n) {
                dataPoint = this._track.getPoint(n2);
                if (dataPoint != null) {
                    this._xValues[n2] = this.getScaledLongitude(dataPoint.getLongitude().getDouble());
                    this._yValues[n2] = this.getScaledLatitude(dataPoint.getLatitude().getDouble());
                    this._altValues[n2] = this.getScaledAltitude(dataPoint.getAltitude());
                }
                ++n2;
            }
            this._maxX = this.getScaledLongitude(this._lonRange.getMaximum());
            this._maxY = this.getScaledLatitude(this._latRange.getMaximum());
            this._maxAltitude = this._altRange.getMaximum() - this._altRange.getMinimum();
        }
    }

    public double getMaximumHoriz() {
        return this._maxX;
    }

    public double getMaximumVert() {
        return this._maxY;
    }

    public int getMaximumAlt() {
        return this._maxAltitude;
    }

    public double getHorizValue(int n) {
        return this._xValues[n];
    }

    public double getVertValue(int n) {
        return this._yValues[n];
    }

    public int getAltValue(int n) {
        return this._altValues[n];
    }

    public double getScaledLatitude(double d) {
        return d - this._latMedian;
    }

    public double getScaledLongitude(double d) {
        return (d - this._lonMedian) * this._longFactor;
    }

    public int getScaledAltitude(Altitude altitude) {
        if (altitude == null) {
            return -1;
        }
        return altitude.getValue(this._altRange.getFormat()) - this._minAltitude;
    }

    public double getUnscaledLatitude(double d) {
        return d + this._latMedian;
    }

    public double getUnscaledLongitude(double d) {
        return d / this._longFactor + this._lonMedian;
    }

    public void calculateLatLongLines() {
        double d;
        double d2 = this.getMaximumHoriz() > this.getMaximumVert() ? this.getMaximumHoriz() : this.getMaximumVert();
        double d3 = this.getUnscaledLongitude(-d2);
        double d4 = this.getUnscaledLongitude(d2);
        double d5 = this.getUnscaledLatitude(-d2);
        double d6 = this.getUnscaledLatitude(d2);
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        do {
            d = COORD_SEPARATIONS[++n];
            n2 = PointScaler.getNumLinesBetween(d5, d6, d);
        } while (((n3 = PointScaler.getNumLinesBetween(d3, d4, d)) <= 1 || n2 <= 1) && n < MAX_COORD_SEPARATION_INDEX);
        this._latLinesDegs = PointScaler.getLines(d5, d6, d, n2);
        this._lonLinesDegs = PointScaler.getLines(d3, d4, d, n3);
        this._latLinesScaled = new double[n2];
        int n4 = 0;
        while (n4 < n2) {
            this._latLinesScaled[n4] = this.getScaledLatitude(this._latLinesDegs[n4]);
            ++n4;
        }
        this._lonLinesScaled = new double[n3];
        n4 = 0;
        while (n4 < n3) {
            this._lonLinesScaled[n4] = this.getScaledLongitude(this._lonLinesDegs[n4]);
            ++n4;
        }
    }

    private static int getNumLinesBetween(double d, double d2, double d3) {
        double d4 = (int)d;
        if (d < 0.0) {
            d4 -= 1.0;
        }
        int n = 0;
        while (d4 < d2) {
            if (d4 >= d) {
                ++n;
            }
            d4 += d3;
        }
        return n;
    }

    private static double[] getLines(double d, double d2, double d3, int n) {
        double[] dArray = new double[n];
        double d4 = (int)d;
        if (d < 0.0) {
            d4 -= 1.0;
        }
        int n2 = 0;
        while (d4 < d2) {
            if (d4 >= d) {
                dArray[n2] = d4;
                ++n2;
            }
            d4 += d3;
        }
        return dArray;
    }

    public double[] getLatitudeLines() {
        return this._latLinesDegs;
    }

    public double[] getLongitudeLines() {
        return this._lonLinesDegs;
    }

    public double[] getScaledLatitudeLines() {
        return this._latLinesScaled;
    }

    public double[] getScaledLongitudeLines() {
        return this._lonLinesScaled;
    }
}

