/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.Distance;
import tim.prune.data.Selection;
import tim.prune.gui.DisplayUtils;

public class FullRangeDetails
extends GenericFunction {
    private JDialog _dialog = null;
    private JLabel _numSegsLabel = null;
    private JLabel _paceLabel = null;
    private JLabel _gradientLabel = null;
    private JLabel _movingDistanceLabel = null;
    private JLabel _aveMovingSpeedLabel = null;
    private static final NumberFormat FORMAT_ONE_DP = NumberFormat.getNumberInstance();
    private NumberFormat _distanceFormatter = NumberFormat.getInstance();

    public FullRangeDetails(App app) {
        super(app);
        FORMAT_ONE_DP.setMaximumFractionDigits(1);
        FORMAT_ONE_DP.setMinimumFractionDigits(1);
    }

    public String getNameKey() {
        return "function.fullrangedetails";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.updateDetails();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(5, 5));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.fullrangedetails.intro"));
        jLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2, 6, 2));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.range.numsegments")) + ": ");
        jLabel2.setHorizontalAlignment(4);
        jPanel2.add(jLabel2);
        this._numSegsLabel = new JLabel("100");
        jPanel2.add(this._numSegsLabel);
        JLabel jLabel3 = new JLabel(String.valueOf(I18nManager.getText("details.range.pace")) + ": ");
        jLabel3.setHorizontalAlignment(4);
        jPanel2.add(jLabel3);
        this._paceLabel = new JLabel("8 min/km");
        jPanel2.add(this._paceLabel);
        JLabel jLabel4 = new JLabel(String.valueOf(I18nManager.getText("details.range.gradient")) + ": ");
        jLabel4.setHorizontalAlignment(4);
        jPanel2.add(jLabel4);
        this._gradientLabel = new JLabel("10 %");
        jPanel2.add(this._gradientLabel);
        JLabel jLabel5 = new JLabel(String.valueOf(I18nManager.getText("fieldname.movingdistance")) + ": ");
        jLabel5.setHorizontalAlignment(4);
        jPanel2.add(jLabel5);
        this._movingDistanceLabel = new JLabel("5 km");
        jPanel2.add(this._movingDistanceLabel);
        JLabel jLabel6 = new JLabel(String.valueOf(I18nManager.getText("details.range.avemovingspeed")) + ": ");
        jLabel6.setHorizontalAlignment(4);
        jPanel2.add(jLabel6);
        this._aveMovingSpeedLabel = new JLabel("5 km/h");
        jPanel2.add(this._aveMovingSpeedLabel);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.close"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FullRangeDetails.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void updateDetails() {
        int n;
        Object object;
        Selection selection = this._app.getTrackInfo().getSelection();
        this._numSegsLabel.setText("" + selection.getNumSegments());
        if (selection.getNumSeconds() > 0L) {
            boolean bl = Config.getConfigBoolean("prune.metricunits");
            object = bl ? Distance.Units.KILOMETRES : Distance.Units.MILES;
            String string = I18nManager.getText(bl ? "units.kilometres.short" : "units.miles.short");
            this._paceLabel.setText(String.valueOf(DisplayUtils.buildDurationString((long)((double)selection.getNumSeconds() / selection.getDistance((Distance.Units)((Object)object))))) + " / " + string);
        } else {
            this._paceLabel.setText("");
        }
        Altitude altitude = this._app.getTrackInfo().getTrack().getPoint(selection.getStart()).getAltitude();
        object = this._app.getTrackInfo().getTrack().getPoint(selection.getEnd()).getAltitude();
        double d = selection.getDistance(Distance.Units.METRES);
        if (altitude.isValid() && ((Altitude)object).isValid() && d > 0.0) {
            n = ((Altitude)object).getValue(Altitude.Format.METRES) - altitude.getValue(Altitude.Format.METRES);
            double d2 = (double)n * 100.0 / d;
            this._gradientLabel.setText(String.valueOf(FORMAT_ONE_DP.format(d2)) + " %");
        } else {
            this._gradientLabel.setText("");
        }
        n = Config.getConfigBoolean("prune.metricunits");
        Distance.Units units = n != 0 ? Distance.Units.KILOMETRES : Distance.Units.MILES;
        String string = I18nManager.getText(n != 0 ? "units.kilometres.short" : "units.miles.short");
        String string2 = I18nManager.getText(n != 0 ? "units.kmh" : "units.mph");
        this._movingDistanceLabel.setText(String.valueOf(this.roundedNumber(selection.getMovingDistance(units))) + " " + string);
        long l = selection.getMovingSeconds();
        if (l > 0L) {
            this._aveMovingSpeedLabel.setText(String.valueOf(this.roundedNumber(selection.getMovingDistance(units) / (double)l * 3600.0)) + " " + string2);
        } else {
            this._aveMovingSpeedLabel.setText("");
        }
    }

    private String roundedNumber(double d) {
        int n = 0;
        if (d < 1.0) {
            n = 3;
        } else if (d < 10.0) {
            n = 2;
        } else if (d < 100.0) {
            n = 1;
        }
        this._distanceFormatter.setMaximumFractionDigits(n);
        this._distanceFormatter.setMinimumFractionDigits(n);
        return this._distanceFormatter.format(d);
    }
}

