/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.gui.GuiGridLayout;

public class PasteCoordinates
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _coordField = null;
    private JButton _okButton = null;
    private JComboBox _altUnitsDropDown;

    public PasteCoordinates(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.pastecoordinates";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._coordField.setText("");
        this._nameField.setText("");
        boolean bl = Config.getConfigBoolean("prune.metricunits");
        this._altUnitsDropDown.setSelectedIndex(bl ? 0 : 1);
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pastecoordinates.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._coordField = new JTextField("", 25);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PasteCoordinates.this.enableOK();
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                PasteCoordinates.this.enableOK();
            }
        };
        this._coordField.addKeyListener(keyAdapter);
        this._coordField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.pastecoordinates.coords"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._coordField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.openoptions.altitudeunits"));
        jLabel2.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel2);
        String[] stringArray = new String[]{I18nManager.getText("units.metres"), I18nManager.getText("units.feet")};
        this._altUnitsDropDown = new JComboBox<String>(stringArray);
        guiGridLayout.add(this._altUnitsDropDown);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.pointnameedit.name"));
        jLabel3.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel3);
        this._nameField = new JTextField("", 12);
        guiGridLayout.add(this._nameField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasteCoordinates.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        this._coordField.addActionListener(actionListener);
        this._nameField.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PasteCoordinates.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        String string = this._coordField.getText();
        this._okButton.setEnabled(string != null && string.length() > 10 && (string.indexOf(32) >= 0 || string.indexOf(44) >= 0));
    }

    private void finish() {
        DataPoint dataPoint = null;
        String[] stringArray = this._coordField.getText().split(",");
        if (stringArray.length == 2) {
            dataPoint = this.parseValues(stringArray[0].trim(), stringArray[1].trim(), null);
        } else if (stringArray.length == 3) {
            dataPoint = this.parseValues(stringArray[0].trim(), stringArray[1].trim(), stringArray[2].trim());
        } else {
            stringArray = this._coordField.getText().split(" ");
            if (stringArray.length == 2) {
                dataPoint = this.parseValues(stringArray[0], stringArray[1], null);
            } else if (stringArray.length == 3 && stringArray[1].length() == 1) {
                dataPoint = this.parseValues(stringArray[0], stringArray[2], null);
            } else if (stringArray.length == 4) {
                dataPoint = this.parseValues(String.valueOf(stringArray[0]) + " " + stringArray[1], String.valueOf(stringArray[2]) + " " + stringArray[3], null);
            } else if (stringArray.length == 6) {
                dataPoint = this.parseValues(String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2], String.valueOf(stringArray[3]) + " " + stringArray[4] + " " + stringArray[5], null);
            } else if (stringArray.length == 8) {
                dataPoint = this.parseValues(String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3], String.valueOf(stringArray[4]) + " " + stringArray[5] + " " + stringArray[6] + " " + stringArray[7], null);
            }
        }
        if (dataPoint == null) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.pastecoordinates.nothingfound"), I18nManager.getText(this.getNameKey()), 0);
        } else {
            String string = this._nameField.getText();
            if (string != null && string.length() > 0) {
                dataPoint.setFieldValue(Field.WAYPT_NAME, string, false);
            }
            this._app.createPoint(dataPoint);
            this._dialog.dispose();
        }
    }

    private DataPoint parseValues(String string, String string2, String string3) {
        Object object;
        Altitude altitude = null;
        if (string3 != null && !(altitude = new Altitude(string3, (Altitude.Format)((Object)(object = this._altUnitsDropDown.getSelectedIndex() == 0 ? Altitude.Format.METRES : Altitude.Format.FEET)))).isValid()) {
            altitude = null;
        }
        object = new Latitude(string);
        Longitude longitude = new Longitude(string2);
        if (((Coordinate)object).isValid() && !((Coordinate)object).getCardinalGuessed() && longitude.isValid() && !longitude.getCardinalGuessed()) {
            return new DataPoint((Coordinate)object, longitude, altitude);
        }
        Longitude longitude2 = new Longitude(string);
        Latitude latitude = new Latitude(string2);
        if (longitude2.isValid() && !longitude2.getCardinalGuessed() && latitude.isValid() && !latitude.getCardinalGuessed()) {
            return new DataPoint(latitude, longitude2, altitude);
        }
        if (((Coordinate)object).isValid() && longitude.isValid()) {
            return new DataPoint((Coordinate)object, longitude, altitude);
        }
        if (longitude2.isValid() && latitude.isValid()) {
            return new DataPoint(latitude, longitude2, altitude);
        }
        return null;
    }
}

