/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.edit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Track;
import tim.prune.function.edit.EditFieldsTableModel;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;

public class PointEditor {
    private App _app = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private JTable _table = null;
    private Track _track = null;
    private DataPoint _point = null;
    private EditFieldsTableModel _model = null;
    private JButton _editButton = null;
    private JButton _okButton = null;

    public PointEditor(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
    }

    public void showDialog(Track track, DataPoint dataPoint) {
        this._track = track;
        this._point = dataPoint;
        this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.pointedit.title"), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        FieldList fieldList = this._track.getFieldList();
        int n = fieldList.getNumFields();
        this._model = new EditFieldsTableModel(n);
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldList.getField(n2);
            this._model.addFieldInfo(field.getName(), this._point.getFieldValue(field), n2);
            ++n2;
        }
        this._dialog.getContentPane().add(this.makeDialogComponents());
        this._dialog.pack();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(1, 10));
        this._table = new JTable(this._model);
        this._table.setSelectionMode(0);
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                PointEditor.this._editButton.setEnabled(true);
            }
        });
        this._table.setPreferredScrollableViewportSize(new Dimension(this._table.getWidth(), this._table.getRowHeight() * 6));
        jPanel.add((Component)new JScrollPane(this._table), "Center");
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pointedit.text")), "North");
        this._editButton = new JButton(I18nManager.getText("button.edit"));
        this._editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = PointEditor.this._model.getValue(PointEditor.this._table.getSelectedRow());
                Object object = JOptionPane.showInputDialog(PointEditor.this._dialog, I18nManager.getText("dialog.pointedit.changevalue.text"), I18nManager.getText("dialog.pointedit.changevalue.title"), 3, null, null, string);
                if (object != null && PointEditor.this._model.updateValue(PointEditor.this._table.getSelectedRow(), object.toString())) {
                    PointEditor.this._okButton.setEnabled(true);
                }
            }
        });
        this._editButton.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this._editButton);
        jPanel.add((Component)jPanel2, "East");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointEditor.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.setEnabled(false);
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PointEditor.this.confirmEdit();
                PointEditor.this._dialog.dispose();
            }
        });
        jPanel3.add(this._okButton);
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private void confirmEdit() {
        FieldList fieldList = this._track.getFieldList();
        int n = fieldList.getNumFields();
        FieldEditList fieldEditList = new FieldEditList();
        FieldEditList fieldEditList2 = new FieldEditList();
        int n2 = 0;
        while (n2 < n) {
            if (this._model.getChanged(n2)) {
                Field field = fieldList.getField(n2);
                fieldEditList.addEdit(new FieldEdit(field, this._model.getValue(n2)));
                fieldEditList2.addEdit(new FieldEdit(field, this._point.getFieldValue(field)));
            }
            ++n2;
        }
        this._app.completePointEdit(fieldEditList, fieldEditList2);
    }
}

