/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.gpsies;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.function.browser.BrowserLauncher;
import tim.prune.function.gpsies.GpsiesTrack;
import tim.prune.function.gpsies.GpsiesXmlHandler;
import tim.prune.function.gpsies.TrackListModel;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.ZipFileLoader;

public class GetGpsiesFunction
extends GenericFunction
implements Runnable {
    private JDialog _dialog = null;
    private TrackListModel _trackListModel = null;
    private JTable _trackTable = null;
    private boolean _cancelled = false;
    private JLabel _statusLabel = null;
    private JTextArea _descriptionBox = null;
    private JButton _loadButton = null;
    private JButton _showButton = null;
    private static final int RESULTS_PER_PAGE = 20;
    private static final int MAX_RESULTS = 60;

    public GetGpsiesFunction(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.getgpsies";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    GetGpsiesFunction.this._cancelled = true;
                }
            });
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._trackListModel.clear();
        this._loadButton.setEnabled(false);
        this._showButton.setEnabled(false);
        this._cancelled = false;
        this._descriptionBox.setText("");
        new Thread(this).start();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._statusLabel = new JLabel(I18nManager.getText("confirm.running"));
        jPanel.add((Component)this._statusLabel, "North");
        this._trackListModel = new TrackListModel();
        this._trackTable = new JTable(this._trackListModel);
        this._trackTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    if (GetGpsiesFunction.this._trackTable.getSelectedRow() >= 0 && GetGpsiesFunction.this._trackTable.getSelectedRow() < GetGpsiesFunction.this._trackListModel.getRowCount()) {
                        GetGpsiesFunction.this._loadButton.setEnabled(true);
                        GetGpsiesFunction.this._showButton.setEnabled(true);
                        GetGpsiesFunction.this.setDescription(GetGpsiesFunction.this._trackListModel.getTrack(GetGpsiesFunction.this._trackTable.getSelectedRow()).getDescription());
                        GetGpsiesFunction.this._descriptionBox.setCaretPosition(0);
                    } else {
                        GetGpsiesFunction.this._descriptionBox.setText("");
                    }
                }
            }
        });
        this._trackTable.getColumnModel().getColumn(0).setPreferredWidth(300);
        this._trackTable.getColumnModel().getColumn(1).setPreferredWidth(70);
        JScrollPane jScrollPane = new JScrollPane(this._trackTable);
        jScrollPane.setPreferredSize(new Dimension(450, 200));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("dialog.gpsies.description")) + " :");
        jPanel2.add((Component)jLabel, "North");
        this._descriptionBox = new JTextArea(5, 20);
        this._descriptionBox.setEditable(false);
        this._descriptionBox.setLineWrap(true);
        this._descriptionBox.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this._descriptionBox);
        jScrollPane2.setPreferredSize(new Dimension(400, 80));
        jPanel2.add((Component)jScrollPane2, "Center");
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jPanel2);
        jSplitPane.setResizeWeight(1.0);
        jPanel.add((Component)jSplitPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._loadButton = new JButton(I18nManager.getText("button.load"));
        this._loadButton.setEnabled(false);
        this._loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetGpsiesFunction.this.loadSelectedTrack();
            }
        });
        jPanel3.add(this._loadButton);
        this._showButton = new JButton(I18nManager.getText("button.showwebpage"));
        this._showButton.setEnabled(false);
        this._showButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetGpsiesFunction.this.showSelectedTrack();
            }
        });
        jPanel3.add(this._showButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GetGpsiesFunction.this._cancelled = true;
                GetGpsiesFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void setDescription(String string) {
        String string2 = string;
        if (string == null || string.length() < 2) {
            string2 = I18nManager.getText("dialog.gpsies.nodescription");
        }
        this._descriptionBox.setText(string2);
    }

    public void run() {
        this._statusLabel.setText(I18nManager.getText("confirm.running"));
        double[] dArray = this._app.getViewport().getBounds();
        int n = 1;
        ArrayList<GpsiesTrack> arrayList = null;
        URL uRL = null;
        String string = "";
        InputStream inputStream = null;
        do {
            String string2 = "http://www.gpsies.com/api.do?BBOX=" + dArray[1] + "," + dArray[0] + "," + dArray[3] + "," + dArray[2] + "&limit=" + 20 + "&resultPage=" + n;
            GpsiesXmlHandler gpsiesXmlHandler = new GpsiesXmlHandler();
            try {
                uRL = new URL(string2);
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                inputStream = uRL.openStream();
                sAXParser.parse(inputStream, (DefaultHandler)gpsiesXmlHandler);
            }
            catch (Exception exception) {
                string = String.valueOf(exception.getClass().getName()) + " - " + exception.getMessage();
            }
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            arrayList = gpsiesXmlHandler.getTrackList();
            this._trackListModel.addTracks(arrayList);
            ++n;
        } while (arrayList != null && arrayList.size() == 20 && this._trackListModel.getRowCount() < 60 && !this._cancelled);
        if (string.equals("") && (arrayList == null || arrayList.size() == 0)) {
            string = I18nManager.getText("dialog.gpsies.nonefound");
        }
        this._statusLabel.setText(string);
    }

    private void loadSelectedTrack() {
        int n = this._trackTable.getSelectedRow();
        if (n >= 0 && n < this._trackListModel.getRowCount()) {
            String string = this._trackListModel.getTrack(n).getDownloadLink();
            XmlFileLoader xmlFileLoader = new XmlFileLoader(this._app);
            ZipFileLoader zipFileLoader = new ZipFileLoader(this._app, xmlFileLoader);
            try {
                zipFileLoader.openStream(new URL(string).openStream());
            }
            catch (IOException iOException) {
                System.err.println("IO Exception : " + iOException.getMessage());
            }
        }
        this._cancelled = true;
        this._dialog.dispose();
    }

    private void showSelectedTrack() {
        int n = this._trackTable.getSelectedRow();
        if (n >= 0 && n < this._trackListModel.getRowCount()) {
            String string = this._trackListModel.getTrack(n).getFileId();
            BrowserLauncher.launchBrowser("http://gpsies.com/map.do?fileId=" + string);
        }
        this._cancelled = true;
        this._dialog.dispose();
    }
}

