/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

public class MapPosition {
    private static final int MAP_TILE_SIZE = 256;
    private long _xPosition = 0L;
    private long _yPosition = 0L;
    private int _zoom = 12;
    private int _zoomFactor = 1 << this._zoom;
    private static final int MAX_ZOOM = 21;

    public void zoomToXY(double d, double d2, double d3, double d4, int n, int n2) {
        double d5 = Math.abs(d2 - d);
        double d6 = Math.abs(d4 - d3);
        int n3 = -1;
        int n4 = 21;
        while (n4 >= 2) {
            if (MapPosition.transformToPixels(d5, n4) < (long)n && MapPosition.transformToPixels(d6, n4) < (long)n2) {
                n3 = n4;
                break;
            }
            --n4;
        }
        if (n3 < 2) {
            n3 = 2;
        }
        this._zoom = n3;
        this._zoomFactor = 1 << this._zoom;
        this._xPosition = this.transformToPixels((d + d2) / 2.0);
        this._yPosition = this.transformToPixels((d3 + d4) / 2.0);
    }

    public void zoomToPixels(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = Math.abs(n2 - n);
        int n8 = Math.abs(n4 - n3);
        int n9 = -1;
        int n10 = 0;
        int n11 = 21;
        while (n11 >= this._zoom) {
            n10 = 1 << n11 - this._zoom;
            if (n7 * n10 < n5 && n8 * n10 < n6) {
                n9 = n11;
                break;
            }
            --n11;
        }
        this._zoom = n9;
        this._zoomFactor = 1 << this._zoom;
        this._xPosition = (this._xPosition - (long)(n5 / 2) + (long)((n + n2) / 2)) * (long)n10;
        this._yPosition = (this._yPosition - (long)(n6 / 2) + (long)((n3 + n4) / 2)) * (long)n10;
    }

    private long transformToPixels(double d) {
        return MapPosition.transformToPixels(d, this._zoom);
    }

    private static long transformToPixels(double d, int n) {
        return (long)(d * 256.0 * (double)(1 << n));
    }

    public double getXFromPixels(int n, int n2) {
        return (double)((long)(n - n2 / 2) + this._xPosition) * 1.0 / 256.0 / (double)this._zoomFactor;
    }

    public double getYFromPixels(int n, int n2) {
        return (double)((long)(n - n2 / 2) + this._yPosition) * 1.0 / 256.0 / (double)this._zoomFactor;
    }

    public int getXFromCentre(double d) {
        return (int)(this.transformToPixels(d) - this._xPosition);
    }

    public int getYFromCentre(double d) {
        return (int)(this.transformToPixels(d) - this._yPosition);
    }

    public double getBoundsFromPixels(int n) {
        return (double)n * 1.0 / 256.0 / (double)this._zoomFactor;
    }

    public int[] getTileIndices(int n, int n2) {
        int[] nArray = new int[]{this.getTileIndex(this._xPosition - (long)(n / 2)), this.getTileIndex(this._xPosition + (long)(n / 2)), this.getTileIndex(this._yPosition - (long)(n2 / 2)), this.getTileIndex(this._yPosition + (long)(n2 / 2))};
        return nArray;
    }

    public int[] getDisplayOffsets(int n, int n2) {
        int[] nArray = new int[]{this.getDisplayOffset(this._xPosition - (long)(n / 2)), this.getDisplayOffset(this._yPosition - (long)(n2 / 2))};
        return nArray;
    }

    public int getCentreTileX() {
        return this.getTileIndex(this._xPosition);
    }

    public int getCentreTileY() {
        return this.getTileIndex(this._yPosition);
    }

    private int getTileIndex(long l) {
        return (int)(l / 256L);
    }

    private int getDisplayOffset(long l) {
        return (int)(l % 256L);
    }

    public void zoomIn() {
        if (this._zoom < 21) {
            ++this._zoom;
            this._zoomFactor = 1 << this._zoom;
            this._xPosition *= 2L;
            this._yPosition *= 2L;
        }
    }

    public void zoomOut() {
        if (this._zoom >= 2) {
            --this._zoom;
            this._zoomFactor = 1 << this._zoom;
            this._xPosition /= 2L;
            this._yPosition /= 2L;
        }
    }

    public int getZoom() {
        return this._zoom;
    }

    public void pan(int n, int n2) {
        this._xPosition += (long)n;
        this._yPosition += (long)n2;
    }
}

