/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import tim.prune.gui.map.MapCanvas;
import tim.prune.gui.map.MapTileConfig;

public class MapTileCacher
implements ImageObserver {
    private MapCanvas _parent = null;
    private Image[] _tiles = new Image[225];
    private int _zoom = -1;
    private int _tileX = -1;
    private int _tileY = -1;
    private int _gridCentreX = 0;
    private int _gridCentreY = 0;
    private MapTileConfig _tileConfig = null;
    private static final int GRID_SIZE = 15;
    private static final int MAX_TILE_ZOOM = 18;

    public MapTileCacher(MapCanvas mapCanvas) {
        this._parent = mapCanvas;
    }

    public void centreMap(int n, int n2, int n3) {
        int n4 = Math.max(Math.abs(n2 - this._tileX), Math.abs(n3 - this._tileY));
        if (n4 == 0) {
            return;
        }
        if (n != this._zoom || n4 > 7) {
            this._zoom = n;
            this.clearAll();
        }
        this._gridCentreX = MapTileCacher.getCacheCoordinate(this._gridCentreX + n2 - this._tileX);
        this._gridCentreY = MapTileCacher.getCacheCoordinate(this._gridCentreY + n3 - this._tileY);
        this._tileX = n2;
        this._tileY = n3;
        int n5 = 0;
        while (n5 < 15) {
            this._tiles[this.getArrayIndex((int)(this._tileX + 7 + 1), (int)(this._tileY + n5 - 7))] = null;
            this._tiles[this.getArrayIndex((int)(this._tileX + n5 - 7), (int)(this._tileY + 7 + 1))] = null;
            ++n5;
        }
    }

    public void clearAll() {
        int n = 0;
        while (n < this._tiles.length) {
            this._tiles[n] = null;
            ++n;
        }
    }

    public Image getTile(int n, int n2) {
        int n3;
        Image image;
        if (this._tileConfig == null) {
            this._tileConfig = new MapTileConfig();
        }
        if ((image = this._tiles[n3 = this.getArrayIndex(n, n2)]) != null) {
            return image;
        }
        if (this.isOverzoomed()) {
            return null;
        }
        int n4 = MapTileCacher.getUrlCoordinate(n, this._zoom);
        int n5 = MapTileCacher.getUrlCoordinate(n2, this._zoom);
        try {
            String string = String.valueOf(this._tileConfig.getUrl()) + this._zoom + "/" + n4 + "/" + n5 + ".png";
            this._tiles[n3] = image = Toolkit.getDefaultToolkit().createImage(new URL(string));
            if (image.getWidth(this) > 0) {
                return image;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    public boolean isOverzoomed() {
        return this._zoom > 18;
    }

    private int getArrayIndex(int n, int n2) {
        int n3 = MapTileCacher.getCacheCoordinate(n - this._tileX + this._gridCentreX);
        int n4 = MapTileCacher.getCacheCoordinate(n2 - this._tileY + this._gridCentreY);
        return n3 + n4 * 15;
    }

    private static int getCacheCoordinate(int n) {
        int n2 = n;
        while (n2 >= 15) {
            n2 -= 15;
        }
        while (n2 < 0) {
            n2 += 15;
        }
        return n2;
    }

    private static int getUrlCoordinate(int n, int n2) {
        int n3 = 1 << n2;
        int n4 = n;
        while (n4 >= n3) {
            n4 -= n3;
        }
        while (n4 < 0) {
            n4 += n3;
        }
        return n4;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Grid centre (" + this._gridCentreX + "," + this._gridCentreY + ") - (" + this._tileX + "," + this._tileY + ")\n");
        int n = 0;
        while (n < 15) {
            int n2 = 0;
            while (n2 < 15) {
                if (n == this._gridCentreY && n2 == this._gridCentreX) {
                    stringBuffer.append(this._tiles[n2 + n * 15] == null ? "c" : "C");
                } else {
                    stringBuffer.append(this._tiles[n2 + n * 15] == null ? "." : "*");
                }
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        boolean bl2 = (n & 0x20) > 0;
        boolean bl3 = bl = (n & 0x40) > 0;
        if (bl2 || bl) {
            this._parent.tilesUpdated(bl2);
        }
        return !bl2;
    }

    public void setTileConfig(MapTileConfig mapTileConfig) {
        this._tileConfig = mapTileConfig;
        this.clearAll();
    }
}

