/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import tim.prune.App;
import tim.prune.data.Altitude;
import tim.prune.data.Field;
import tim.prune.data.SourceInfo;
import tim.prune.load.NmeaMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NmeaFileLoader {
    private App _app = null;

    public NmeaFileLoader(App app) {
        this._app = app;
    }

    public void openFile(File file) {
        ArrayList<NmeaMessage> arrayList;
        block18: {
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList<NmeaMessage>();
            try {
                try {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    String string = bufferedReader.readLine();
                    boolean bl = true;
                    while (string != null) {
                        NmeaMessage nmeaMessage;
                        if (string.trim().length() > 0 && (nmeaMessage = NmeaFileLoader.processLine(string)) != null) {
                            if (nmeaMessage.hasFix()) {
                                nmeaMessage.setSegment(bl);
                                arrayList.add(nmeaMessage);
                            }
                            bl = !nmeaMessage.hasFix();
                        }
                        string = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    this._app.showErrorMessage("error.load.dialogtitle", "error.load.noread");
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block18;
                    }
                    catch (Exception exception) {}
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        if (arrayList.size() > 0) {
            this._app.informDataLoaded(this.getFieldArray(), NmeaFileLoader.makeDataArray(arrayList), Altitude.Format.METRES, new SourceInfo(file, SourceInfo.FILE_TYPE.NMEA));
        }
    }

    private static NmeaMessage processLine(String string) {
        if (string == null || string.length() < 20 || !string.startsWith("$GPGGA")) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray != null && stringArray.length >= 10) {
            return new NmeaMessage(String.valueOf(stringArray[2]) + stringArray[3], String.valueOf(stringArray[4]) + stringArray[5], stringArray[9], stringArray[1], stringArray[6]);
        }
        return null;
    }

    private static Object[][] makeDataArray(ArrayList<NmeaMessage> arrayList) {
        Object[][] objectArray = new Object[arrayList.size()][];
        int n = 0;
        while (n < arrayList.size()) {
            objectArray[n] = arrayList.get(n).getStrings();
            ++n;
        }
        return objectArray;
    }

    public Field[] getFieldArray() {
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.TIMESTAMP, Field.NEW_SEGMENT};
        return fieldArray;
    }
}

