/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.data.DataPoint;
import tim.prune.data.SourceInfo;

public class GpxCacher
extends DefaultHandler {
    private SourceInfo _sourceInfo = null;
    private String _headerString = null;
    private String[] _strings = null;
    private int _pointNum = 0;
    private boolean _insidePoint = false;
    private StringBuilder _builder = null;

    public GpxCacher(SourceInfo sourceInfo) {
        this._sourceInfo = sourceInfo;
        this._strings = new String[sourceInfo.getNumPoints()];
        this._pointNum = 0;
        File file = sourceInfo.getFile();
        String string = file.getName().toLowerCase();
        if (file.exists() && file.canRead()) {
            try {
                SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
                if (string.endsWith(".gpx") || string.endsWith(".xml")) {
                    sAXParser.parse(sourceInfo.getFile(), (DefaultHandler)this);
                } else if (string.endsWith(".zip")) {
                    sAXParser.parse(GpxCacher.getZipInputStream(sourceInfo.getFile()), (DefaultHandler)this);
                } else if (string.endsWith(".gz")) {
                    sAXParser.parse((InputStream)new GZIPInputStream(new FileInputStream(sourceInfo.getFile())), (DefaultHandler)this);
                } else {
                    System.out.println("Unrecognised file type: " + sourceInfo.getFile().getName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this._builder = null;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("gpx")) {
            this._builder = new StringBuilder(60);
            GpxCacher.appendTag(this._builder, string3, attributes);
            this._headerString = this._builder.toString();
        } else {
            if (string3.equalsIgnoreCase("wpt") || string3.equalsIgnoreCase("trkpt") || string3.equalsIgnoreCase("rtept")) {
                this._insidePoint = true;
                this._builder = new StringBuilder(60);
            }
            if (this._insidePoint) {
                GpxCacher.appendTag(this._builder, string3, attributes);
            }
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this._insidePoint) {
            this._builder.append(new String(cArray, n, n2));
        }
        super.characters(cArray, n, n2);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this._insidePoint) {
            this._builder.append("</").append(string3).append('>');
        }
        if (string3.equalsIgnoreCase("wpt") || string3.equalsIgnoreCase("trkpt") || string3.equalsIgnoreCase("rtept")) {
            this._strings[this._pointNum] = this._builder.toString();
            ++this._pointNum;
            this._insidePoint = false;
        }
        super.endElement(string, string2, string3);
    }

    private static void appendTag(StringBuilder stringBuilder, String string, Attributes attributes) {
        stringBuilder.append('<').append(string);
        int n = attributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(' ').append(attributes.getQName(n2)).append("=\"").append(attributes.getValue(n2)).append('\"');
            ++n2;
        }
        stringBuilder.append('>');
    }

    public String getHeaderString() {
        return this._headerString;
    }

    public String getSourceString(DataPoint dataPoint) {
        int n = this._sourceInfo.getIndex(dataPoint);
        if (n >= 0) {
            return this._strings[n];
        }
        return null;
    }

    private static InputStream getZipInputStream(File file) {
        try {
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));
            while (zipInputStream.available() > 0) {
                String string;
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                String string2 = zipEntry.toString();
                if (string2 == null || string2.length() <= 4 || !(string = string2.substring(string2.length() - 4).toLowerCase()).equals(".gpx") && !string.equals(".xml")) continue;
                return zipInputStream;
            }
        }
        catch (Exception exception) {}
        return null;
    }
}

