/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.ColourUtils;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.ColourChooser;
import tim.prune.gui.ColourPatch;
import tim.prune.gui.ImageUtils;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;

public class KmlExporter
extends GenericFunction
implements Runnable {
    private TrackInfo _trackInfo = null;
    private Track _track = null;
    private JDialog _dialog = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _altitudesCheckbox = null;
    private JCheckBox _kmzCheckbox = null;
    private JCheckBox _exportImagesCheckbox = null;
    private ColourPatch _colourPatch = null;
    private JLabel _progressLabel = null;
    private JProgressBar _progressBar = null;
    private Dimension[] _imageDimensions = null;
    private JFileChooser _fileChooser = null;
    private File _exportFile = null;
    private JButton _okButton = null;
    private boolean _cancelPressed = false;
    private ColourChooser _colourChooser = null;
    private static final String KML_FILENAME_IN_KMZ = "doc.kml";
    private static final int DEFAULT_THUMBNAIL_WIDTH = 240;
    private static final int DEFAULT_THUMBNAIL_HEIGHT = 240;
    private static int THUMBNAIL_WIDTH = 0;
    private static int THUMBNAIL_HEIGHT = 0;
    private static final Color DEFAULT_TRACK_COLOUR = new Color(204, 0, 0);

    public KmlExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
        this._track = this._trackInfo.getTrack();
    }

    public String getNameKey() {
        return "function.exportkml";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
            this._colourChooser = new ColourChooser(this._dialog);
        }
        this.enableCheckboxes();
        this._descriptionField.setEnabled(true);
        this._okButton.setEnabled(true);
        this._progressLabel.setText("");
        this._progressBar.setVisible(false);
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 5));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportkml.text")));
        this._descriptionField = new JTextField(20);
        jPanel3.add(this._descriptionField);
        jPanel3.setAlignmentX(0.5f);
        jPanel2.add(jPanel3);
        jPanel.add((Component)jPanel2, "Center");
        this._pointTypeSelector = new PointTypeSelector();
        this._pointTypeSelector.setAlignmentX(0.5f);
        jPanel2.add(this._pointTypeSelector);
        Color color = ColourUtils.colourFromHex(Config.getConfigString("prune.kmltrackcolour"));
        if (color == null) {
            color = DEFAULT_TRACK_COLOUR;
        }
        this._colourPatch = new ColourPatch(color);
        this._colourPatch.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                KmlExporter.this._colourChooser.showDialog(KmlExporter.this._colourPatch.getBackground());
                Color color = KmlExporter.this._colourChooser.getChosenColour();
                if (color != null) {
                    KmlExporter.this._colourPatch.setColour(color);
                }
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.add(new JLabel(I18nManager.getText("dialog.exportkml.trackcolour")));
        jPanel4.add(this._colourPatch);
        jPanel2.add(jPanel4);
        this._altitudesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.altitude"));
        this._altitudesCheckbox.setHorizontalTextPosition(2);
        this._altitudesCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._altitudesCheckbox);
        this._kmzCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.kmz"));
        this._kmzCheckbox.setHorizontalTextPosition(2);
        this._kmzCheckbox.setAlignmentX(0.5f);
        this._kmzCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this.enableCheckboxes();
            }
        });
        jPanel2.add(this._kmzCheckbox);
        this._exportImagesCheckbox = new JCheckBox(I18nManager.getText("dialog.exportkml.exportimages"));
        this._exportImagesCheckbox.setHorizontalTextPosition(2);
        this._exportImagesCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._exportImagesCheckbox);
        jPanel2.add(Box.createVerticalStrut(10));
        this._progressLabel = new JLabel("...");
        this._progressLabel.setAlignmentX(0.5f);
        jPanel2.add(this._progressLabel);
        this._progressBar = new JProgressBar(0, 100);
        this._progressBar.setVisible(false);
        this._progressBar.setAlignmentX(0.5f);
        jPanel2.add(this._progressBar);
        jPanel2.add(Box.createVerticalStrut(10));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this.startExport();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel5.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KmlExporter.this._cancelPressed = true;
                KmlExporter.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton);
        jPanel.add((Component)jPanel5, "South");
        return jPanel;
    }

    private void enableCheckboxes() {
        this._pointTypeSelector.init(this._trackInfo);
        boolean bl = this._track.hasData(Field.ALTITUDE);
        if (!bl) {
            this._altitudesCheckbox.setSelected(false);
        }
        boolean bl2 = this._trackInfo.getPhotoList() != null && this._trackInfo.getPhotoList().getNumPhotos() > 0;
        this._exportImagesCheckbox.setSelected(bl2 && this._kmzCheckbox.isSelected());
        this._exportImagesCheckbox.setEnabled(bl2 && this._kmzCheckbox.isSelected());
    }

    private void startExport() {
        String string;
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser();
            this._fileChooser.setDialogType(1);
            this._fileChooser.setFileFilter(new GenericFileFilter("filetype.kmlkmz", new String[]{"kml", "kmz"}));
            string = Config.getConfigString("prune.trackdirectory");
            if (string != null) {
                this._fileChooser.setCurrentDirectory(new File(string));
            }
        }
        string = null;
        String string2 = null;
        if (this._kmzCheckbox.isSelected()) {
            string = ".kmz";
            string2 = ".kml";
        } else {
            string = ".kml";
            string2 = ".kmz";
        }
        this._fileChooser.setAcceptAllFileFilterUsed(false);
        boolean bl = false;
        do {
            Object[] objectArray;
            bl = false;
            if (this._fileChooser.showSaveDialog(this._parentFrame) != 0) continue;
            File file = this._fileChooser.getSelectedFile();
            if (file.getName().toLowerCase().endsWith(string2)) {
                objectArray = file.getAbsolutePath();
                file = new File(String.valueOf(objectArray.substring(0, objectArray.length() - string2.length())) + string);
            } else if (!file.getName().toLowerCase().endsWith(string)) {
                file = new File(String.valueOf(file.getAbsolutePath()) + string);
            }
            objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file.exists() || JOptionPane.showOptionDialog(this._parentFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                this._exportFile = file;
                this._cancelPressed = false;
                new Thread(this).start();
                continue;
            }
            bl = true;
        } while (bl);
    }

    public void run() {
        this._okButton.setEnabled(false);
        this._descriptionField.setEnabled(false);
        this._progressLabel.setText(I18nManager.getText("confirm.running"));
        this._progressBar.setVisible(true);
        this._progressBar.setValue(0);
        boolean bl = this._kmzCheckbox.isSelected();
        boolean bl2 = bl && this._exportImagesCheckbox.isSelected();
        this._progressBar.setMaximum(bl2 ? this.getNumPhotosToExport() : 1);
        THUMBNAIL_WIDTH = Config.getConfigInt("prune.kmzimagewidth");
        if (THUMBNAIL_WIDTH < 240) {
            THUMBNAIL_WIDTH = 240;
        }
        if ((THUMBNAIL_HEIGHT = Config.getConfigInt("prune.kmzimageheight")) < 240) {
            THUMBNAIL_HEIGHT = 240;
        }
        this._imageDimensions = new Dimension[this._track.getNumPoints()];
        OutputStreamWriter outputStreamWriter = null;
        ZipOutputStream zipOutputStream = null;
        try {
            if (!this._kmzCheckbox.isSelected()) {
                outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            } else {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(this._exportFile));
                if (bl2) {
                    this.exportThumbnails(zipOutputStream);
                }
                outputStreamWriter = new OutputStreamWriter(zipOutputStream);
                ZipEntry zipEntry = new ZipEntry(KML_FILENAME_IN_KMZ);
                zipOutputStream.putNextEntry(zipEntry);
            }
            int n = this.exportData(outputStreamWriter, bl2);
            Config.setConfigString("prune.kmltrackcolour", ColourUtils.makeHexCode(this._colourPatch.getBackground()));
            this._progressBar.setValue(1);
            if (zipOutputStream != null) {
                outputStreamWriter.flush();
                zipOutputStream.closeEntry();
            }
            outputStreamWriter.close();
            this._imageDimensions = null;
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    private int exportData(OutputStreamWriter outputStreamWriter, boolean bl) throws IOException {
        boolean bl2 = this._pointTypeSelector.getTrackpointsSelected();
        boolean bl3 = this._pointTypeSelector.getWaypointsSelected();
        boolean bl4 = this._pointTypeSelector.getPhotopointsSelected();
        boolean bl5 = this._pointTypeSelector.getJustSelection();
        outputStreamWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.1\">\n<Folder>\n");
        outputStreamWriter.write("\t<name>");
        if (this._descriptionField != null && this._descriptionField.getText() != null && !this._descriptionField.getText().equals("")) {
            outputStreamWriter.write(this._descriptionField.getText());
        } else {
            outputStreamWriter.write("Export from Prune");
        }
        outputStreamWriter.write("</name>\n");
        int n = -1;
        int n2 = -1;
        if (bl5) {
            n = this._trackInfo.getSelection().getStart();
            n2 = this._trackInfo.getSelection().getEnd();
        }
        boolean bl6 = this._altitudesCheckbox.isSelected();
        int n3 = 0;
        DataPoint dataPoint = null;
        boolean bl7 = false;
        boolean bl8 = false;
        int n4 = this._track.getNumPoints();
        int n5 = 0;
        int n6 = 0;
        n3 = 0;
        while (n3 < n4) {
            boolean bl9;
            dataPoint = this._track.getPoint(n3);
            boolean bl10 = bl9 = !bl5 || n3 >= n && n3 <= n2;
            if (dataPoint.isWaypoint()) {
                if (bl3 && bl9) {
                    this.exportWaypoint(dataPoint, outputStreamWriter, bl6);
                    ++n5;
                }
            } else if (dataPoint.getPhoto() == null) {
                bl7 = true;
            }
            if (dataPoint.getPhoto() != null && bl4 && bl9) {
                if (!bl8) {
                    outputStreamWriter.write("<Style id=\"camera_icon\"><IconStyle><Icon><href>http://maps.google.com/mapfiles/kml/pal4/icon46.png</href></Icon></IconStyle></Style>");
                    bl8 = true;
                }
                this.exportPhotoPoint(dataPoint, outputStreamWriter, bl, n3, ++n6, bl6);
                ++n5;
            }
            ++n3;
        }
        if (bl7 && bl2) {
            String string = "\t<Placemark>\n\t\t<name>track</name>\n\t\t<Style>\n\t\t\t<LineStyle>\n\t\t\t\t<color>cc" + KmlExporter.reverse(ColourUtils.makeHexCode(this._colourPatch.getBackground())) + "</color>\n" + "\t\t\t\t<width>4</width>\n\t\t\t</LineStyle>\n" + "\t\t\t<PolyStyle><color>33cc0000</color></PolyStyle>\n" + "\t\t</Style>\n\t\t<LineString>\n";
            string = bl6 ? String.valueOf(string) + "\t\t\t<extrude>1</extrude>\n\t\t\t<altitudeMode>absolute</altitudeMode>\n" : String.valueOf(string) + "\t\t\t<altitudeMode>clampToGround</altitudeMode>\n";
            string = String.valueOf(string) + "\t\t\t<coordinates>";
            String string2 = "\t\t\t</coordinates>\n\t\t</LineString>\n\t</Placemark>";
            outputStreamWriter.write(string);
            boolean bl11 = true;
            n3 = 0;
            while (n3 < n4) {
                boolean bl12;
                dataPoint = this._track.getPoint(n3);
                boolean bl13 = bl12 = !bl5 || n3 >= n && n3 <= n2;
                if (!dataPoint.isWaypoint() && bl12) {
                    if (dataPoint.getSegmentStart() && !bl11) {
                        outputStreamWriter.write(string2);
                        outputStreamWriter.write(string);
                    }
                    if (dataPoint.getPhoto() == null) {
                        this.exportTrackpoint(dataPoint, outputStreamWriter);
                        ++n5;
                        bl11 = false;
                    }
                }
                ++n3;
            }
            outputStreamWriter.write(string2);
        }
        outputStreamWriter.write("</Folder>\n</kml>");
        return n5;
    }

    private static String reverse(String string) {
        return String.valueOf(string.substring(4, 6)) + string.substring(2, 4) + string.substring(0, 2);
    }

    private void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(dataPoint.getWaypointName().trim());
        writer.write("</name>\n");
        writer.write("\t\t<Point>\n");
        if (bl && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        } else {
            writer.write("\t\t\t<altitudeMode>clampToGround</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    private void exportPhotoPoint(DataPoint dataPoint, Writer writer, boolean bl, int n, int n2, boolean bl2) throws IOException {
        writer.write("\t<Placemark>\n\t\t<name>");
        writer.write(dataPoint.getPhoto().getFile().getName());
        writer.write("</name>\n");
        if (bl) {
            Dimension dimension = this._imageDimensions[n];
            writer.write("<description><![CDATA[<br/><table border='0'><tr><td><center><img src='images/image" + n2 + ".jpg' width='" + dimension.width + "' height='" + dimension.height + "'></center></td></tr>" + "<tr><td><center>" + dataPoint.getPhoto().getFile().getName() + "</center></td></tr></table>]]></description>");
        }
        writer.write("<styleUrl>#camera_icon</styleUrl>\n");
        writer.write("\t\t<Point>\n");
        if (bl2 && dataPoint.hasAltitude()) {
            writer.write("\t\t\t<altitudeMode>absolute</altitudeMode>\n");
        } else {
            writer.write("\t\t\t<altitudeMode>clampToGround</altitudeMode>\n");
        }
        writer.write("\t\t\t<coordinates>");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("</coordinates>\n\t\t</Point>\n\t</Placemark>\n");
    }

    private void exportTrackpoint(DataPoint dataPoint, Writer writer) throws IOException {
        writer.write(dataPoint.getLongitude().output(17));
        writer.write(44);
        writer.write(dataPoint.getLatitude().output(17));
        writer.write(",");
        if (dataPoint.hasAltitude()) {
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        } else {
            writer.write("0");
        }
        writer.write("\n");
    }

    private void exportThumbnails(ZipOutputStream zipOutputStream) throws IOException {
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpg");
        if (iterator == null || !iterator.hasNext()) {
            throw new IOException("no JPEG writer found");
        }
        ImageWriter imageWriter = iterator.next();
        boolean bl = this._pointTypeSelector.getJustSelection();
        int n = -1;
        int n2 = -1;
        if (bl) {
            n = this._trackInfo.getSelection().getStart();
            n2 = this._trackInfo.getSelection().getEnd();
        }
        int n3 = this._track.getNumPoints();
        DataPoint dataPoint = null;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3 && !this._cancelPressed) {
            dataPoint = this._track.getPoint(n5);
            if (dataPoint.getPhoto() != null && (!bl || n5 >= n && n5 <= n2)) {
                ZipEntry zipEntry = new ZipEntry("images/image" + ++n4 + ".jpg");
                zipOutputStream.putNextEntry(zipEntry);
                ImageIcon imageIcon = new ImageIcon(dataPoint.getPhoto().getFile().getAbsolutePath());
                BufferedImage bufferedImage = ImageUtils.rotateImage(imageIcon.getImage(), THUMBNAIL_WIDTH, THUMBNAIL_HEIGHT, dataPoint.getPhoto().getRotationDegrees());
                this._imageDimensions[n5] = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
                imageWriter.setOutput(ImageIO.createImageOutputStream(zipOutputStream));
                imageWriter.write(bufferedImage);
                zipOutputStream.closeEntry();
                this._progressBar.setValue(n4 + 1);
            }
            ++n5;
        }
    }

    private int getNumPhotosToExport() {
        int n = this._track.getNumPoints();
        int n2 = 0;
        DataPoint dataPoint = null;
        int n3 = 0;
        while (n3 < n) {
            dataPoint = this._track.getPoint(n3);
            if (dataPoint.getPhoto() != null) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }
}

