/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.data.TrackInfo;

public class PointTypeSelector
extends JPanel {
    private JCheckBox[] _checkboxes = new JCheckBox[4];

    public PointTypeSelector() {
        this.createComponents();
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
    }

    private void createComponents() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(I18nManager.getText("dialog.pointtype.desc")), "North");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 15, 3));
        String[] stringArray = new String[]{"track", "waypoint", "photo"};
        int n = 0;
        while (n < 3) {
            this._checkboxes[n] = new JCheckBox(I18nManager.getText("dialog.pointtype." + stringArray[n]));
            this._checkboxes[n].setSelected(true);
            jPanel.add(this._checkboxes[n]);
            ++n;
        }
        this.add((Component)jPanel, "Center");
        this._checkboxes[3] = new JCheckBox(I18nManager.getText("dialog.pointtype.selection"));
        this.add((Component)this._checkboxes[3], "South");
    }

    public void init(TrackInfo trackInfo) {
        boolean[] blArray = new boolean[]{trackInfo.getTrack().hasTrackPoints(), trackInfo.getTrack().hasWaypoints(), trackInfo.getPhotoList().getNumPhotos() > 0};
        int n = 0;
        while (n < 3) {
            if (blArray[n]) {
                this._checkboxes[n].setEnabled(true);
            } else {
                this._checkboxes[n].setSelected(false);
                this._checkboxes[n].setEnabled(false);
            }
            ++n;
        }
        this._checkboxes[3].setEnabled(trackInfo.getSelection().hasRangeSelected());
        this._checkboxes[3].setSelected(false);
    }

    public boolean getTrackpointsSelected() {
        return this._checkboxes[0].isSelected();
    }

    public boolean getWaypointsSelected() {
        return this._checkboxes[1].isSelected();
    }

    public boolean getPhotopointsSelected() {
        return this._checkboxes[2].isSelected();
    }

    public boolean getJustSelection() {
        return this._checkboxes[3].isSelected();
    }

    public boolean getAnythingSelected() {
        return this.getTrackpointsSelected() || this.getWaypointsSelected() || this.getPhotopointsSelected();
    }
}

