/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.threedee;

import com.sun.j3d.utils.behaviors.vp.OrbitBehavior;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.geometry.Box;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.data.Altitude;
import tim.prune.data.Track;
import tim.prune.threedee.LineDialog;
import tim.prune.threedee.ThreeDException;
import tim.prune.threedee.ThreeDModel;
import tim.prune.threedee.ThreeDWindow;

public class Java3DWindow
implements ThreeDWindow {
    private Track _track = null;
    private JFrame _parentFrame = null;
    private JFrame _frame = null;
    private ThreeDModel _model = null;
    private OrbitBehavior _orbit = null;
    private int _altitudeCap = 100;
    private static boolean TRACK_SIZE_WARNING_GIVEN = false;
    private static final double INITIAL_Y_ROTATION = -25.0;
    private static final double INITIAL_X_ROTATION = 15.0;
    private static final String CARDINALS_FONT = "Arial";
    private static final int MAX_TRACK_SIZE = 2500;

    public Java3DWindow(JFrame jFrame) {
        this._parentFrame = jFrame;
    }

    public void setTrack(Track track) {
        this._track = track;
    }

    public void show() throws ThreeDException {
        Object[] objectArray;
        String string = Java3DWindow.getAltitudeUnitsLabel(this._track);
        Object object = JOptionPane.showInputDialog(this._parentFrame, String.valueOf(I18nManager.getText("dialog.3d.altitudecap")) + " (" + string + ")", I18nManager.getText("dialog.3d.title"), 3, null, null, "" + this._altitudeCap);
        if (object == null) {
            return;
        }
        try {
            this._altitudeCap = Integer.parseInt(object.toString());
        }
        catch (Exception exception) {}
        GraphicsConfiguration graphicsConfiguration = SimpleUniverse.getPreferredConfiguration();
        if (graphicsConfiguration == null) {
            objectArray = new GraphicsConfigTemplate3D();
            objectArray.setDepthSize(0);
            graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration((GraphicsConfigTemplate)objectArray);
        }
        if (graphicsConfiguration == null) {
            throw new ThreeDException("Couldn't create graphics config");
        }
        objectArray = new Object[]{I18nManager.getText("button.continue"), I18nManager.getText("button.cancel")};
        if (this._track.getNumPoints() > 2500 && !TRACK_SIZE_WARNING_GIVEN) {
            if (JOptionPane.showOptionDialog(this._frame, I18nManager.getText("dialog.exportpov.warningtracksize"), I18nManager.getText("function.exportpov"), 2, 2, null, objectArray, objectArray[1]) == 0) {
                TRACK_SIZE_WARNING_GIVEN = true;
            } else {
                return;
            }
        }
        Canvas3D canvas3D = new Canvas3D(graphicsConfiguration);
        canvas3D.setSize(400, 300);
        BranchGroup branchGroup = this.createSceneGraph();
        SimpleUniverse simpleUniverse = new SimpleUniverse(canvas3D);
        simpleUniverse.getViewingPlatform().setNominalViewingTransform();
        this._orbit = new OrbitBehavior(canvas3D, 368);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        this._orbit.setSchedulingBounds((Bounds)boundingSphere);
        simpleUniverse.getViewingPlatform().setViewPlatformBehavior((ViewPlatformBehavior)this._orbit);
        simpleUniverse.addBranchGraph(branchGroup);
        this._frame = new JFrame(I18nManager.getText("dialog.3d.title"));
        this._frame.getContentPane().setLayout(new BorderLayout());
        this._frame.getContentPane().add((Component)canvas3D, "Center");
        this._frame.setIconImage(this._parentFrame.getIconImage());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("function.exportpov"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Java3DWindow.this._orbit != null) {
                    Java3DWindow.this.callbackRender();
                }
            }
        });
        jPanel.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.showlines"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double[] dArray = Java3DWindow.this._model.getLatitudeLines();
                double[] dArray2 = Java3DWindow.this._model.getLongitudeLines();
                LineDialog lineDialog = new LineDialog(Java3DWindow.this._frame, dArray, dArray2);
                lineDialog.showDialog();
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(I18nManager.getText("button.close"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Java3DWindow.this._frame.dispose();
                Java3DWindow.this._frame = null;
                Java3DWindow.this._orbit = null;
            }
        });
        jPanel.add(jButton3);
        this._frame.getContentPane().add((Component)jPanel, "South");
        this._frame.setSize(500, 350);
        this._frame.pack();
        this._frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Java3DWindow.this.dispose();
            }
        });
        this._frame.setVisible(true);
        if (this._frame.getState() == 1) {
            this._frame.setState(0);
        }
    }

    public void dispose() {
        if (this._frame != null) {
            this._frame.dispose();
            this._frame = null;
        }
    }

    private BranchGroup createSceneGraph() {
        BranchGroup branchGroup = new BranchGroup();
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        Transform3D transform3D = new Transform3D();
        transform3D.setScale(0.055);
        TransformGroup transformGroup2 = new TransformGroup(transform3D);
        branchGroup.addChild((Node)transformGroup2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(Math.toRadians(-25.0));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(Math.toRadians(15.0));
        TransformGroup transformGroup3 = new TransformGroup(transform3D3);
        transformGroup.setTransform(transform3D2);
        transformGroup2.addChild((Node)transformGroup3);
        transformGroup3.addChild((Node)transformGroup);
        Appearance appearance = null;
        Box box = null;
        appearance = new Appearance();
        appearance.setMaterial(new Material(new Color3f(0.1f, 0.2f, 0.2f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.3f, 0.4f, 0.4f), new Color3f(0.3f, 0.3f, 0.3f), 0.0f));
        box = new Box(10.0f, 0.04f, 10.0f, appearance);
        transformGroup.addChild((Node)box);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        int n = 0;
        while (n < 91) {
            generalPath.lineTo((float)(0.1 - 0.1 * Math.cos(Math.toRadians(n))), (float)(0.1 * Math.sin(Math.toRadians(n))));
            n += 5;
        }
        n = 90;
        while (n > 0) {
            generalPath.lineTo((float)(0.3 + 0.1 * Math.cos(Math.toRadians(n))), (float)(0.1 * Math.sin(Math.toRadians(n))));
            n -= 5;
        }
        Font3D font3D = new Font3D(new Font(CARDINALS_FONT, 0, 1), new FontExtrusion((Shape)generalPath));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.n"), new Point3f(0.0f, 0.0f, -10.0f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.s"), new Point3f(0.0f, 0.0f, 10.0f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.w"), new Point3f(-11.0f, 0.0f, 0.0f), font3D));
        transformGroup.addChild((Node)this.createCompassPoint(I18nManager.getText("cardinal.e"), new Point3f(10.0f, 0.0f, 0.0f), font3D));
        this._model = new ThreeDModel(this._track);
        this._model.setAltitudeCap(this._altitudeCap);
        this._model.scale();
        transformGroup.addChild((Node)Java3DWindow.createLatLongs(this._model));
        transformGroup.addChild((Node)Java3DWindow.createDataPoints(this._model));
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        AmbientLight ambientLight = new AmbientLight(new Color3f(1.0f, 1.0f, 1.0f));
        ambientLight.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)ambientLight);
        PointLight pointLight = new PointLight(new Color3f(1.0f, 1.0f, 1.0f), new Point3f(0.0f, 0.0f, 2.0f), new Point3f(0.25f, 0.05f, 0.0f));
        pointLight.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)pointLight);
        PointLight pointLight2 = new PointLight(new Color3f(0.8f, 0.9f, 0.4f), new Point3f(6.0f, 1.0f, 6.0f), new Point3f(0.2f, 0.1f, 0.05f));
        pointLight2.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)pointLight2);
        PointLight pointLight3 = new PointLight(new Color3f(0.7f, 0.7f, 0.7f), new Point3f(0.0f, 12.0f, -2.0f), new Point3f(0.1f, 0.1f, 0.0f));
        pointLight3.setInfluencingBounds((Bounds)boundingSphere);
        transformGroup.addChild((Node)pointLight3);
        branchGroup.compile();
        return branchGroup;
    }

    private Shape3D createCompassPoint(String string, Point3f point3f, Font3D font3D) {
        Text3D text3D = new Text3D(font3D, string, point3f, 1, 1);
        Material material = new Material(new Color3f(0.5f, 0.5f, 0.55f), new Color3f(0.05f, 0.05f, 0.1f), new Color3f(0.3f, 0.4f, 0.5f), new Color3f(0.4f, 0.5f, 0.7f), 70.0f);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        Shape3D shape3D = new Shape3D((Geometry)text3D, appearance);
        return shape3D;
    }

    private static Group createLatLongs(ThreeDModel threeDModel) {
        Group group = new Group();
        int n = threeDModel.getLatitudeLines().length;
        int n2 = 0;
        while (n2 < n) {
            group.addChild((Node)Java3DWindow.createLatLine(threeDModel.getScaledLatitudeLine(n2), threeDModel.getModelSize()));
            ++n2;
        }
        n = threeDModel.getLongitudeLines().length;
        n2 = 0;
        while (n2 < n) {
            group.addChild((Node)Java3DWindow.createLonLine(threeDModel.getScaledLongitudeLine(n2), threeDModel.getModelSize()));
            ++n2;
        }
        return group;
    }

    private static Group createLatLine(double d, double d2) {
        Cylinder cylinder = new Cylinder(0.1f, (float)(d2 * 2.0));
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, 0.0, d));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotZ(Math.toRadians(90.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)cylinder);
        return transformGroup;
    }

    private static Group createLonLine(double d, double d2) {
        Cylinder cylinder = new Cylinder(0.1f, (float)(d2 * 2.0));
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(d, 0.0, 0.0));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotX(Math.toRadians(90.0));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)transformGroup2);
        transformGroup2.addChild((Node)cylinder);
        return transformGroup;
    }

    private static Group createDataPoints(ThreeDModel threeDModel) {
        Group group = new Group();
        int n = threeDModel.getNumPoints();
        int n2 = 0;
        while (n2 < n) {
            byte by = threeDModel.getPointType(n2);
            if (by == 1) {
                group.addChild((Node)Java3DWindow.createWaypoint(new Point3d(threeDModel.getScaledHorizValue(n2), threeDModel.getScaledAltValue(n2), -threeDModel.getScaledVertValue(n2))));
            } else {
                group.addChild((Node)Java3DWindow.createTrackpoint(new Point3d(threeDModel.getScaledHorizValue(n2), threeDModel.getScaledAltValue(n2), -threeDModel.getScaledVertValue(n2)), threeDModel.getPointHeightCode(n2)));
            }
            ++n2;
        }
        return group;
    }

    private static Group createWaypoint(Point3d point3d) {
        Material material = Java3DWindow.getWaypointMaterial();
        Sphere sphere = new Sphere(0.35f);
        return Java3DWindow.createBall(point3d, sphere, material);
    }

    private static Material getWaypointMaterial() {
        return new Material(new Color3f(0.1f, 0.1f, 0.4f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.2f, 0.7f), new Color3f(1.0f, 0.6f, 0.6f), 40.0f);
    }

    private static Group createTrackpoint(Point3d point3d, byte by) {
        Material material = Java3DWindow.getTrackpointMaterial(by);
        Sphere sphere = new Sphere(0.2f);
        return Java3DWindow.createBall(point3d, sphere, material);
    }

    private static Material getTrackpointMaterial(byte by) {
        Material material = new Material(new Color3f(0.3f, 0.2f, 0.1f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.0f, 0.6f, 0.0f), new Color3f(1.0f, 0.6f, 0.6f), 70.0f);
        if (by == 1) {
            material.setDiffuseColor(new Color3f(0.4f, 0.9f, 0.2f));
        }
        if (by == 2) {
            material.setDiffuseColor(new Color3f(0.7f, 0.8f, 0.2f));
        }
        if (by == 3) {
            material.setDiffuseColor(new Color3f(0.5f, 0.85f, 0.95f));
        }
        if (by == 4) {
            material.setDiffuseColor(new Color3f(0.1f, 0.9f, 0.9f));
        }
        if (by >= 5) {
            material.setDiffuseColor(new Color3f(1.0f, 1.0f, 1.0f));
        }
        return material;
    }

    private static Group createBall(Point3d point3d, Sphere sphere, Material material) {
        Group group = new Group();
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d((Tuple3d)point3d));
        TransformGroup transformGroup = new TransformGroup(transform3D);
        material.setLightingEnable(true);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        sphere.setAppearance(appearance);
        transformGroup.addChild((Node)sphere);
        group.addChild((Node)transformGroup);
        Cylinder cylinder = new Cylinder(0.1f, (float)point3d.y);
        Material material2 = new Material(new Color3f(0.2f, 0.2f, 0.2f), new Color3f(0.0f, 0.0f, 0.0f), new Color3f(0.2f, 0.2f, 0.2f), new Color3f(0.05f, 0.05f, 0.05f), 0.4f);
        material2.setLightingEnable(true);
        Appearance appearance2 = new Appearance();
        appearance2.setMaterial(material2);
        cylinder.setAppearance(appearance2);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3d(point3d.x, point3d.y / 2.0, point3d.z));
        TransformGroup transformGroup2 = new TransformGroup(transform3D2);
        transformGroup2.addChild((Node)cylinder);
        group.addChild((Node)transformGroup2);
        return group;
    }

    private void callbackRender() {
        Transform3D transform3D = new Transform3D();
        this._orbit.getViewingPlatform().getViewPlatformTransform().getTransform(transform3D);
        Matrix3d matrix3d = new Matrix3d();
        transform3D.get(matrix3d);
        Point3d point3d = new Point3d(0.0, 0.0, 1.0);
        matrix3d.transform((Tuple3d)point3d);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotY(Math.toRadians(25.0));
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotX(Math.toRadians(-15.0));
        Point3d point3d2 = new Point3d();
        transform3D3.transform(point3d, point3d2);
        transform3D2.transform(point3d2);
        FunctionLibrary.FUNCTION_POVEXPORT.setCameraCoordinates(point3d2.x, point3d2.y, point3d2.z);
        FunctionLibrary.FUNCTION_POVEXPORT.setAltitudeCap(this._altitudeCap);
        FunctionLibrary.FUNCTION_POVEXPORT.begin();
    }

    private static String getAltitudeUnitsLabel(Track track) {
        Altitude.Format format = track.getAltitudeRange().getFormat();
        if (format == Altitude.Format.METRES) {
            return I18nManager.getText("units.metres.short");
        }
        return I18nManager.getText("units.feet.short");
    }
}

