/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Track;

public abstract class Checker {
    public static boolean isDoubledTrack(Track track) {
        if (track == null || track.getNumPoints() < 2) {
            return false;
        }
        int n = track.getNumPoints();
        if (n % 2 == 1) {
            return false;
        }
        int n2 = n / 2;
        int n3 = 0;
        while (n3 < n2) {
            DataPoint dataPoint = track.getPoint(n3);
            DataPoint dataPoint2 = track.getPoint(n3 + n2);
            if (!dataPoint.getLatitude().equals(dataPoint2.getLatitude()) || !dataPoint.getLongitude().equals(dataPoint2.getLongitude())) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public static int getNextSegmentStart(Track track, int n) {
        int n2 = n + 1;
        DataPoint dataPoint = null;
        while ((dataPoint = track.getPoint(n2)) != null && !dataPoint.getSegmentStart()) {
            ++n2;
        }
        return Math.min(n2, track.getNumPoints() - 1);
    }

    public static int getPreviousSegmentStart(Track track, int n) {
        int n2 = n - 1;
        DataPoint dataPoint = null;
        while ((dataPoint = track.getPoint(n2)) != null && !dataPoint.getSegmentStart()) {
            --n2;
        }
        return Math.max(n2, 0);
    }
}

