/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.Iterator;
import java.util.Set;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FileInfo;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.data.Selection;
import tim.prune.data.Track;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackInfo {
    private Track _track = null;
    private Selection _selection = null;
    private FileInfo _fileInfo = null;
    private PhotoList _photoList = null;

    public TrackInfo(Track track) {
        this._track = track;
        this._selection = new Selection(this._track);
        this._fileInfo = new FileInfo();
        this._photoList = new PhotoList();
    }

    public Track getTrack() {
        return this._track;
    }

    public Selection getSelection() {
        return this._selection;
    }

    public FileInfo getFileInfo() {
        return this._fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this._fileInfo = fileInfo;
    }

    public PhotoList getPhotoList() {
        return this._photoList;
    }

    public DataPoint getCurrentPoint() {
        return this._track.getPoint(this._selection.getCurrentPointIndex());
    }

    public Photo getCurrentPhoto() {
        return this._photoList.getPhoto(this._selection.getCurrentPhotoIndex());
    }

    public int[] addPhotos(Set<Photo> set) {
        DataPoint[] dataPointArray;
        int n = 0;
        int n2 = 0;
        Iterator<Photo> iterator = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    dataPointArray = iterator.next();
                    if (dataPointArray == null || this._photoList.contains((Photo)dataPointArray)) continue;
                    ++n;
                    if (dataPointArray.getDataPoint() == null) continue;
                    ++n2;
                }
                catch (ClassCastException classCastException) {}
            }
        }
        if (n > 0) {
            dataPointArray = new DataPoint[n2];
            int n3 = 0;
            boolean bl = false;
            iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    Photo photo = iterator.next();
                    if (photo == null || this._photoList.contains(photo)) continue;
                    this._photoList.addPhoto(photo);
                    if (photo.getDataPoint() == null) continue;
                    dataPointArray[n3] = photo.getDataPoint();
                    bl |= photo.getDataPoint().getAltitude() != null;
                    ++n3;
                }
                catch (ClassCastException classCastException) {}
            }
            if (n2 > 0) {
                this._track.appendPoints(dataPointArray);
                this._track.getFieldList().extendList(Field.LATITUDE);
                this._track.getFieldList().extendList(Field.LONGITUDE);
                if (bl) {
                    this._track.getFieldList().extendList(Field.ALTITUDE);
                }
            }
        }
        dataPointArray = (DataPoint[])new int[]{n, n2};
        return dataPointArray;
    }

    public boolean deleteRange() {
        int n = this._selection.getStart();
        int n2 = this._selection.getEnd();
        boolean bl = this._track.deleteRange(n, n2);
        this._selection.modifyRangeDeleted();
        return bl;
    }

    public boolean deletePoint() {
        if (this._track.deletePoint(this._selection.getCurrentPointIndex())) {
            this._selection.modifyPointDeleted();
            UpdateMessageBroker.informSubscribers();
            return true;
        }
        return false;
    }

    public boolean deleteCurrentPhoto(boolean bl) {
        int n = this._selection.getCurrentPhotoIndex();
        if (n >= 0) {
            Photo photo = this._photoList.getPhoto(n);
            this._photoList.deletePhoto(n);
            if (photo.getDataPoint() != null) {
                if (bl) {
                    int n2 = this._track.getPointIndex(photo.getDataPoint());
                    this._track.deletePoint(n2);
                } else {
                    photo.getDataPoint().setPhoto(null);
                    photo.setDataPoint(null);
                }
            }
            this._selection.modifyPointDeleted();
            UpdateMessageBroker.informSubscribers();
        }
        return true;
    }

    public int deleteMarkedPoints() {
        int n = this._track.deleteMarkedPoints();
        if (n > 0) {
            this._selection.clearAll();
            UpdateMessageBroker.informSubscribers();
        }
        return n;
    }

    public DataPoint[] cloneSelectedRange() {
        return this._track.cloneRange(this._selection.getStart(), this._selection.getEnd());
    }

    public boolean mergeTrackSegments(int n, int n2) {
        boolean bl = true;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this._track.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                dataPoint.setSegmentStart(bl);
                bl = false;
            }
            ++n3;
        }
        DataPoint dataPoint = this._track.getNextTrackPoint(n2 + 1);
        if (dataPoint != null) {
            dataPoint.setSegmentStart(true);
        }
        this._selection.markInvalid();
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean interpolate(int n) {
        boolean bl = this._track.interpolate(this._selection.getStart(), n);
        if (bl) {
            this._selection.selectRangeEnd(this._selection.getEnd() + n);
        }
        return bl;
    }

    public boolean average() {
        boolean bl = this._track.average(this._selection.getStart(), this._selection.getEnd());
        if (bl) {
            this.selectPoint(this._selection.getEnd() + 1);
        }
        return bl;
    }

    public void selectPoint(DataPoint dataPoint) {
        this.selectPoint(this._track.getPointIndex(dataPoint));
    }

    public void selectPoint(int n) {
        if (this._selection.getCurrentPointIndex() == n || n >= this._track.getNumPoints()) {
            return;
        }
        int n2 = this._selection.getCurrentPhotoIndex();
        boolean bl = false;
        if (n >= 0) {
            Photo photo = this._track.getPoint(n).getPhoto();
            boolean bl2 = bl = photo != null;
            if (bl) {
                n2 = this._photoList.getPhotoIndex(photo);
            }
        }
        if (!bl && (n2 < 0 || this._photoList.getPhoto(n2).isConnected())) {
            n2 = -1;
        }
        this._selection.selectPhotoAndPoint(n2, n);
    }

    public void selectPhoto(int n) {
        if (this._selection.getCurrentPhotoIndex() == n) {
            return;
        }
        Photo photo = this._photoList.getPhoto(n);
        if (photo != null) {
            int n2;
            int n3 = this._track.getPointIndex(photo.getDataPoint());
            if (n3 < 0 && (n2 = this._selection.getCurrentPointIndex()) >= 0 && this._track.getPoint(n2).getPhoto() == null) {
                n3 = n2;
            }
            this._selection.selectPhotoAndPoint(n, n3);
        } else {
            DataPoint dataPoint = this.getCurrentPoint();
            if (dataPoint != null && dataPoint.getPhoto() == null) {
                this._selection.selectPhotoAndPoint(-1, this._selection.getCurrentPointIndex());
            } else {
                this._selection.selectPhotoAndPoint(-1, -1);
            }
        }
    }

    public void extendSelection(int n) {
        int n2 = this._selection.getStart();
        if (n2 < 0 || this._selection.getCurrentPointIndex() != this._selection.getEnd()) {
            n2 = this._selection.getCurrentPointIndex();
        }
        this.selectPoint(n);
        if (n2 < n) {
            this._selection.selectRange(n2, n);
        }
    }
}

