/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import tim.prune.I18nManager;
import tim.prune.function.SetMapBgFunction;
import tim.prune.gui.map.CloudmadeMapSource;
import tim.prune.gui.map.MapSourceLibrary;
import tim.prune.gui.map.OsmMapSource;

public class AddMapSourceDialog {
    private SetMapBgFunction _parent = null;
    private JDialog _addDialog = null;
    private JRadioButton[] _typeRadios = null;
    private JPanel _cards = null;
    private JTextField _oNameField = null;
    private JTextField _baseUrlField = null;
    private JTextField _topUrlField = null;
    private JComboBox _oZoomCombo = null;
    private JTextField _cNameField = null;
    private JTextField _cStyleField = null;
    private JComboBox _cZoomCombo = null;
    private JButton _okButton = null;

    public AddMapSourceDialog(JDialog jDialog, SetMapBgFunction setMapBgFunction) {
        this._parent = setMapBgFunction;
        this._addDialog = new JDialog(jDialog, I18nManager.getText("dialog.addmapsource.title"), true);
        this._addDialog.add(this.makeDialogComponents());
        this._addDialog.setLocationRelativeTo(jDialog);
        this._addDialog.pack();
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel2.setLayout(new GridLayout(1, 0));
        this._typeRadios = new JRadioButton[2];
        this._typeRadios[0] = new JRadioButton("Openstreetmap");
        buttonGroup.add(this._typeRadios[0]);
        jPanel2.add(this._typeRadios[0]);
        this._typeRadios[1] = new JRadioButton("Cloudmade");
        buttonGroup.add(this._typeRadios[1]);
        jPanel2.add(this._typeRadios[1]);
        this._typeRadios[0].setSelected(true);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CardLayout cardLayout = (CardLayout)AddMapSourceDialog.this._cards.getLayout();
                if (AddMapSourceDialog.this._typeRadios[0].isSelected()) {
                    cardLayout.first(AddMapSourceDialog.this._cards);
                } else {
                    cardLayout.last(AddMapSourceDialog.this._cards);
                }
                AddMapSourceDialog.this.enableOK();
            }
        };
        this._typeRadios[0].addActionListener(actionListener);
        this._typeRadios[1].addActionListener(actionListener);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jPanel2, "North");
        this._cards = new JPanel();
        this._cards.setLayout(new CardLayout());
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                super.keyReleased(keyEvent);
                AddMapSourceDialog.this.enableOK();
            }
        };
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 2, 4, 2));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.addmapsource.sourcename")));
        this._oNameField = new JTextField(18);
        this._oNameField.addKeyListener(keyAdapter);
        jPanel3.add(this._oNameField);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.addmapsource.layer1url")));
        this._baseUrlField = new JTextField(18);
        this._baseUrlField.addKeyListener(keyAdapter);
        jPanel3.add(this._baseUrlField);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.addmapsource.layer2url")));
        this._topUrlField = new JTextField(18);
        this._topUrlField.addKeyListener(keyAdapter);
        jPanel3.add(this._topUrlField);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.addmapsource.maxzoom")));
        this._oZoomCombo = new JComboBox();
        int n = 10;
        while (n <= 20) {
            this._oZoomCombo.addItem("" + n);
            ++n;
        }
        jPanel3.add(this._oZoomCombo);
        this._cards.add((Component)jPanel3, "card1");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(0, 2, 5, 5));
        jPanel4.add(new JLabel(I18nManager.getText("dialog.addmapsource.sourcename")));
        this._cNameField = new JTextField(18);
        this._cNameField.addKeyListener(keyAdapter);
        jPanel4.add(this._cNameField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.addmapsource.cloudstyle")));
        this._cStyleField = new JTextField(18);
        this._cStyleField.addKeyListener(keyAdapter);
        jPanel4.add(this._cStyleField);
        jPanel4.add(new JLabel(I18nManager.getText("dialog.addmapsource.maxzoom")));
        this._cZoomCombo = new JComboBox();
        int n2 = 10;
        while (n2 <= 20) {
            this._cZoomCombo.addItem("" + n2);
            ++n2;
        }
        jPanel4.add(this._cZoomCombo);
        jPanel4.add(new JLabel(" "));
        this._cards.add((Component)jPanel4, "card2");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this._cards, "North");
        jPanel.add((Component)jPanel5, "Center");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener2);
        jPanel6.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddMapSourceDialog.this._addDialog.dispose();
            }
        });
        jPanel6.add(jButton);
        jPanel.add((Component)jPanel6, "South");
        return jPanel;
    }

    public void showDialog() {
        this._oNameField.setText("");
        this._baseUrlField.setText("");
        this._topUrlField.setText("");
        this._oZoomCombo.setSelectedIndex(8);
        this._cNameField.setText("");
        this._cStyleField.setText("");
        this._cZoomCombo.setSelectedIndex(8);
        this._okButton.setEnabled(false);
        this._addDialog.setVisible(true);
    }

    private void enableOK() {
        boolean bl = false;
        if (this._typeRadios[0].isSelected()) {
            bl = this.isOsmPanelOk();
        }
        if (this._typeRadios[1].isSelected()) {
            bl = this.isCloudPanelOk();
        }
        this._okButton.setEnabled(bl);
    }

    private boolean isOsmPanelOk() {
        boolean bl = this._oNameField.getText().trim().length() > 1;
        URL uRL = null;
        URL uRL2 = null;
        try {
            String string = this._baseUrlField.getText().trim();
            if (string.length() > 10) {
                uRL = new URL(string);
            } else if (string.length() > 0) {
                bl = false;
            }
            String string2 = this._topUrlField.getText().trim();
            if (string2.length() > 10) {
                uRL2 = new URL(string2);
            } else if (string2.length() > 0) {
                bl = false;
            }
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        return bl && (uRL != null || uRL2 != null);
    }

    private boolean isCloudPanelOk() {
        boolean bl = this._cNameField.getText().trim().length() > 1;
        int n = 0;
        try {
            n = Integer.parseInt(this._cStyleField.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        return bl && n > 0;
    }

    private void finish() {
        OsmMapSource osmMapSource = null;
        if (this._typeRadios[0].isSelected()) {
            String string = AddMapSourceDialog.getUniqueSourcename(this._oNameField.getText());
            String string2 = this._baseUrlField.getText().trim();
            String string3 = this._topUrlField.getText().trim();
            osmMapSource = new OsmMapSource(string, string2, string3, this._oZoomCombo.getSelectedIndex() + 10);
        } else if (this._typeRadios[1].isSelected()) {
            String string = AddMapSourceDialog.getUniqueSourcename(this._cNameField.getText());
            osmMapSource = new CloudmadeMapSource(string, this._cStyleField.getText(), this._cZoomCombo.getSelectedIndex() + 10);
        }
        if (osmMapSource != null) {
            MapSourceLibrary.addSource(osmMapSource);
            this._parent.updateList();
            this._addDialog.setVisible(false);
        }
    }

    private static String getUniqueSourcename(String string) {
        String string2 = string;
        string2 = string2 == null ? "" : string2.trim();
        if (string2.equals("")) {
            string2 = I18nManager.getText("dialog.addmapsource.noname");
        }
        if (MapSourceLibrary.hasSourceName(string2)) {
            int n = 1;
            while (MapSourceLibrary.hasSourceName(String.valueOf(string2) + n)) {
                ++n;
            }
            string2 = String.valueOf(string2) + n;
        }
        return string2;
    }
}

