/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.gui.WholeNumberField;

public class SetKmzImageSize
extends GenericFunction {
    private JDialog _dialog = null;
    private JButton _okButton = null;
    private WholeNumberField _widthField = null;
    private WholeNumberField _heightField = null;

    public SetKmzImageSize(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.setkmzimagesize";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._widthField.setValue(Config.getConfigInt("prune.kmzimagewidth"));
        this._heightField.setValue(Config.getConfigInt("prune.kmzimageheight"));
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 2));
        jPanel2.add(SetKmzImageSize.makeRightLabel("dialog.saveconfig.prune.kmzimagewidth"));
        this._widthField = new WholeNumberField(4);
        jPanel2.add(this._widthField);
        jPanel2.add(SetKmzImageSize.makeRightLabel("dialog.saveconfig.prune.kmzimageheight"));
        this._heightField = new WholeNumberField(4);
        jPanel2.add(this._heightField);
        jPanel.add((Component)jPanel2, "Center");
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                SetKmzImageSize.this._okButton.setEnabled(SetKmzImageSize.this._widthField.getValue() > 0 && SetKmzImageSize.this._heightField.getValue() > 0);
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                SetKmzImageSize.this._okButton.setEnabled(SetKmzImageSize.this._widthField.getValue() > 0 && SetKmzImageSize.this._heightField.getValue() > 0);
            }
        };
        this._widthField.addKeyListener(keyAdapter);
        this._heightField.addKeyListener(keyAdapter);
        this._widthField.addMouseListener(mouseAdapter);
        this._heightField.addMouseListener(mouseAdapter);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetKmzImageSize.this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SetKmzImageSize.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private static final JLabel makeRightLabel(String string) {
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText(string)) + " : ");
        jLabel.setHorizontalAlignment(4);
        return jLabel;
    }

    private void finish() {
        if (this._widthField.getValue() > 0 && this._heightField.getValue() > 0) {
            Config.setConfigInt("prune.kmzimagewidth", this._widthField.getValue());
            Config.setConfigInt("prune.kmzimageheight", this._heightField.getValue());
            this._dialog.dispose();
        }
    }
}

