/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.compress;

import java.awt.Component;
import java.awt.event.ActionListener;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.compress.SingleParameterAlgorithm;
import tim.prune.function.compress.TrackDetails;

public class ClosePointsAlgorithm
extends SingleParameterAlgorithm {
    public ClosePointsAlgorithm(Track track, TrackDetails trackDetails, ActionListener actionListener) {
        super(track, trackDetails, actionListener);
    }

    protected int compress(boolean[] blArray) {
        double d = this.getParameter();
        if (d > 1.0) {
            d = 1.0 / d;
        }
        if (d <= 0.0 || d >= 1.0) {
            return 0;
        }
        double d2 = this._trackDetails.getTrackSpan() * d;
        int n = this._track.getNumPoints();
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = 0;
        int n5 = 1;
        while (n5 < n) {
            if (!blArray[n5]) {
                DataPoint dataPoint = this._track.getPoint(n5);
                if (!dataPoint.isWaypoint()) {
                    if (dataPoint.getPhoto() == null && !this._trackDetails.isSegmentStart(n5) && !this._trackDetails.isSegmentEnd(n5)) {
                        d3 = Math.abs(this._track.getX(n5) - this._track.getX(n2)) + Math.abs(this._track.getY(n5) - this._track.getY(n2));
                        if (d3 < d2) {
                            blArray[n5] = true;
                            ++n4;
                        } else if (n3 != n2 && (d3 = Math.abs(this._track.getX(n5) - this._track.getX(n3)) + Math.abs(this._track.getY(n5) - this._track.getY(n3))) < d2) {
                            blArray[n5] = true;
                            ++n4;
                        }
                    }
                    if (!blArray[n5]) {
                        n3 = n5;
                    }
                }
                if (!blArray[n5]) {
                    n2 = n5;
                }
            }
            ++n5;
        }
        return n4;
    }

    protected Component getSpecificGuiComponents() {
        return this.getSpecificGuiComponents("dialog.compress.closepoints.paramdesc", "200");
    }

    protected String getTitleTextKey() {
        return "dialog.compress.closepoints.title";
    }
}

