/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class DiskTileCacher
implements Runnable {
    private URL _url = null;
    private File _file = null;
    private ImageObserver _observer = null;
    private static final long CACHE_TIME_LIMIT = 1728000000L;

    private DiskTileCacher(URL uRL, File file, ImageObserver imageObserver) {
        this._url = uRL;
        this._file = file;
        this._observer = imageObserver;
        new Thread(this).start();
    }

    public static Image getTile(String string, String string2, boolean bl) {
        if (string == null) {
            return null;
        }
        File file = new File(string, string2);
        Image image = null;
        if (file.exists() && file.canRead() && file.length() > 0L) {
            long l = file.lastModified();
            if (!bl || System.currentTimeMillis() - l < 1728000000L) {
                try {
                    image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
                }
                catch (Exception exception) {}
            }
        }
        return image;
    }

    public static void saveTile(URL uRL, String string, String string2, ImageObserver imageObserver) {
        File file;
        if (string == null || string2 == null) {
            return;
        }
        File file2 = new File(string);
        if (!(file2.exists() && file2.isDirectory() && file2.canWrite())) {
            return;
        }
        File file3 = new File(file2, string2);
        if (!DiskTileCacher.isBeingLoaded(file3) && ((file = file3.getParentFile()).exists() || file.mkdirs())) {
            new DiskTileCacher(uRL, file3, imageObserver);
        }
    }

    private static boolean isBeingLoaded(File file) {
        File file2 = new File(String.valueOf(file.getAbsolutePath()) + ".temp");
        return file2.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        File file = new File(String.valueOf(this._file.getAbsolutePath()) + ".temp");
        Class<DiskTileCacher> clazz = DiskTileCacher.class;
        synchronized (DiskTileCacher.class) {
            block23: {
                if (file.exists()) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                try {
                    if (!file.createNewFile()) {
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
                catch (Exception exception) {
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return;
                }
                try {
                    try {
                        fileOutputStream = new FileOutputStream(file);
                        inputStream = this._url.openStream();
                        int n = 0;
                        while ((n = inputStream.read()) >= 0) {
                            fileOutputStream.write(n);
                        }
                        bl = true;
                    }
                    catch (IOException iOException) {
                        try {
                            inputStream.close();
                            fileOutputStream.close();
                            if (!bl) {
                                file.delete();
                            }
                            break block23;
                        }
                        catch (Exception exception) {}
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                        fileOutputStream.close();
                        if (!bl) {
                            file.delete();
                        }
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                    fileOutputStream.close();
                    if (!bl) {
                        file.delete();
                    }
                }
                catch (Exception exception) {}
            }
            if (!file.renameTo(this._file)) {
                file.delete();
                this._file.delete();
            }
            this._observer.imageUpdate(null, 32, 0, 0, 0, 0);
            return;
        }
    }
}

