/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import tim.prune.I18nManager;
import tim.prune.gui.map.MapSource;

public class OsmMapSource
extends MapSource {
    private String _name = null;
    private String[] _baseUrls = null;
    private String[] _siteNames = null;
    private int _maxZoom = 0;

    public OsmMapSource(String string, String string2) {
        this(string, string2, null, 18);
    }

    public OsmMapSource(String string, String string2, String string3, int n) {
        this._name = string;
        if (this._name == null || this._name.trim().equals("")) {
            this._name = I18nManager.getText("mapsource.unknown");
        }
        this._baseUrls = new String[2];
        this._baseUrls[0] = OsmMapSource.fixBaseUrl(string2);
        this._baseUrls[1] = OsmMapSource.fixBaseUrl(string3);
        this._siteNames = new String[2];
        this._siteNames[0] = OsmMapSource.fixSiteName(this._baseUrls[0]);
        this._siteNames[1] = OsmMapSource.fixSiteName(this._baseUrls[1]);
        if (this._baseUrls[0] == null && this._baseUrls[1] != null) {
            this._baseUrls[0] = this._baseUrls[1];
            this._siteNames[0] = this._siteNames[1];
            this._siteNames[1] = null;
            this._baseUrls[1] = null;
        }
        this._maxZoom = n;
    }

    public static OsmMapSource fromConfig(String string) {
        OsmMapSource osmMapSource = null;
        if (string.startsWith("o:")) {
            String[] stringArray = string.substring(2).split(";");
            try {
                if (stringArray.length == 3) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], null, Integer.parseInt(stringArray[2]));
                } else if (stringArray.length == 4) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return osmMapSource;
    }

    public String getName() {
        return this._name;
    }

    public int getNumLayers() {
        return this._baseUrls[1] == null ? 1 : 2;
    }

    public String getBaseUrl(int n) {
        return this._baseUrls[n];
    }

    public String getSiteName(int n) {
        return this._siteNames[n];
    }

    public String makeURL(int n, int n2, int n3, int n4) {
        return String.valueOf(this._baseUrls[n]) + n2 + "/" + n3 + "/" + n4 + this.getFileExtension(n);
    }

    public final String getFileExtension(int n) {
        return ".png";
    }

    public final int getMaxZoomLevel() {
        return this._maxZoom;
    }

    public String getConfigString() {
        return "o:" + this.getName() + ";" + this.getSiteStrings() + this.getMaxZoomLevel();
    }
}

