/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.helpers.DefaultHandler;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.SourceInfo;
import tim.prune.load.xml.XmlFileLoader;
import tim.prune.load.xml.XmlHandler;
import tim.prune.save.GpxExporter;

public class GpsLoader
extends GenericFunction
implements Runnable {
    private boolean _gpsBabelChecked = false;
    private JDialog _dialog = null;
    private JTextField _deviceField = null;
    private JTextField _formatField = null;
    private JCheckBox _waypointCheckbox = null;
    private JCheckBox _trackCheckbox = null;
    private JCheckBox _saveCheckbox = null;
    private JButton _okButton = null;
    private JProgressBar _progressBar = null;
    private File _saveFile = null;
    private boolean _cancelled = false;

    public GpsLoader(App app) {
        super(app);
    }

    public String getNameKey() {
        return "function.loadfromgps";
    }

    public void begin() {
        if (this._gpsBabelChecked || ExternalTools.isToolInstalled(1) || JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.gpsload.nogpsbabel"), I18nManager.getText(this.getNameKey()), 0, 2) == 0) {
            this._gpsBabelChecked = true;
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this.enableOkButton();
            this.setupProgressBar(true);
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(Config.getConfigString("prune.gpsdevice"), 12);
        this._deviceField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    GpsLoader.this._dialog.dispose();
                }
            }
        });
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(Config.getConfigString("prune.gpsformat"), 12);
        jPanel3.add(this._formatField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        ChangeListener changeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GpsLoader.this.enableOkButton();
            }
        };
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.getwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.gettracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._saveCheckbox = new JCheckBox(I18nManager.getText("dialog.gpsload.save"));
        this._saveCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._saveCheckbox);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsLoader.this._cancelled = false;
                new Thread(GpsLoader.this).start();
            }
        });
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpsLoader.this._cancelled = true;
                GpsLoader.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void setupProgressBar(boolean bl) {
        this._progressBar.setVisible(!bl);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
    }

    private void enableOkButton() {
        this._okButton.setEnabled(this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected());
    }

    public void run() {
        this._okButton.setEnabled(false);
        this.setupProgressBar(false);
        if (this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected()) {
            this._progressBar.setIndeterminate(true);
            this._saveFile = null;
            try {
                this.callGpsBabel();
            }
            catch (Exception exception) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), exception.getMessage());
                this._cancelled = true;
            }
        }
        this.setupProgressBar(true);
        this.enableOkButton();
        if (!this._cancelled) {
            this._dialog.dispose();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void callGpsBabel() throws Exception {
        Object object;
        String string = this._deviceField.getText().trim();
        String string2 = this._formatField.getText().trim();
        String[] stringArray = this.getCommandArray(string, string2);
        Config.setConfigString("prune.gpsdevice", string);
        Config.setConfigString("prune.gpsformat", string2);
        String string3 = "";
        String string4 = "";
        XmlHandler xmlHandler = null;
        Process process = Runtime.getRuntime().exec(stringArray);
        String string5 = null;
        if (this._saveFile != null) {
            process.waitFor();
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((string5 = bufferedReader.readLine()) != null) {
                    string3 = String.valueOf(string3) + string5 + "\n";
                }
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {}
            if (process.exitValue() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ArrayList<File> arrayList = new ArrayList<File>();
                        arrayList.add(GpsLoader.this._saveFile);
                        GpsLoader.this._app.loadDataFiles(arrayList);
                    }
                });
                return;
            }
            if (string3.length() <= 0) throw new Exception(I18nManager.getText("error.gpsload.unknown"));
            throw new Exception(string3);
        }
        try {
            object = new XmlFileLoader(this._app);
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            sAXParser.parse(process.getInputStream(), (DefaultHandler)object);
            xmlHandler = ((XmlFileLoader)object).getHandler();
            if (xmlHandler == null) {
                string3 = "Null handler";
            }
        }
        catch (Exception exception) {
            string3 = exception.getMessage();
        }
        object = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((string5 = ((BufferedReader)object).readLine()) != null) {
            string4 = String.valueOf(string4) + string5 + "\n";
        }
        try {
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {}
        if (string4.length() > 0) {
            string3 = string4;
        }
        if (string3.length() > 0) {
            throw new Exception(string3);
        }
        this._app.informDataLoaded(xmlHandler.getFieldArray(), xmlHandler.getDataArray(), Altitude.Format.METRES, new SourceInfo(this._deviceField.getText(), SourceInfo.FILE_TYPE.GPSBABEL), xmlHandler.getTrackNameList());
    }

    private String[] getCommandArray(String string, String string2) {
        String[] stringArray = null;
        String string3 = Config.getConfigString("prune.gpsbabelpath");
        boolean bl = this._waypointCheckbox.isSelected();
        boolean bl2 = this._trackCheckbox.isSelected();
        if (bl && bl2) {
            stringArray = new String[]{string3, "-w", "-t", "-i", string2, "-f", string, "-o", "gpx", "-F", "-"};
        } else {
            stringArray = new String[]{string3, "-w", "-i", string2, "-f", string, "-o", "gpx", "-F", "-"};
            if (bl2) {
                stringArray[1] = "-t";
            }
        }
        if (this._saveCheckbox.isSelected()) {
            this._saveFile = GpxExporter.chooseGpxFile(this._parentFrame);
            if (this._saveFile != null) {
                stringArray[stringArray.length - 1] = this._saveFile.getAbsolutePath();
            }
        }
        return stringArray;
    }
}

