/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.xml;

import java.util.ArrayList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import tim.prune.data.Field;
import tim.prune.load.TrackNameList;
import tim.prune.load.xml.XmlHandler;

public class GpxHandler
extends XmlHandler {
    private boolean _insidePoint = false;
    private boolean _insideWaypoint = false;
    private boolean _insideName = false;
    private boolean _insideElevation = false;
    private boolean _insideTime = false;
    private boolean _insideType = false;
    private boolean _startSegment = true;
    private boolean _isTrackPoint = false;
    private int _trackNum = -1;
    private String _trackName = null;
    private String _name = null;
    private String _latitude = null;
    private String _longitude = null;
    private String _elevation = null;
    private String _time = null;
    private String _type = null;
    private ArrayList<String[]> _pointList = new ArrayList();
    private TrackNameList _trackNameList = new TrackNameList();

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (string3.equalsIgnoreCase("wpt") || string3.equalsIgnoreCase("trkpt") || string3.equalsIgnoreCase("rtept")) {
            this._insidePoint = true;
            this._insideWaypoint = string3.equalsIgnoreCase("wpt");
            this._isTrackPoint = string3.equalsIgnoreCase("trkpt");
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                String string4 = attributes.getQName(n2);
                if (string4.equals("lat")) {
                    this._latitude = attributes.getValue(n2);
                } else if (string4.equals("lon")) {
                    this._longitude = attributes.getValue(n2);
                }
                ++n2;
            }
            this._elevation = null;
            this._name = null;
            this._time = null;
            this._type = null;
        } else if (string3.equalsIgnoreCase("ele")) {
            this._insideElevation = true;
        } else if (string3.equalsIgnoreCase("name")) {
            this._name = null;
            this._insideName = true;
        } else if (string3.equalsIgnoreCase("time")) {
            this._insideTime = true;
        } else if (string3.equalsIgnoreCase("type")) {
            this._insideType = true;
        } else if (string3.equalsIgnoreCase("trkseg")) {
            this._startSegment = true;
        } else if (string3.equalsIgnoreCase("trk")) {
            ++this._trackNum;
            this._trackName = null;
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equalsIgnoreCase("wpt") || string3.equalsIgnoreCase("trkpt") || string3.equalsIgnoreCase("rtept")) {
            this.processPoint();
            this._insidePoint = false;
        } else if (string3.equalsIgnoreCase("ele")) {
            this._insideElevation = false;
        } else if (string3.equalsIgnoreCase("name")) {
            this._insideName = false;
        } else if (string3.equalsIgnoreCase("time")) {
            this._insideTime = false;
        } else if (string3.equalsIgnoreCase("type")) {
            this._insideType = false;
        }
        super.endElement(string, string2, string3);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this._insideName && this._insideWaypoint) {
            this._name = GpxHandler.checkCharacters(this._name, string);
        }
        if (this._insideName && !this._insidePoint) {
            this._trackName = GpxHandler.checkCharacters(this._trackName, string);
        } else if (this._insideElevation) {
            this._elevation = GpxHandler.checkCharacters(this._elevation, string);
        } else if (this._insideTime) {
            this._time = GpxHandler.checkCharacters(this._time, string);
        } else if (this._insideType) {
            this._type = GpxHandler.checkCharacters(this._type, string);
        }
        super.characters(cArray, n, n2);
    }

    private static String checkCharacters(String string, String string2) {
        if (string == null) {
            return string2;
        }
        return String.valueOf(string) + string2;
    }

    private void processPoint() {
        String[] stringArray = new String[7];
        stringArray[0] = this._latitude;
        stringArray[1] = this._longitude;
        stringArray[2] = this._elevation;
        stringArray[3] = this._name;
        stringArray[4] = this._time;
        if (this._startSegment && !this._insideWaypoint) {
            stringArray[5] = "1";
            this._startSegment = false;
        }
        stringArray[6] = this._type;
        this._pointList.add(stringArray);
        this._trackNameList.addPoint(this._trackNum, this._trackName, this._isTrackPoint);
    }

    public Field[] getFieldArray() {
        Field[] fieldArray = new Field[]{Field.LATITUDE, Field.LONGITUDE, Field.ALTITUDE, Field.WAYPT_NAME, Field.TIMESTAMP, Field.NEW_SEGMENT, Field.WAYPT_TYPE};
        return fieldArray;
    }

    public String[][] getDataArray() {
        int n = this._pointList.size();
        String[][] stringArray = new String[n][];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this._pointList.get(n2);
            ++n2;
        }
        return stringArray;
    }

    public TrackNameList getTrackNameList() {
        return this._trackNameList;
    }
}

