/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.TrackInfo;
import tim.prune.load.GenericFileFilter;
import tim.prune.save.PointTypeSelector;
import tim.prune.save.xml.GpxCacherList;

public class GpxExporter
extends GenericFunction
implements Runnable {
    private TrackInfo _trackInfo = null;
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _descriptionField = null;
    private PointTypeSelector _pointTypeSelector = null;
    private JCheckBox _timestampsCheckbox = null;
    private JCheckBox _copySourceCheckbox = null;
    private File _exportFile = null;
    private static final String GPX_CREATOR = "Prune v11 activityworkshop.net";

    public GpxExporter(App app) {
        super(app);
        this._trackInfo = app.getTrackInfo();
    }

    public String getNameKey() {
        return "function.exportgpx";
    }

    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._pointTypeSelector.init(this._app.getTrackInfo());
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(2, 2));
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportgpx.name")));
        this._nameField = new JTextField(10);
        jPanel3.add(this._nameField);
        jPanel3.add(new JLabel(I18nManager.getText("dialog.exportgpx.desc")));
        this._descriptionField = new JTextField(10);
        jPanel3.add(this._descriptionField);
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createVerticalStrut(5));
        this._pointTypeSelector = new PointTypeSelector();
        jPanel2.add(this._pointTypeSelector);
        JPanel jPanel4 = new JPanel();
        this._timestampsCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.includetimestamps"));
        this._timestampsCheckbox.setSelected(true);
        jPanel4.add(this._timestampsCheckbox);
        this._copySourceCheckbox = new JCheckBox(I18nManager.getText("dialog.exportgpx.copysource"));
        this._copySourceCheckbox.setSelected(true);
        jPanel4.add(this._copySourceCheckbox);
        jPanel2.add(jPanel4);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this.startExport();
            }
        };
        jButton.addActionListener(actionListener);
        this._descriptionField.addActionListener(actionListener);
        jPanel5.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GpxExporter.this._dialog.dispose();
            }
        });
        jPanel5.add(jButton2);
        jPanel.add((Component)jPanel5, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void startExport() {
        if (!this._pointTypeSelector.getAnythingSelected()) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.save.notypesselected"), I18nManager.getText("dialog.saveoptions.title"), 2);
            return;
        }
        File file = GpxExporter.chooseGpxFile(this._parentFrame);
        if (file != null) {
            this._exportFile = file;
            new Thread(this).start();
        }
    }

    public static File chooseGpxFile(JFrame jFrame) {
        File file = null;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(1);
        jFileChooser.setFileFilter(new GenericFileFilter("filetype.gpx", new String[]{"gpx"}));
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = Config.getConfigString("prune.trackdirectory");
        if (string != null) {
            jFileChooser.setCurrentDirectory(new File(string));
        }
        boolean bl = false;
        do {
            bl = false;
            if (jFileChooser.showSaveDialog(jFrame) != 0) continue;
            File file2 = jFileChooser.getSelectedFile();
            if (!file2.getName().toLowerCase().endsWith(".gpx")) {
                file2 = new File(String.valueOf(file2.getAbsolutePath()) + ".gpx");
            }
            Object[] objectArray = new Object[]{I18nManager.getText("button.overwrite"), I18nManager.getText("button.cancel")};
            if (!file2.exists() || JOptionPane.showOptionDialog(jFrame, I18nManager.getText("dialog.save.overwrite.text"), I18nManager.getText("dialog.save.overwrite.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
                file = file2;
                continue;
            }
            bl = true;
        } while (bl);
        return file;
    }

    public void run() {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(new FileOutputStream(this._exportFile));
            boolean[] blArray = new boolean[]{this._pointTypeSelector.getTrackpointsSelected(), this._pointTypeSelector.getWaypointsSelected(), this._pointTypeSelector.getPhotopointsSelected(), this._pointTypeSelector.getJustSelection(), this._timestampsCheckbox.isSelected()};
            int n = GpxExporter.exportData(outputStreamWriter, this._trackInfo, this._nameField.getText(), this._descriptionField.getText(), blArray, this._copySourceCheckbox.isSelected());
            outputStreamWriter.close();
            Config.setConfigString("prune.trackdirectory", this._exportFile.getParentFile().getAbsolutePath());
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.save.ok1")) + " " + n + " " + I18nManager.getText("confirm.save.ok2") + " " + this._exportFile.getAbsolutePath());
            this._dialog.dispose();
            return;
        }
        catch (IOException iOException) {
            try {
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
            }
            catch (IOException iOException2) {}
            JOptionPane.showMessageDialog(this._parentFrame, String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage(), I18nManager.getText("error.save.dialogtitle"), 0);
            this.startExport();
            return;
        }
    }

    public static int exportData(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, String string, String string2, boolean[] blArray, boolean bl) throws IOException {
        String string3;
        GpxCacherList gpxCacherList = null;
        if (bl) {
            gpxCacherList = new GpxCacherList(trackInfo.getFileInfo());
        }
        outputStreamWriter.write(GpxExporter.getHeaderString(gpxCacherList));
        String string4 = "PruneTrack";
        if (string != null && !string.equals("")) {
            string4 = string;
            outputStreamWriter.write("\t<name>");
            outputStreamWriter.write(string4);
            outputStreamWriter.write("</name>\n");
        }
        outputStreamWriter.write("\t<desc>");
        if (string2 != null && !string2.equals("")) {
            outputStreamWriter.write(string2);
        } else {
            outputStreamWriter.write("Export from Prune");
        }
        outputStreamWriter.write("</desc>\n");
        int n = 0;
        DataPoint dataPoint = null;
        boolean bl2 = false;
        boolean bl3 = blArray[0];
        boolean bl4 = blArray[1];
        boolean bl5 = blArray[2];
        boolean bl6 = blArray[3];
        boolean bl7 = blArray[4];
        int n2 = -1;
        int n3 = -1;
        if (bl6) {
            n2 = trackInfo.getSelection().getStart();
            n3 = trackInfo.getSelection().getEnd();
        }
        int n4 = trackInfo.getTrack().getNumPoints();
        int n5 = 0;
        n = 0;
        while (n < n4) {
            dataPoint = trackInfo.getTrack().getPoint(n);
            if (!bl6 || n >= n2 && n <= n3) {
                if (dataPoint.isWaypoint()) {
                    if (bl4) {
                        String string5 = string3 = bl ? GpxExporter.getPointSource(gpxCacherList, dataPoint) : null;
                        if (string3 != null) {
                            outputStreamWriter.write(string3);
                            outputStreamWriter.write(10);
                        } else {
                            GpxExporter.exportWaypoint(dataPoint, outputStreamWriter, bl7);
                        }
                        ++n5;
                    }
                } else {
                    bl2 = true;
                }
            }
            ++n;
        }
        if (bl2 && (bl3 || bl5)) {
            n5 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, bl6, bl3, bl5, bl7, true, gpxCacherList, "<rtept", "\t<rte><number>1</number>\n", null, "\t</rte>\n");
            string3 = "\t<trk><name>" + string4 + "</name><number>1</number><trkseg>\n";
            n5 += GpxExporter.writeTrackPoints(outputStreamWriter, trackInfo, bl6, bl3, bl5, bl7, false, gpxCacherList, "<trkpt", string3, "\t</trkseg>\n\t<trkseg>\n", "\t</trkseg></trk>\n");
        }
        outputStreamWriter.write("</gpx>\n");
        return n5;
    }

    private static int writeTrackPoints(OutputStreamWriter outputStreamWriter, TrackInfo trackInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, GpxCacherList gpxCacherList, String string, String string2, String string3, String string4) throws IOException {
        int n = trackInfo.getTrack().getNumPoints();
        int n2 = trackInfo.getSelection().getStart();
        int n3 = trackInfo.getSelection().getEnd();
        int n4 = 0;
        int n5 = 0;
        while (n5 < n) {
            DataPoint dataPoint = trackInfo.getTrack().getPoint(n5);
            if ((!bl || n5 >= n2 && n5 <= n3) && !dataPoint.isWaypoint() && (dataPoint.getPhoto() == null && bl2 || dataPoint.getPhoto() != null && bl3)) {
                boolean bl6;
                String string5 = GpxExporter.getPointSource(gpxCacherList, dataPoint);
                boolean bl7 = bl6 = string5 != null && string5.toLowerCase().startsWith(string) || string5 == null && !bl5;
                if (bl6) {
                    if (n4 > 0 && dataPoint.getSegmentStart() && string3 != null) {
                        outputStreamWriter.write(string3);
                    }
                    if (n4 == 0) {
                        outputStreamWriter.write(string2);
                    }
                    if (string5 != null) {
                        outputStreamWriter.write(string5);
                        outputStreamWriter.write(10);
                    } else if (!bl5) {
                        GpxExporter.exportTrackpoint(dataPoint, outputStreamWriter, bl4);
                    }
                    ++n4;
                }
            }
            ++n5;
        }
        if (n4 > 0) {
            outputStreamWriter.write(string4);
        }
        return n4;
    }

    private static String getPointSource(GpxCacherList gpxCacherList, DataPoint dataPoint) {
        if (gpxCacherList == null || dataPoint == null) {
            return null;
        }
        String string = gpxCacherList.getSourceString(dataPoint);
        if (string == null || !dataPoint.isModified()) {
            return string;
        }
        string = GpxExporter.replaceGpxTags(string, "lat=\"", "\"", dataPoint.getLatitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "lon=\"", "\"", dataPoint.getLongitude().output(17));
        string = GpxExporter.replaceGpxTags(string, "<ele>", "</ele>", dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
        string = GpxExporter.replaceGpxTags(string, "<time>", "</time>", dataPoint.getTimestamp().getText(2));
        if (dataPoint.isWaypoint()) {
            string = GpxExporter.replaceGpxTags(string, "<name>", "</name>", dataPoint.getWaypointName());
        }
        return string;
    }

    private static String replaceGpxTags(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(string2);
        int n2 = string.indexOf(string3, n + string2.length());
        if (n > 0 && n2 > 0) {
            String string5 = string.substring(n + string2.length(), n2);
            if (string4 != null && string5.equals(string4)) {
                return string;
            }
            if (string4 == null || string4.equals("")) {
                return String.valueOf(string.substring(0, n)) + string.substring(n2 + string3.length());
            }
            return String.valueOf(string.substring(0, n + string2.length())) + string4 + string.substring(n2);
        }
        if (string4 == null || string4.equals("")) {
            return string;
        }
        return null;
    }

    private static String getHeaderString(GpxCacherList gpxCacherList) {
        String string = null;
        if (gpxCacherList != null) {
            string = gpxCacherList.getFirstHeader();
        }
        if (string == null || string.length() < 5) {
            string = "<gpx version=\"1.0\" creator=\"Prune v11 activityworkshop.net\"\n xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n xmlns=\"http://www.topografix.com/GPX/1/0\" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/0 http://www.topografix.com/GPX/1/0/gpx.xsd\">\n";
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + string + "\n";
    }

    private static void exportWaypoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t<wpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">\n");
        if (dataPoint.hasAltitude()) {
            writer.write("\t\t<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>\n");
        }
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("\t\t<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>\n");
        }
        writer.write("\t\t<name>");
        writer.write(dataPoint.getWaypointName().trim());
        writer.write("</name>\n");
        String string = dataPoint.getFieldValue(Field.WAYPT_TYPE);
        if (string != null && !(string = string.trim()).equals("")) {
            writer.write("\t\t<type>");
            writer.write(string);
            writer.write("</type>\n");
        }
        writer.write("\t</wpt>\n");
    }

    private static void exportTrackpoint(DataPoint dataPoint, Writer writer, boolean bl) throws IOException {
        writer.write("\t\t<trkpt lat=\"");
        writer.write(dataPoint.getLatitude().output(17));
        writer.write("\" lon=\"");
        writer.write(dataPoint.getLongitude().output(17));
        writer.write("\">");
        if (dataPoint.hasAltitude()) {
            writer.write("<ele>");
            writer.write(dataPoint.getAltitude().getStringValue(Altitude.Format.METRES));
            writer.write("</ele>");
        }
        if (dataPoint.hasTimestamp() && bl) {
            writer.write("<time>");
            writer.write(dataPoint.getTimestamp().getText(2));
            writer.write("</time>");
        }
        writer.write("</trkpt>\n");
    }
}

