/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.DataPoint;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoDeletePhoto
implements UndoOperation {
    private int _photoIndex = -1;
    private Photo _photo = null;
    private int _pointIndex = -1;
    private DataPoint _point = null;

    public UndoDeletePhoto(Photo photo, int n, DataPoint dataPoint, int n2) {
        this._photo = photo;
        this._photoIndex = n;
        this._point = dataPoint;
        this._pointIndex = n2;
    }

    public String getDescription() {
        String string = String.valueOf(I18nManager.getText("undo.deletephoto")) + " " + this._photo.getFile().getName();
        return string;
    }

    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getPhotoList().addPhoto(this._photo, this._photoIndex);
        if (this._point != null) {
            if (!trackInfo.getTrack().insertPoint(this._point, this._pointIndex)) {
                throw new UndoException(this.getDescription());
            }
        } else {
            UpdateMessageBroker.informSubscribers();
        }
        this._photo.setDataPoint(this._point);
        if (this._point != null) {
            this._point.setPhoto(this._photo);
        }
    }
}

