/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.PhotoList;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoOperation;

public class UndoDeleteRange
implements UndoOperation {
    private int _startIndex = -1;
    private DataPoint[] _points = null;
    private PhotoList _photoList = null;
    private DataPoint _nextTrackPoint = null;
    private boolean _segmentStart = false;

    public UndoDeleteRange(TrackInfo trackInfo) {
        this._startIndex = trackInfo.getSelection().getStart();
        this._points = trackInfo.cloneSelectedRange();
        this._photoList = trackInfo.getPhotoList().cloneList();
        this._nextTrackPoint = trackInfo.getTrack().getNextTrackPoint(this._startIndex + this._points.length);
        if (this._nextTrackPoint != null) {
            this._segmentStart = this._nextTrackPoint.getSegmentStart();
        }
    }

    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.deleterange")) + " (" + this._points.length + ")";
    }

    public void performUndo(TrackInfo trackInfo) {
        trackInfo.getPhotoList().restore(this._photoList);
        int n = 0;
        while (n < this._points.length) {
            DataPoint dataPoint = this._points[n];
            if (dataPoint != null && dataPoint.getPhoto() != null) {
                dataPoint.getPhoto().setDataPoint(dataPoint);
            }
            ++n;
        }
        trackInfo.getTrack().insertRange(this._points, this._startIndex);
        if (this._nextTrackPoint != null) {
            this._nextTrackPoint.setSegmentStart(this._segmentStart);
        }
    }
}

