
{ Turbo Forms }
{ Copyright (c) 1989 by Borland International, Inc. }

Unit Forms;
{ Turbo Pascal 5.5 object-oriented example.
  This unit defines field- and form-editing object types.
  Refer to OOPDEMOS.DOC for an overview of this unit.
}

{$S-}

Interface

Uses Objects;

Const
  
  CSkip  = ^@;
  CHome  = ^A;
  CRight = ^D;
  CPrev  = ^E;
  CEnd   = ^F;
  CDel   = ^G;
  CBack  = ^H;
  CSave  = ^J;
  CEnter = ^M;
  CUndo  = ^R;
  CLeft  = ^S;
  CIns   = ^V;
  CNext  = ^X;
  CClear = ^Y;
  CEsc   = ^[;
  
Type
  
  FStringPtr = ^FString;
  FString = String [79];
  
  FieldPtr = ^Field;
  Field = Object (Node)
            X, Y, Size: Integer;
            Title: FStringPtr;
            Value: Pointer;
            Extra: Record End;
            Constructor Init (PX, PY, PSize: Integer; PTitle: FString);
            Constructor Load (Var S: Stream);
            Destructor Done; Virtual;
            Procedure Clear; Virtual;
            Function Edit: Char; Virtual;
            Procedure Show; Virtual;
            Procedure Store (Var S: Stream);
          End;
  
  FTextPtr = ^FText;
  FText = Object (Field)
            Len: Integer;
            Constructor Init (PX, PY, PSize: Integer; PTitle: FString;
            PLen: Integer);
            Function Edit: Char; Virtual;
            Procedure GetStr (Var S: FString); Virtual;
            Function PutStr (Var S: FString): Boolean; Virtual;
            Procedure Show; Virtual;
          End;
  
  FStrPtr = ^FStr;
  FStr = Object (FText)
           Constructor Init (PX, PY: Integer; PTitle: FString; PLen: Integer);
           Procedure GetStr (Var S: FString); Virtual;
           Function PutStr (Var S: FString): Boolean; Virtual;
         End;
  
  FNumPtr = ^FNum;
  FNum = Object (FText)
           Procedure Show; Virtual;
         End;
  
  FIntPtr = ^FInt;
  FInt = Object (FNum)
           Min, Max: LongInt;
           Constructor Init (PX, PY: Integer; PTitle: FString;
           PMin, PMax: LongInt);
           Procedure GetStr (Var S: FString); Virtual;
           Function PutStr (Var S: FString): Boolean; Virtual;
         End;
  
  FZipPtr = ^FZip;
  FZip = Object (FInt)
           Constructor Init (PX, PY: Integer; PTitle: FString);
           Procedure GetStr (Var S: FString); Virtual;
           Function PutStr (Var S: FString): Boolean; Virtual;
         End;
  
  FRealPtr = ^FReal;
  FReal = Object (FNum)
            Decimals: Integer;
            Constructor Init (PX, PY: Integer; PTitle: FString;
            PLen, PDecimals: Integer);
            Procedure GetStr (Var S: FString); Virtual;
            Function PutStr (Var S: FString): Boolean; Virtual;
          End;
  
  FormPtr = ^Form;
  Form = Object (Base)
           X1, Y1, X2, Y2, Size: Integer;
           Fields: List;
           Constructor Init (PX1, PY1, PX2, PY2: Integer);
           Constructor Load (Var S: Stream);
           Destructor Done; Virtual;
           Function Edit: Char;
           Procedure Show (Erase: Boolean);
           Procedure Add (P: FieldPtr);
           Procedure Clear;
           Procedure Get (Var FormBuf);
           Procedure Put (Var FormBuf);
           Procedure Store (Var S: Stream);
         End;
  
  FStream = Object (BufStream)
              Procedure RegisterTypes; Virtual;
            End;
  
  ColorIndex = (BackColor, ForeColor, TitleColor, ValueColor);
  
Procedure Beep;
Procedure Color (C: ColorIndex);
Function ReadChar: Char;

Implementation

Uses Crt;

Type
  Bytes = Array [0..32767] Of Byte;
  
  { Field }
  
  Constructor Field. Init (PX, PY, PSize: Integer; PTitle: FString);
Begin
  X := PX;
  Y := PY;
  Size := PSize;
  GetMem (Title, Length (PTitle) + 1);
  Title^ := PTitle;
  GetMem (Value, Size);
End;

Constructor Field. Load (Var S: Stream);
Var
  L: Byte;
Begin
  S. Read (X, SizeOf (Integer) * 3);
  S. Read (L, SizeOf (Byte) );
  GetMem (Title, L + 1);
  Title^ [0] := Chr (L);
  S. Read (Title^ [1], L);
  GetMem (Value, Size);
  S. Read (Extra, SizeOf (Self) - SizeOf (Field) );
End;

Destructor Field. Done;
Begin
  FreeMem (Value, Size);
  FreeMem (Title, Length (Title^) + 1);
End;

Procedure Field. Clear;
Begin
  FillChar (Value^, Size, 0);
End;

Function Field. Edit: Char;
Begin
  Abstract;
End;

Procedure Field. Show;
Begin
  Abstract;
End;

Procedure Field. Store (Var S: Stream);
Begin
  S. Write (X, SizeOf (Integer) * 3);
  S. Write (Title^, Length (Title^) + 1);
  S. Write (Extra, SizeOf (Self) - SizeOf (Field) );
End;

{ FText }

Constructor FText. Init (PX, PY, PSize: Integer; PTitle: FString;
  PLen: Integer);
Begin
  Field. Init (PX, PY, PSize, PTitle);
  Len := PLen;
End;

Function FText. Edit: Char;
Var
  P: Integer;
  CH: Char;
  Start, Stop: Boolean;
  S: FString;
Begin
  P := 0;
  Start := True;
  Stop := False;
  GetStr (S);
  Repeat
    GotoXY (X, Y);
    Color (TitleColor);
    Write (Title^);
    Color (ValueColor);
    Write (S, '': Len - Length (S) );
    GotoXY (X + Length (Title^) + P, Y);
    CH := ReadChar;
    Case CH Of
      #32..#255:
                Begin
                  If Start Then S := '';
                  If Length (S) < Len Then
                  Begin
                    Inc (P);
                    Insert (CH, S, P);
                  End;
                End;
      CLeft: If P > 0 Then Dec (P);
      CRight: If P < Length (S) Then Inc (P) Else;
      CHome: P := 0;
      CEnd: P := Length (S);
      CDel: Delete (S, P + 1, 1);
      CBack:
              If P > 0 Then
              Begin
                Delete (S, P, 1);
                Dec (P);
              End;
      CClear:
             Begin
               S := '';
               P := 0;
             End;
      CUndo:
            Begin
              GetStr (S);
              P := 0;
            End;
      CEnter, CNext, CPrev, CSave:
                                    If PutStr (S) Then
                                    Begin
                                      Show;
                                      Stop := True;
                                    End Else
      Begin
        Beep;
        P := 0;
      End;
      CEsc: Stop := True;
      Else
        Beep;
    End;
    Start := False;
  Until Stop;
  Edit := CH;
End;

Procedure FText. GetStr (Var S: FString);
Begin
  Abstract;
End;

Function FText. PutStr (Var S: FString): Boolean;
Begin
  Abstract;
End;

Procedure FText. Show;
Var
  S: FString;
Begin
  GetStr (S);
  GotoXY (X, Y);
  Color (TitleColor);
  Write (Title^);
  Color (ValueColor);
  Write (S, '': Len - Length (S) );
End;

{ FStr }

Constructor FStr. Init (PX, PY: Integer; PTitle: FString; PLen: Integer);
Begin
  FText. Init (PX, PY, PLen + 1, PTitle, PLen);
End;

Procedure FStr. GetStr (Var S: FString);
Begin
  S := FString (Value^);
End;

Function FStr. PutStr (Var S: FString): Boolean;
Begin
  FString (Value^) := S;
  PutStr := True;
End;

{ FNum }

Procedure FNum. Show;
Var
  S: FString;
Begin
  GetStr (S);
  GotoXY (X, Y);
  Color (TitleColor);
  Write (Title^);
  Color (ValueColor);
  Write (S: Len);
End;

{ FInt }

Constructor FInt. Init (PX, PY: Integer; PTitle: FString;
  PMin, PMax: LongInt);
Var
  L: Integer;
  S: String [15];
Begin
  Str (PMin, S); L := Length (S);
  Str (PMax, S); If L < Length (S) Then L := Length (S);
  FNum. Init (PX, PY, SizeOf (LongInt), PTitle, L);
  Min := PMin;
  Max := PMax;
End;

Procedure FInt. GetStr (Var S: FString);
Begin
  Str (LongInt (Value^), S);
End;

Function FInt. PutStr (Var S: FString): Boolean;
Var
  N: LongInt;
  E: Integer;
Begin
  Val (S, N, E);
  If (E = 0) And (N >= Min) And (N <= Max) Then
  Begin
    LongInt (Value^) := N;
    PutStr := True;
  End Else PutStr := False;
End;

{ FZip }

Constructor FZip. Init (PX, PY: Integer; PTitle: FString);
Begin
  FInt. Init (PX, PY, PTitle, 0, 99999);
End;

Procedure FZip. GetStr (Var S: FString);
Begin
  FInt. GetStr (S);
  Insert (Copy ('0000', 1, 5 - Length (S) ), S, 1);
End;

Function FZip. PutStr (Var S: FString): Boolean;
Begin
  PutStr := (Length (S) = 5) And FInt. PutStr (S);
End;

{ FReal }

Constructor FReal. Init (PX, PY: Integer; PTitle: FString;
  PLen, PDecimals: Integer);
Begin
  FNum. Init (PX, PY, SizeOf (Real), PTitle, PLen);
  Decimals := PDecimals;
End;

Procedure FReal. GetStr (Var S: FString);
Begin
  Str (Real (Value^): 0: Decimals, S);
End;

Function FReal. PutStr (Var S: FString): Boolean;
Var
  R: Real;
  E: Integer;
  T: FString;
Begin
  Val (S, R, E);
  PutStr := False;
  If E = 0 Then
  Begin
    Str (R: 0: Decimals, T);
    If Length (T) <= Len Then
    Begin
      Real (Value^) := R;
      PutStr := True;
    End;
  End;
End;

{ Form }

Constructor Form. Init (PX1, PY1, PX2, PY2: Integer);
Begin
  X1 := PX1;
  Y1 := PY1;
  X2 := PX2;
  Y2 := PY2;
  Size := 0;
  Fields. Clear;
End;

Constructor Form. Load (Var S: Stream);
Begin
  S. Read (X1, SizeOf (Integer) * 5);
  Fields. Load (S);
End;

Destructor Form. Done;
Begin
  Fields. Delete;
End;

Function Form. Edit: Char;
Var
  P: FieldPtr;
  CH: Char;
Begin
  Window (X1, Y1, X2, Y2);
  P := FieldPtr (Fields. First);
  Repeat
    CH := P^. Edit;
    Case CH Of
      CEnter, CNext: P := FieldPtr (P^. Next);
      CPrev: P := FieldPtr (P^. Prev);
    End;
  Until (CH = CSave) Or (CH = CEsc);
  Edit := CH;
  Window (1, 1, 80, 25);
End;

Procedure Form. Show (Erase: Boolean);
Var
  P: FieldPtr;
Begin
  Window (X1, Y1, X2, Y2);
  {  if Erase then
  begin
  Color(ForeColor);
  ClrScr;
  end; }
  P := FieldPtr (Fields. First);
  While P <> Nil Do
  Begin
    P^. Show;
    P := FieldPtr (Fields. Next (P) );
  End;
  Window (1, 1, 80, 25);
End;

Procedure Form. Add (P: FieldPtr);
Begin
  Inc (Size, P^. Size);
  Fields. Append (P);
End;

Procedure Form. Clear;
Var
  P: FieldPtr;
Begin
  P := FieldPtr (Fields. First);
  While P <> Nil Do
  Begin
    P^. Clear;
    P := FieldPtr (Fields. Next (P) );
  End;
End;

Procedure Form. Get (Var FormBuf);
Var
  I: Integer;
  P: FieldPtr;
Begin
  I := 0;
  P := FieldPtr (Fields. First);
  While P <> Nil Do
  Begin
    Move (P^. Value^, Bytes (FormBuf) [I], P^. Size);
    Inc (I, P^. Size);
    P := FieldPtr (Fields. Next (P) );
  End;
End;

Procedure Form. Put (Var FormBuf);
Var
  I: Integer;
  P: FieldPtr;
Begin
  I := 0;
  P := FieldPtr (Fields. First);
  While P <> Nil Do
  Begin
    Move (Bytes (FormBuf) [I], P^. Value^, P^. Size);
    Inc (I, P^. Size);
    P := FieldPtr (Fields. Next (P) );
  End;
End;

Procedure Form. Store (Var S: Stream);
Begin
  S. Write (X1, SizeOf (Integer) * 5);
  Fields. Store (S);
End;

{ FStream }

Procedure FStream. RegisterTypes;
Begin
  BufStream. RegisterTypes;
  Register (TypeOf (FStr), @FStr. Store, @FStr. Load);
  Register (TypeOf (FInt), @FInt. Store, @FInt. Load);
  Register (TypeOf (FZip), @FZip. Store, @FZip. Load);
  Register (TypeOf (FReal), @FReal. Store, @FReal. Load);
End;

{ Global routines }

Procedure Beep;
Begin
  Sound (500); Delay (25); NoSound;
End;

Procedure Color (C: ColorIndex);
Type
  Palette = Array [ColorIndex] Of Byte;
Const
  CP: Palette = (LightBlue, LightBlue, Blue * 16 + White, 16 * Black + White);
  MP: Palette = ($07, $70, $70, $07);  {7,70,70,7}
Begin
  If LastMode = CO80 Then TextAttr := CP [C] Else TextAttr := MP [C];
End;

Function ReadChar: Char;
Var
  CH: Char;
Begin
  CH := ReadKey;
  Case CH Of
    #0:
         Case ReadKey Of
           #15, #72: CH := CPrev;    { Shift-Tab, Up }
           #60: CH := CSave;         { F2 }
           #71: CH := CHome;         { Home }
           #75: CH := CLeft;         { Left }
           #77: CH := CRight;        { Right }
           #79: CH := CEnd;          { End }
           #80: CH := CNext;         { Down }
           #82: CH := CIns;          { Ins }
           #83: CH := CDel;          { Del }
         End;
    #9: CH := CNext;              { Tab }
  End;
  ReadChar := CH;
End;

End.
