Unit Input;

Interface

Uses Crt, DOS;
Type charset = Set Of Char;

Const
  nocursor  = $2000;
  inscursor = $0507;
  oldcursor = $0607;

  NULL = #0;
  BS = #8;
  FORMFEED = #12;
  CR = #13;
  ESC = #27;
  TABKEY = #9;
  HOMEKEY = #199;
  ENDKEY = #207;
  UPKEY = #200;
  DOWNKEY = #208;
  PGUPKEY = #201;
  PGDNKEY = #209;
  LEFTKEY = #203;
  INSKEY = #210;
  RIGHTKEY = #205;
  DELKEY = #211;
  CTRLLEFTKEY = #243;
  CTRLRIGHTKEY = #244;
  F1 = #187;
  F2 = #188;
  F3 = #189;
  F4 = #190;
  F5 = #191;
  F6 = #192;
  F7 = #193;
  F8 = #194;
  F9 = #195;
  F10 = #196;

  menuline  : Byte   = 24;
  MENUCOLOR : Byte   = 1;

  ins       : Boolean = False;

  editelo   : Byte   = White;
  edithat   : Byte   = Blue;
  editero   : Byte   = 1;


Procedure fillsp (Var s: String; len: Integer); { ' '-el feltolt                 }
Function GetKey : Char;                { Reads the next keyboard character }
Function cutsp (s: String): String;
Function EditStr (Var S : String; Legal : charset; X, Y: Byte;
                    MaxLength : Word) : Char;
     { Returns [cr,esc,upkey,downkey] }
Procedure getstr (szov: String; Var S : String; Legal : charset;
                 X, Y: Byte; MaxLength : Word) ;
Procedure uzki (szov: String);
Function menu (szov: String): Char;
     { karakter elott ! intenziv,karakter elott @ nem intenziv,
       nagybetu intenziv}
Function pmenu (szov: String): Char;
Procedure writexy (X, Y: Byte; szov: String);
Procedure keret (X, Y, xx, yy, sd: Byte);    { sd in [1,2]                      }
Procedure szin (e, h, i: Byte);            { eloter, hatter, high=1 low=0     }
Function getnum (szov: String; szam: LongInt): LongInt;
Procedure Cursor (c: Word);
Function downcase (CH: Char): Char;
Function supcase (s: String): String;

Implementation

Procedure fillsp (Var s: String; len: Integer);
Begin
  If Length (s) < len Then
    FillChar (s [Succ (Length (s) ) ], len - Length (s), ' ');
  s [0] := Chr (len);
End;


Function GetKey;
Var
  C : Char;
Begin
  C := ReadKey;
  Repeat
    If C = NULL Then
    Begin
      C := ReadKey;
      If Ord (C) > 127 Then
        C := NULL
      Else
        GetKey := Chr (Ord (C) + 128);
    End
    Else
      GetKey := C;
  Until C <> NULL;
End; { GetKey }

Function cutsp (s: String): String;
Var cpos: Word;
Begin
  Cpos := Length (s);
  While (s [Cpos] = ' ') And (Cpos > 0) Do Begin Dec (Cpos); s [0] := Pred (s [0] ); End;
  cutsp := s;
End;


Function EditStr;
Var txtat : Word;
Var
  CPos : Word;
  CH : Char;
Begin
  txtat := TextAttr;
  szin (editelo, edithat, editero);
  s := cutsp (s);
  CPos := 1{Succ(Length(S))} ;
  Repeat
    If ins Then Cursor (inscursor) Else Cursor (oldcursor);
    GotoXY (X, Y);
    Write (S, '': (maxlength - Length (S) ) );
    GotoXY (X + CPos - 1, Y);
    CH := GetKey;
    Case CH Of
      HOMEKEY : CPos := 1;
      ENDKEY  : CPos := Succ (Length (S) );
      INSKEY  : 
                Begin
                  Ins := Not Ins;
                End;
      LEFTKEY : If CPos > 1 Then Dec (CPos);
      RIGHTKEY : If CPos <= Length (S) Then Inc (CPos);
      BS      : If CPos > 1 Then Begin
        Delete (S, Pred (CPos), 1);
        Dec (CPos);
      End;
      DELKEY  : If CPos <= Length (S) Then
        Delete (S, CPos, 1);
      CR      : ;
      {      UPKEY, DOWNKEY : Ch := CR;   }
      ESC     : ;
      Else Begin
        If ( (Legal = [] ) Or (CH In Legal) ) And
           ( (CH >= ' ') And (CH <= '~') ) And
           (Length (S) < MaxLength) 
        Then
        Begin
          If Ins Then
            Insert (CH, S, CPos)
          Else If CPos > Length (S) Then
            S := S + CH
          Else
            S [CPos] := CH;
          Inc (CPos);
        End;
      End;
    End; { case }
  Until CH In [CR, ESC, UPKEY, DOWNKEY];
  EditStr := CH ;
  GotoXY (X, Y);
  TextAttr := txtat;
  HighVideo;
  Write (S, '': (maxlength - Length (S) ) );
  TextAttr := txtat;
  fillsp (s, maxlength);
  Cursor (oldcursor);
End; { EditString }

Procedure getstr ;
Var CH: Char;
Begin
  GotoXY (X, Y);
  Write (szov);
  X := X + Length (szov);
  CH := editstr (S, Legal, X, Y, MaxLength);
End;

Procedure uzki; { (szov:linestr); }
Var txtat : Word;
    i, j: Byte;

Begin
  j := 0;
  For i := 1 To Length (szov) Do If szov [i] <> '!' Then Inc (j);
  GotoXY (1, menuline);
  txtat := TextAttr;
  TextBackground (MENUCOLOR);
  ClrEol;
  Write ('': (80 - j) Div 2);
  For i := 1 To Length (szov) Do Begin
    If (szov [i - 1] = '!') Then Begin
      HighVideo;
    End
    Else LowVideo;
    If szov [i] <> '!' Then Write (szov [i] );
  End;
  TextAttr := txtat;
End;


Function menu (szov: String): Char;
Var txtat : Word;
    i, j: Byte;
    s: Char;
    lehet: charset;
Begin
  txtat := TextAttr;
  Cursor (nocursor);
  j := 0;
  For i := 1 To Length (szov) Do If Not (szov [i] In ['!', '@'] ) Then Inc (j);
  lehet := [cr, leftkey, rightkey, upkey, downkey, homekey, endkey, pgupkey, pgdnkey, ESC];
  lehet := lehet + [f1, f2, f3, f4, f5, f6, f7, f8, f9, f10];
  GotoXY (1, menuline);
  TextBackground (MENUCOLOR);
  ClrEol;
  Write ('': (80 - j) Div 2);
  For i := 1 To Length (szov) Do Begin
    If (szov [i] In ['A'..'Z'] ) Or (szov [i - 1] In ['!'] ) Then Begin
      If szov [i - 1] <> '@' Then Begin
        lehet := lehet + [szov [i] ];
        HighVideo;
      End;
    End
    Else LowVideo;
    If Not (szov [i] In ['!', '@'] ) Then Write (szov [i] );
  End;
  Repeat
    s := getkey;
  Until UpCase (s) In lehet;
  menu := s;
  szin (White, Black, 0);
  Cursor (oldcursor);
  TextAttr := txtat;
End;

Function pmenu (szov: String): Char;
Var txtat : Word;
Const hol: ShortInt = 1;
      ii: ShortInt = 1;
      lehet: charset = [ESC, CR];
Var i: Byte;
    db: ShortInt;
    CH: Char;
    st: String [20];
    X, Y: Integer;

Procedure kiir;
Var i: Byte;
Begin
  GotoXY (1, menuline);
  ii := 2;
  st := '';
  For i := 1 To Length (szov) Do Begin
    If szov [i] = ',' Then Begin
      If 2 * hol = ii Then Begin
        TextBackground (Black);
        X := WhereX;
        Y := WhereY;
      End
      Else TextBackground (menucolor);
      Inc (ii);
    End
    Else Begin
      If szov [i] In ['A'..'Z'] Then Begin
        lehet := lehet + [downcase (szov [i] ) ];
        st := st + downcase (szov [i] );
        HighVideo;
      End
      Else LowVideo;
      Write (szov [i] );
    End;
  End;
End;

Begin
  txtat := TextAttr;
  Cursor (nocursor);
  GotoXY (1, menuline);
  TextBackground (MENUCOLOR);
  ClrEol;
  Repeat
    kiir;
    CH := getkey;
    Case CH Of
      leftkey : Dec (hol);
      rightkey: Inc (hol);
    End;
    hol := ( (Length (st) + hol - 1) Mod Length (st) ) + 1;
  Until CH In lehet;
  If CH = CR Then CH := st [hol]
  Else Begin
    hol := 0;
    Repeat Inc (hol);
    Until CH = st [hol];
  End;
  kiir;
  Cursor (oldcursor);
  TextAttr := txtat;
  GotoXY (X, Y + 1);
  pmenu := CH;
End;


Procedure writexy; {(x,y:byte;szov:string);}
Begin
  GotoXY (X, Y); Write (szov);
End;

Procedure keret; {(x,y,xx,yy,sd:byte);}
Const svonal: Array [1..2, 1..6] Of Char = ( (#196, #179, #218, #191, #192, #217),
                                       (#205, #186, #201, #187, #200, #188) );
Var i: Byte;
    szov: String [80];
Begin
  szov [0] := Chr (xx - X - 1);
  FillChar (szov [1], xx - X - 1, svonal [sd, 1] );
  GotoXY (X + 1, Y); Write (szov);
  GotoXY (X + 1, yy); Write (szov);
  For i := Y + 1 To yy - 1 Do Begin
    GotoXY (X, i); Write (svonal [sd, 2] );
    GotoXY (xx, i); Write (svonal [sd, 2] );
  End;
  writexy (X, Y, svonal [sd, 3] );
  writexy (xx, Y, svonal [sd, 4] );
  writexy (X, yy, svonal [sd, 5] );
  writexy (xx, yy, svonal [sd, 6] );
End;

Procedure szin { (e,h,i:byte) } ;
Begin
  TextColor (e);
  TextBackground (h);
  Case i Of
    0: LowVideo;
    1: HighVideo;
  End;
End;

Function getnum (szov: String; szam: LongInt): LongInt;
Var s, ss : String;
    CH: Char;
    cod, sz: Integer;
Begin
  GotoXY (1, menuline);
  ClrEol;
  If szam <> 0 Then
    Str (szam, s)
  Else s := '';
  Write (szov);
  CH := editstr (s, ['0'..'9', '-'], Length (szov) + 1, menuline, 10);
  ss := '';
  sz := 1;
  While s [sz] <> ' ' Do Begin ss := ss + s [sz]; Inc (sz); End;
  Val (ss, sz, cod);
  If cod <> 0 Then sz := 0;
  getnum := sz;
End;


Procedure Cursor (c: Word);
Var regi: Word;
    reg : Registers;
Begin
  reg. AH := 1;
  reg. BH := 0;
  reg. CX := c;
  Intr ($10, reg);
End;

Function downcase (CH: Char): Char;
Begin
  If (CH >= 'A') And (CH <= 'Z') Then downcase := Chr (Ord (CH) - Ord ('A') + Ord ('a') )
  Else downcase := CH;
End;


Function supcase (s: String): String;
Var i: Integer;
Begin
  For i := 1 To Length (s) Do
    s [i] := UpCase (s [i] );
  supcase := s;
End;

End.
