#! /usr/bin/env python
# -*- python coding: utf-8 -*-
# Copyright © 2012 R.F. Smith <rsmith@xs4all.nl>. All rights reserved.
# $Date: 2012-06-04 21:17:53 +0200 $
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

'''Reads an STL file and prints information about the object or a text
representation of the object in the file.'''

import sys
import stl

name = ('stlinfo [ver. ' + '$Revision: 3.1 $'[11:-2] +
        '] ('+'$Date: 2012-06-04 21:17:53 +0200 $'[7:-2]+')')

def usage():
    print name
    print "Usage: stlinfo [-t|-e] infile"

## This is the main program ##
print_text = False
print_edges = False
if len(sys.argv) == 1:
    usage()
    sys.exit(0)
if sys.argv[1] == '-t':
    print_text = True
    del sys.argv[1]
elif sys.argv[1] == '-e':
    print_edges = True
    del sys.argv[1]
elif sys.argv[1].startswith('-'):
    print "Unknown option '{}'. Exiting".format(sys.argv[1])
    sys.exit(1)
# Open the file
try:
    stlobj = stl.Surface(sys.argv[1])
except:
    print "The file '{}' cannot be read or parsed. Exiting.".format(sys.argv[1])
    exit(1)
# Process the file, don't print output
for result in stlobj.processfacets:
    pass
if print_text:
    print stlobj
else:
    print 'Generated by {}'.format(name)
    print stlobj.stats()
    if print_edges:
        el = stlobj.edges()
        se = [x for x in el if len(x.refs) < 2]
        s = '{} unique edges, {} open edges.'
        print s.format(len(el), len(se))
