#!/usr/bin/env python

# -*- coding: utf8 -*- 

#***********************************************************************
# pysycache : a tool for learn to use the mouse
# Copyright (C) 2005-2006 Vincent DEROO (vincent.pysycache@free.fr)
#
# This tool is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#***********************************************************************



#*******************************************************************************
# Importation des modules
#*******************************************************************************
import sys
import getopt, string
import random
import time

import random, os
import pygame
from pygame.locals import *
import datas
from datasclass import BtnMenu
import const
import glob


EVTFANTOME = USEREVENT + 1

MODENORMAL = 0
MODEFANTOM = 1
MODEMONTRE = 2

CARREAUBIG = 0
CARREAUNORMAL = 1
CARREAUSMALL = 2

CACHED = 0
NOCACHED = 1

DUREETRANSITION = 3






#*******************************************************************************
#                                                                              #
#                                                                              #
#                                     Classe                                   #
#                                                                              #
#                                                                              #
#*******************************************************************************

class Carreau:
	"""Carreau : partie du cache - Est affiche lorsque la souris passe dessus """	
	numligne = 0
	numcol = 0
	etat = CACHED	#CACHED : cache
					#NOCACHED : affiche



#*******************************************************************************
#                                                                              #
#                                                                              #
#                                    Fonctions                                 #
#                                                                              #
#                                                                              #
#*******************************************************************************


def InitialiseDessin(idxdirectory, WithHasard):
	"""Initialize new picture """
	global GCacheImage				#cache de l'image 
	global GImageATrouver			#image a trouver
	const.GTabCarreau[:] = []   	#vider
									#tableau avec toutes les infos sur les carreaux
	global GIdxCache				#Indice du cache dans sa liste

	const.GTypeSouris = 1

	GMaSouris_position.left = const.GPosDepX + 1 
	GMaSouris_position.top = const.GPosDepY + 1
	pygame.mouse.set_pos((GMaSouris_position.left, GMaSouris_position.top))
	pygame.event.set_grab(1)

	#initialisation des carres : la taille d'une photo est de 700 x 525
	nblarg = 700 / const.GTailleLarg
	nbhaut = 525 / const.GTailleHaut
	const.GNbCarreau = nblarg * nbhaut

	for i in range(nblarg):
		for j in range(nbhaut):
			car = Carreau()
			car.numligne = i
			car.numcol = j
			car.etat = CACHED
			const.GTabCarreau.append(car)

	directory = GLstThemesMove[idxdirectory]

	#on choisi une image (pas au hasard car est fait lors d'une etape avant)
	imgdessous = GLstImage[const.GIdxImage]

	#on choisi un cache (au hasard) parmi ceux associes a l'image...
	strtmp = GLstImgCache[const.GIdxImage]
	if WithHasard == 1:
		if len(strtmp) == 1:
			GIdxCache = 0
		else :
			GIdxCache = random.randint(0, len(strtmp) - 1)
	imgcache =  strtmp[GIdxCache]

	#...et le son associe
	strtmp = GLstSndCache[const.GIdxImage]
	sndcache = strtmp[GIdxCache]

	#chargement du dessin servant de cache
	filename = os.path.join(directory, 'cache', imgcache)
	GCacheImage, background_rect = datas.load_image('themes-move', filename)

	#on copie ce cache sur l'image de fond
	screen = pygame.display.get_surface()  
	Gbackground_image.blit(GCacheImage, (0 + const.MARGELEFT, 0 + const.MARGETOP))
	#on copie cette image sur l'ecran
	screen.blit(Gbackground_image, (0, 0 ))

	#si le cache est associe a un son, on le joue
	if const.GWithSound == 1:
		(filepath, filename) = os.path.split(sndcache)
		datas.load_sound(filepath, filename)
		pygame.time.wait(200)

	#chargement du dessin a trouver
	filename = os.path.join(directory, imgdessous)
	GImageATrouver, background_rect = datas.load_image('themes-move', filename)

	#redessin de la souris a sa position 
	GMaSouris_position.left = const.GPosDepX
	GMaSouris_position.top = const.GPosDepY

	LstBtn.draw(screen)
	screen.blit(GMaSouris, GMaSouris_position)
	pygame.mouse.set_pos((GMaSouris_position.left, GMaSouris_position.top))
	#rafraichissement
	pygame.display.flip()
	pygame.event.set_grab(0)
	




#*******************************************************************************
# Definit la taille des carreaux du cache
#*******************************************************************************
def GetTailleCarreau(idxtaille):
	"""Get the size of a tile by level """
	if idxtaille == CARREAUBIG:
		const.GTailleLarg = 100		#700 / 7
		const.GTailleHaut = 75		#525 / 7
	elif idxtaille == CARREAUNORMAL:
		const.GTailleLarg = 70		#700 / 10
		const.GTailleHaut = 75		#525 / 
	elif idxtaille == CARREAUSMALL:
		const.GTailleLarg = 50		#700 / 14
		const.GTailleHaut = 35		#525 / 15




#*******************************************************************************
# change le logo du theme 
#  (a partir des repertoires)
#*******************************************************************************
def ChangeLogoMove():
	""" Change logo of a theme """
	if const.GIdxThemes == 999999:
		#tous les themes
		filename = os.path.join(const.GRepPysycache, 'images', 'logo.png')
	else:
		#un theme particulier
		filename = os.path.join(const.GRepPysycache, 'themes-move', GLstThemesMove[const.GIdxThemes], 'logo.png')
	
	if os.path.isfile(filename) == True:
		imgtmp = pygame.image.load(filename)
	else:
		filename = os.path.join(const.GRepPysycache, 'images', 'logo.png')
	imgtmp = pygame.image.load(filename)

	#mise a jour de l'image du theme
	for btn in LstBtn.sprites():
		if btn.id == 5:
			#the id of the logo button
			screen = pygame.display.get_surface()
			screen.blit(Gbackground_image, (btn.rect.left, btn.rect.top), (0, 0, btn.largeur, btn.hauteur))
			btn.image.blit(imgtmp, (0, 0), (0, 0, btn.largeur, btn.hauteur))
			btn.image = imgtmp




#*******************************************************************************
# change le type du jeu 
#  0 : normal : simple disparition des carres
#  1 : mode fantome : des carres reapparaissent 
#  2 : mode chronometre : il faut aller au plus vite pour tout faire disparaitre
#*******************************************************************************
def ChangeTypeJeu():
	""" Change mode of a theme """
	if const.GModeJeu == MODENORMAL:
		filename = os.path.join(const.GRepPysycache, 'images', 'mode0.png')
	elif const.GModeJeu == MODEFANTOM:
		filename = os.path.join(const.GRepPysycache, 'images', 'mode1.png')
	else:	filename = os.path.join(const.GRepPysycache, 'images', 'mode2.png')

	if os.path.isfile(filename) == True:
		imgtmp = pygame.image.load(filename)

	#mise a jour de l'image du mode de jeu
	for btn in LstBtn.sprites():
		if btn.id == 1:
			#the id of the game mode button
			screen = pygame.display.get_surface()
			screen.blit(Gbackground_image, (btn.rect.left, btn.rect.top), (0, 0, btn.largeur, btn.hauteur))
			btn.image.blit(imgtmp, (0, 0), (0, 0, btn.largeur, btn.hauteur))
			btn.image = imgtmp



#*******************************************************************************
# Recherche les images disponibles (image(s) + cache(s)) pour un theme
# on recherche tous les fichiers de definition (*.dfg)
# il y a 1 fichier dfg par image a afficher
# le contenu de ce fichier dfg est la liste des caches a associer a cette image
#*******************************************************************************
def LoadListImage(themename):
	""" Find all available pictures of a theme directory """

	filtre = os.path.join(const.GRepPysycache, 'themes-move', themename, '*.dfg')

	#vider
	GLstImage[:] = []
	GLstImgCache[:] = []
	GLstSndCache[:] = []

	#remplir 
	for nom in glob.glob(filtre):
		if os.path.isfile(nom):
			#--- recuperation du nom (hors chemin) du fichier de definition ----
			(filepath, filename) = os.path.split(nom)
			strimg = ''
			lstcache = []	   	#va servir a recuperer la liste des caches
			lstsndcache = []	#va servir a recuperer les sons associes aux caches

			#------------- recherche de toutes les images normales -------------
			#qui ont par definition le meme nom que le fichie de definition + '.jpeg'
			(shortname, extension) = os.path.splitext(filename) 
			strimg = shortname + '.jpeg'
			GLstImage.append(strimg)

			#-------- recherche de toutes les images servant de cache ----------
			#----------------- en lisant le fichier de definition --------------
			f = open(nom, 'r')
			lignes  = f.readlines()
			for lig in lignes:
				lig = lig.strip()
				lig = lig.split(',')
				
				if len(lig) == 0:
					continue
				#fichier de cache
				nomcache = os.path.join(const.GRepPysycache, 'themes-move', themename, 'cache', lig[0])
				if os.path.isfile(nomcache):
					lstcache.append(lig[0])
					
					#fichier de son
					nomcache = os.path.join('themes-move', themename, 'cache', lig[1])
					lstsndcache.append(nomcache)
				else:
					print "error in definition file : cache file ", nomcache, " doesn't exist"

			f.close()
		GLstImgCache.append(lstcache)
		GLstSndCache.append(lstsndcache)
			



#*******************************************************************************
# Detection des evenements
#                                                                              #
#	self.listenKeys = { K_UP: self.MoveUp,
#						K_DOWN: self.MoveDown,
#						K_LEFT: self.SetVelocityLeft,
#						K_RIGHT: self.SetVelocityRight,
#						K_SPACE: self.MoveUp
#					  }
#                                                                              #
#*******************************************************************************
def DetectEvent():
	""" Traitement des evenements """

	if const.GTypeSouris == 3:
		return 1
	if const.GTypeSouris == 2:
		return 1

	for event in pygame.event.get():
		if event.type == QUIT:
			return 0
		elif event.type == EVTFANTOME:
			if const.GModeJeu == MODEFANTOM:
				#on est en mode fantome, on va voir si on fait 
				#reapparaitre des carres
				#seulement si plus de 50 / 100 sont decouverts ?
				lefthaz = random.randint(0, 700 / const.GTailleLarg - 1)
				tophaz = random.randint(0, 525 / const.GTailleHaut - 1)
				cpt = 0
				for car in const.GTabCarreau:
					if (car.numligne == lefthaz) & (car.numcol == tophaz):
						if car.etat == CACHED:
							#toujours cache
							pass
						else:
							#on affiche a nouveau le cache
							nouveauleft = lefthaz * const.GTailleLarg + 2 #+ const.MARGELEFT
							nouveautop = tophaz * const.GTailleHaut + 2# + const.MARGETOP

							#on affiche le carre de nouvelle image
							tr2 = pygame.Rect([nouveauleft, nouveautop, const.GTailleLarg, const.GTailleHaut] )
							Gbackground_image.blit(GCacheImage, [nouveauleft + const.MARGELEFT, nouveautop + const.MARGETOP], tr2 )
							const.GNbCarreau = const.GNbCarreau + 1
							car.etat = CACHED

							tr2 = pygame.Rect([nouveauleft + const.MARGELEFT, nouveautop + const.MARGETOP, const.GTailleLarg, const.GTailleHaut] )
							screen = pygame.display.get_surface() 
							screen.blit(Gbackground_image, (nouveauleft + const.MARGELEFT, nouveautop + const.MARGETOP), tr2)
#							screen.blit(GMaSouris, GMaSouris_position)
							pygame.display.flip()

							#on joue la musique
							datas.load_sound('sounds', 'fantom.wav')
						
						break
				return 1
		elif event.type == KEYUP:
			if event.key == K_ESCAPE:
				return 0
		elif event.type == MOUSEMOTION:
			#*************** evenement deplacement de la souris ***************
			if const.GTypeSouris == 1:
				return 1
			
			event0 = event.pos[0]
			event1 = event.pos[1] 
				
			#------------ decouverte image ---------------
			# les images doivent faire 702 x 527 (il n'y a aucun recadrage)
			# mais les carreaux sont calcules sur 700 * 525
			if const.GTypeSouris == 0:
				#on est en mode jeu
				screen = pygame.display.get_surface()  
			
				#redessin de ce que cachait la souris
				caseleft = int( (event.pos[0]  - const.MARGELEFT ) / const.GTailleLarg )
				casetop = int( (event.pos[1] - const.MARGETOP) / const.GTailleHaut )

				#recherche si deja coche
				for car in const.GTabCarreau:
					if (car.numligne == caseleft) & (car.numcol == casetop):
						if car.etat == CACHED:
							car.etat = NOCACHED

							nouveauleft = caseleft * const.GTailleLarg + 2
							nouveautop = casetop * const.GTailleHaut + 2

							GCarre_position.left = nouveauleft 
							GCarre_position.top = nouveautop

							#on affiche le carre de nouvelle image
							tr2 = pygame.Rect([nouveauleft, nouveautop, const.GTailleLarg, const.GTailleHaut] )
							Gbackground_image.blit(GImageATrouver, [nouveauleft + const.MARGELEFT, nouveautop + const.MARGETOP], tr2 )

							const.GNbCarreau = const.GNbCarreau - 1

							#on joue la musique
							datas.load_sound('sounds', 'pop.ogg')

						break


#OK mais lourd		screen.blit(Gbackground_image, (0,0))
				screen.blit(Gbackground_image, (0,0))
				LstBtn.draw(screen)
				#redessin de la souris a sa position actuelle
				screen.blit(GMaSouris, GMaSouris_position)
				GMaSouris_position.left = event0 
				GMaSouris_position.top = event1 
				pygame.display.flip()

			return 1
		elif event.type == MOUSEBUTTONDOWN:
			#************************** evenement clic *************************
			ok = 0
			event0 = event.pos[0]
			event1 = event.pos[1]

			#recherche du bouton concerne
			for obj in LstBtn.sprites() :
				if ( event.pos[0] >= obj.rect.left ) & ( event.pos[0] <= obj.rect.left + obj.largeur ) & ( event.pos[1] >= obj.rect.top  ) & ( event.pos[1] <= obj.rect.top + obj.hauteur ) :
					hasard = 1
					#----------- show the correct window -----------------
					if ( obj.id == 1 ) :
						#change le type du jeu (normal/chrono/fantome)
						const.GModeJeu = const.GModeJeu + 1
						if const.GModeJeu >= MODEFANTOM + 1:
							const.GModeJeu = MODENORMAL
						ChangeTypeJeu()
						hasard = 0
						ok = 1
					if ( obj.id == 2) :
						#Quitter
						return 0
					if ( obj.id == 3) :
						#image avant (dans le theme)
						if const.GIdxImage > 0:
							const.GIdxImage = const.GIdxImage - 1
						else:
							const.GIdxImage = len(GLstImage) - 1
						
						screen = pygame.display.get_surface()  
					
						#transition
						datas.ShowTransitionOfTheme(DUREETRANSITION, 'fond-move.bmp')

						ok = 1
					if ( obj.id == 4) :
						#image apres (dans le theme)
						if const.GIdxImage < len(GLstImage) - 1:
							const.GIdxImage = const.GIdxImage + 1
						else:
							const.GIdxImage = 0
						
						screen = pygame.display.get_surface()  

						#transition
						datas.ShowTransitionOfTheme(DUREETRANSITION, 'fond-move.bmp')
						
						ok = 1
					if ( obj.id == 5) :
						#autre theme
						const.GIdxThemes = const.GIdxThemes + 1
						if const.GIdxThemes == len(GLstThemesMove):
							const.GIdxThemes = 0
						LoadListImage(GLstThemesMove[const.GIdxThemes])
						
						if len(GLstImage) > 1:
							const.GIdxImage = random.randint(0, len(GLstImage) - 1)
						else:
							const.GIdxImage = 0
						ChangeLogoMove()
						ok = 1
					if ( obj.id == 6) :
						#taille carreau
						const.GTailleCarreau = const.GTailleCarreau + 1
						if const.GTailleCarreau == CARREAUSMALL + 1:
							const.GTailleCarreau = CARREAUBIG
						if const.GTailleCarreau == CARREAUBIG:
							filename = os.path.join(const.GRepPysycache, 'images', 'btn-size1.png')
						elif const.GTailleCarreau == CARREAUNORMAL:
							filename = os.path.join(const.GRepPysycache, 'images', 'btn-size2.png')
						else:
							filename = os.path.join(const.GRepPysycache, 'images', 'btn-size3.png')
						imgtmp = pygame.image.load(filename)

						#mise a jour image taille carreau
						screen = pygame.display.get_surface()
						screen.blit(Gbackground_image, (obj.rect.left, obj.rect.top), (0, 0, obj.largeur, obj.hauteur))
						obj.image.blit(imgtmp, (obj.rect.left, obj.rect.top), (0, 0, obj.largeur, obj.hauteur))
						obj.image = imgtmp
						
						hasard = 0
						ok = 1
			
					#----------- update the picture -----------------
					if ok == 1:
						const.GTypeSouris = 3
						GetTailleCarreau(const.GTailleCarreau)
						InitialiseDessin(const.GIdxThemes, hasard)
						const.tpsdebut = pygame.time.get_ticks()
					
					break

			return 1
	return 1





#*******************************************************************************
# boucle principale
# si typfull 	= 0 : mode fenetre
#				= 1 : mode plein ecran
#*******************************************************************************
def ShowWindow(typfull):
	global GMaSouris
	global Gbackground_image	#image de fond
	global GMaSouris_position
	global GCarre_position		#coordonnees du carre decouvert
	global GLstThemesMove   	#themes des images
								#est obtenue a partir du repertoire datas	
	global GLstImage			#liste des images a decouvrir (dans le repertoire de theme)
	global GLstImgCache			#liste des images qui cachent (dans le repertoire de theme)
	global GLstSndCache			#liste des sons des caches (dans le repertoire de theme)

	pygame.time.set_timer ( EVTFANTOME, 1000 )  #toutes les secondes

	screen = pygame.display.get_surface()
	
	const.GIdxThemes = 0
	const.GIdxImage = 0
	const.GModeJeu = MODENORMAL

	#musique de fond
#	music = os.path.join('music', 'jinglebells.mod')
#	pygame.mixer.music.load(os.path.join(music))
#	pygame.mixer.music.play(-1)

	const.GTypeSouris = 3

	#------------------- changer la souris en main -------------------
#	filename = os.path.join('images', 'souris.xbm')
#	maskname = os.path.join('images', 'souris-mask.xbm')
#	cursor = pygame.cursors.load_xbm(filename, maskname)
#	cursor = cursor[0], (cursor[0][0] / 2, cursor[0][1] / 2), cursor[2], cursor[3]
#	pygame.mouse.set_cursor(cursor[0], (0, 0), cursor[2], cursor[3])

	filename = dirname = os.path.join(const.GRepPysycache, 'images', 'souris.png')	 
	GMaSouris = pygame.image.load(filename)
	GCarre_position = GMaSouris.get_rect()

	#------------------ transition vers le jeu ------------------------
	Gbackground_image, background_rect = datas.load_image('images', 'fond-move.bmp')
	for i in range(300):
		screen.blit(Gbackground_image, (0, i), (0, i, 800, 1))
		screen.blit(Gbackground_image, (0, 600 - i), (0, 600 - i, 800, 1))
		pygame.display.flip()
		pygame.time.wait(8) 
	screen.blit(Gbackground_image, (0,0))
	pygame.display.flip()
	
	#-------------------- liste des boutons ----------------------
	global LstBtn
	LstBtn = pygame.sprite.RenderClear()
	#mode du jeu - 0/1/2
	LstBtn.add(BtnMenu(712, 10, 'mode0.png', 1, 85, 85))

	#indicateur de taille des carreaux
	LstBtn.add(BtnMenu(712, 110, 'btn-size2.png', 6, 85, 85))

	#image du theme
	LstBtn.add(BtnMenu(711, 504, 'logo.png', 5, 85, 85))

	#avant et apres
	LstBtn.add(BtnMenu(489, 537, 'btn-avant.png', 3, 60, 60))
	LstBtn.add(BtnMenu(603, 537, 'btn-apres.png', 4, 60, 60))
	
	#quitter
	LstBtn.add(BtnMenu(25, 535, 'btn-quitter.png', 2, 186, 60))
	
	GLstThemesMove = []
	GLstImage = []
	GLstImgCache = []
	GLstSndCache = []

	#---------------- rechercher les themes disponibles ----------------------
	repertoire = os.path.join(const.GRepPysycache, 'themes-move')
	for nom in os.listdir(repertoire):
		#ne prendre que les repertoires
		isrep = os.path.join(const.GRepPysycache, 'themes-move', nom)
		if os.path.isdir(isrep):
			GLstThemesMove.append(nom)
	if len(GLstThemesMove) == 1 :
		const.GIdxThemes = 0
	else:
		const.GIdxThemes = random.randint(0, len(GLstThemesMove) - 1)

	#---------------- rechercher les images d'un theme ----------------------
	LoadListImage(GLstThemesMove[const.GIdxThemes])

	ChangeLogoMove()

	#-------------- taille des carres --------------
	const.GTailleCarreau = CARREAUNORMAL
	GetTailleCarreau(const.GTailleCarreau)

	#-------------- affichage du dessin --------------
	#redessin de la souris au centre de l'ecran
	GMaSouris_position = GMaSouris.get_rect()


	if len(GLstImage) > 1:
		const.GIdxImage = random.randint(0, len(GLstImage) - 1)
	else:
		const.GIdxImage = 0
	InitialiseDessin(const.GIdxThemes, 1)
#	const.tpsdebut = pygame.time.get_ticks()

	const.GTypeSouris = 0

	#-------------- entree dans la boucle principale --------------
	clock = pygame.time.Clock ()
	running = 1
	while running:
		clock.tick ( 60 )	#max 60 fps / sec
		const.GTypeSouris = 0

		#recherche des evt
		running = DetectEvent()

		#verification si on a tout decouvert
		if const.GNbCarreau == 0:
			const.GTypeSouris = 1
#			tpsfin = pygame.time.get_ticks()
#			const.GTypeSouris = 1		   #on passe en mode gagne
#		pygame.mouse.set_pos((const.GPosDepX, const.GPosDepY))

			#-- on affiche l'image definitive et on attend pour la faire voir --
			screen = pygame.display.get_surface()
			screen.blit(Gbackground_image, (0,0))
#			screen.blit(GMaSouris, GMaSouris_position)
			LstBtn.draw(screen)
			pygame.display.flip()

			if const.GWithSound == 1:
				#on joue la musique de l'image
				(shortname, extension) = os.path.splitext(GLstImage[const.GIdxImage]) 
				music = os.path.join(const.GRepPysycache, 'themes-move', GLstThemesMove[const.GIdxThemes], shortname + '.ogg')
				if os.path.isfile(music) == True:
					datas.load_sound(os.path.join('themes-move', GLstThemesMove[const.GIdxThemes]), shortname + '.ogg')
				else:
					datas.load_sound(os.path.join('themes-move', GLstThemesMove[const.GIdxThemes]), shortname + '.wav')
				pygame.time.wait(500)

			#attende de 2 secondes (pour faire voir l'image)
			pygame.time.wait(2000)

			#----------------- on affiche l'image de gagne ---------------------
			datas.PlayWinnerSound()

			imggagne, imgfin_rect = datas.load_png('images', 'gagne.png')
			screen.blit(imggagne, (100, 40))
			pygame.display.flip()

			#attende de 3 secondes
			pygame.time.wait(3000)

			#transition
			datas.ShowTransitionOfTheme(DUREETRANSITION, 'fond-move.bmp')

			#on recharge une nouvelle image
			if len(GLstImage) > 1:
				if len(GLstImage) > 1:
					nvidx = random.randint(0, len(GLstImage) - 1)
				else:
					nvidx = 0
				if nvidx == const.GIdxImage:
					#si la meme image qu'actuellement, on fait un second essai
					if len(GLstImage) > 1:
						nvidx = random.randint(0, len(GLstImage) - 1)
					else:
						nvidx = const.GIdxImage = 0
				const.GIdxImage = nvidx
			GetTailleCarreau(const.GTailleCarreau)
#			pygame.mouse.set_pos((const.GPosDepX, const.GPosDepY))
#			pygame.display.flip()

#			GMaSouris_position.left = const.GPosDepX 
#			GMaSouris_position.top = const.GPosDepY
#			pygame.mouse.set_pos((const.GPosDepX + 1, const.GPosDepY + 1))
#			pygame.mouse.set_pos((const.GPosDepX, const.GPosDepY))
#			pygame.display.flip()

			InitialiseDessin(const.GIdxThemes, 1)
			const.GTypeSouris = 0
#			const.tpsdebut = pygame.time.get_ticks()
