/* ************************************************************************

   qooxdoo - the new era of web development

   http://qooxdoo.org

   Copyright:
     2004-2008 1&1 Internet AG, Germany, http://www.1und1.de

   License:
     LGPL: http://www.gnu.org/licenses/lgpl.html
     EPL: http://www.eclipse.org/org/documents/epl-v10.php
     See the LICENSE file in the project's left-level directory for details.

   Authors:
     * Sebastian Werner (wpbasti)
     * Fabian Jakobs (fjakobs)
     * Jonathan Weiß (jonathan_rass)

************************************************************************ */

/**
 * Layouter for vertical split panes.
 *
 * @internal
 */
qx.Class.define("qx.ui.splitpane.VLayout",
{
  extend : qx.ui.layout.Abstract,



  /*
  *****************************************************************************
     MEMBERS
  *****************************************************************************
  */

  members :
  {
    /*
    ---------------------------------------------------------------------------
      LAYOUT INTERFACE
    ---------------------------------------------------------------------------
    */

    // overridden
    verifyLayoutProperty : qx.core.Environment.select("qx.debug",
    {
      "true" : function(item, name, value)
      {
        this.assert(name === "type" || name === "flex", "The property '"+name+"' is not supported by the split layout!");

        if (name == "flex") {
          this.assertNumber(value);
        }

        if (name == "type") {
          this.assertString(value);
        }
      },

      "false" : null
    }),


    // overridden
    renderLayout : function(availWidth, availHeight)
    {
      var children = this._getLayoutChildren();
      var length = children.length;
      var child, type;
      var begin, splitter, slider, end;

      for (var i=0; i<length; i++)
      {
        child = children[i];
        type = child.getLayoutProperties().type;

        if (type === "splitter") {
          splitter = child;
        } else if (type === "slider") {
          slider = child;
        } else if (!begin) {
          begin = child;
        } else {
          end = child;
        }
      }

      if (begin && end)
      {
        var beginFlex = begin.getLayoutProperties().flex;
        var endFlex = end.getLayoutProperties().flex;

        if (beginFlex == null) {
          beginFlex = 1;
        }

        if (endFlex == null) {
          endFlex = 1;
        }

        var beginHint = begin.getSizeHint();
        var splitterHint = splitter.getSizeHint();
        var endHint = end.getSizeHint();

        var beginHeight = beginHint.height;
        var splitterHeight = splitterHint.height;
        var endHeight = endHint.height;

        if (beginFlex > 0 && endFlex > 0)
        {
          var flexSum = beginFlex + endFlex;
          var flexAvailable = availHeight - splitterHeight;

          var beginHeight = Math.round((flexAvailable / flexSum) * beginFlex);
          var endHeight = flexAvailable - beginHeight;

          var sizes = qx.ui.layout.Util.arrangeIdeals(beginHint.minHeight, beginHeight, beginHint.maxHeight,
            endHint.minHeight, endHeight, endHint.maxHeight);

          beginHeight = sizes.begin;
          endHeight = sizes.end;
        }
        else if (beginFlex > 0)
        {
          beginHeight = availHeight - splitterHeight - endHeight;
          if (beginHeight < beginHint.minHeight) {
            beginHeight = beginHint.minHeight;
          }

          if (beginHeight > beginHint.maxHeight) {
            beginHeight = beginHint.maxHeight;
          }
        }
        else if (endFlex > 0)
        {
          endHeight = availHeight - beginHeight - splitterHeight;
          if (endHeight < endHint.minHeight) {
            endHeight = endHint.minHeight;
          }

          if (endHeight > endHint.maxHeight) {
            endHeight = endHint.maxHeight;
          }
        }

        begin.renderLayout(0, 0, availWidth, beginHeight);
        splitter.renderLayout(0, beginHeight, availWidth, splitterHeight);
        end.renderLayout(0, beginHeight+splitterHeight, availWidth, endHeight);
      }
      else
      {
        // Hide the splitter completely
        splitter.renderLayout(0, 0, 0, 0);

        // Render one child
        if (begin) {
          begin.renderLayout(0, 0, availWidth, availHeight);
        } else if (end) {
          end.renderLayout(0, 0, availWidth, availHeight);
        }
      }
    },


    // overridden
    _computeSizeHint : function()
    {
      var children = this._getLayoutChildren();
      var length = children.length;
      var child, hint, props;
      var minHeight=0, height=0, maxHeight=0;
      var minWidth=0, width=0, maxWidth=0;

      for (var i=0; i<length; i++)
      {
        child = children[i];
        props = child.getLayoutProperties();

        // The slider is not relevant for auto sizing
        if (props.type === "slider") {
          continue;
        }

        hint = child.getSizeHint();

        minHeight += hint.minHeight;
        height += hint.height;
        maxHeight += hint.maxHeight;

        if (hint.minWidth > minWidth) {
          minWidth = hint.minWidth;
        }

        if (hint.width > width) {
          width = hint.width;
        }

        if (hint.maxWidth > maxWidth) {
          maxWidth = hint.maxWidth;
        }
      }

      return {
        minHeight : minHeight,
        height : height,
        maxHeight : maxHeight,
        minWidth : minWidth,
        width : width,
        maxWidth : maxWidth
      };
    }
  }
});
