#!/bin/sh

QUANTIS_ROOT_DIR="`pwd`/../../../.."
LIBAPPS_DIR="${QUANTIS_ROOT_DIR}/Libs-Apps/"

PKG_NAME="IDQQuantisLibs-Apps_GCC-2.3-sol10-sparc"

CheckResult()
{
  RESULT=$1
  if [ "${RESULT}" != "0" ]; then
    echo "ERROR $1"
    exit
  else
    echo "OK"
  fi
}



if [ -d build ]; then
  rm -Rf build
fi
mkdir build

if [ -d build64 ]; then
  rm -Rf build64
fi
mkdir build64

if [ -d opt ]; then
 rm -Rf opt
fi

# Compile 32-bit version of library and application
cd build/
echo "Creating makefiles..."
cmake ${LIBAPPS_DIR} -DDISABLE_QUANTIS_USB=1 -DDISABLE_EASYQUANTIS_GUI=1
CheckResult $?

echo "Building..."
make
CheckResult $?

echo "Installing..."
make DESTDIR=../ install
CheckResult $?

cd ..


# Compile 64-bit version of library
cd build64
echo "Creating makefiles..."
cmake ${LIBAPPS_DIR} -DDISABLE_QUANTIS_USB=1 -DDISABLE_EASYQUANTIS=1 -DFORCE64BIT=1
CheckResult $?

echo "Building..."
make
CheckResult $?

echo "Installing..."
make DESTDIR=../ install
CheckResult $?

cd ..

# Copy includes
INC_DIR="opt/IDQQuantis/include/"

echo "Copying includes..."
mkdir -p "${INC_DIR}"
CheckResult $?

cp ${LIBAPPS_DIR}/Quantis/*.h "${INC_DIR}"
CheckResult $?

cp ${LIBAPPS_DIR}/Quantis/*.hpp "${INC_DIR}"
CheckResult $?

# Creates proto
echo "Creating prototype..."
echo "i pkginfo=./pkginfo" > prototype
find opt/ | pkgproto >> prototype
CheckResult $?

# Creates package
echo "Creating package..."
pkgmk -o -r .
CheckResult $?

PKG_PATH="`pwd`/../${PKG_NAME}"
echo ${PKG_PATH}
pkgtrans -s /var/spool/pkg "${PKG_PATH}"
CheckResult $?

echo "Package saved to ${PKG_PATH}"

