-- thanks to sweetman for contributing parts of the race store code

races = {}
racescount = 0
currentrace = ""
function writeScore(racename,score)
	local f = io.open("race_scores.dat", "a+")
	f:write(racename.."|"..score.."\n")
	f:close()
	log('race score file written')
end

function findScore(racename)
	local f = io.open("race_scores.dat", "r")
	minval = 9999
	if not f == nil then
		for line in f:lines()
		do
			line_ar = explode('|', line)
			if line_ar[1] == racename or tonumber(line_ar[2]) < minval then
				minval = tonumber(rcdt[2])
			end
		end
		log('race score file read')
	else
		log('race score file not existant')
	end
	return minval
end

function setupRace(racename, positions, loop)
	for a,v in ipairs(positions) do
		if a == 1 then
			oname = 'new-checkpoint-start'
		else
			oname = 'new-checkpoint'
		end
		if a == table.getn(positions) and not loop then
			-- put the finish thing at the end, not a normal checkpoint, only on non-loop races
			oname = 'new-checkpoint-start'		
		end
		if #v == 7 then
			oname = v[7]
		end
		iname = 'race_'..racename..'_'..a
		log("*creating object '"..oname.."' with name '"..iname.."'.")
		spawnObject(oname, iname, v[1],v[2],v[3], v[4],v[5],v[6], raceEventHandler)
	end
	-- add the race finally
	races[racename] = {}
	races[racename]['besttime'] = findScore(racename)
	races[racename]['racename'] = racename
	races[racename]['positions'] = positions
	races[racename]['isloop'] = loop
	races[racename]['startTime'] = 0
	races[racename]['lastcheckpoint'] = 1
	races[racename]['checkpointspassed'] = 1
	races[racename]['numcheckpoints'] = table.getn(positions)
	if loop then
		races[racename]['goalnum'] = 1
	else
		races[racename]['goalnum'] = table.getn(positions)
	end
	
end

function getCheckPointFromName(instance)
	ar = explode('_', instance)
	return tonumber(ar[3])
end

function getRacenameFromName(instance)
	ar = explode('_', instance)
	return tostring(ar[2])
end

function setupArrow(position)
	--log("reposition arrow: "..position)
	txt = currentrace.."\ncheckpoint "..tostring(position).." / "..races[currentrace]['numcheckpoints']
	if position == 1 and races[currentrace]['isloop'] then
		txt = "Finish"
	end
	if position == -1 then
		-- hide it
		pointArrow(0, 0, 0, "")
	else
		data = races[currentrace]['positions'][position]
		if data then
			pointArrow(data[1], data[2], data[3], txt)
		else
			pointArrow(0, 0, 0, "")
		end
	end
end

function raceEventHandler(instance, box)
	--log("racehandler: "..instance.." - "..box)
	checknum = getCheckPointFromName(instance)
	racename = getRacenameFromName(instance)
	
	--log("just passed checkpoint number "..checknum.." of race "..racename)

	-- create an array with all required names in it
	if currentrace == "" then
		-- not racing currently
		if checknum == 1 then
			-- start of the race
			currentrace = racename
			--log(races[currentrace]['racename'])
			races[currentrace]['startTime'] = getTime()
			races[racename]['lastcheckpoint'] = 1
			races[currentrace]['checkpointspassed'] = 1
			setupArrow(2)
			startTimer()
			flashMessage("Race "..racename.." started!", 4)
		--else
			-- passed some not-start checkpoint
			--flashMessage("This is checkpoint "..checknum.." of the Race "..racename.."!", 4)
		end
	elseif currentrace == racename then
		--log(checknum.."###"..races[currentrace]['numcheckpoints'].."###"..races[currentrace]['lastcheckpoint'].."###"..tostring(races[currentrace]['isloop']))
		--log("passed: "..races[currentrace]['checkpointspassed'])
		-- we hit a checkpoint from the same race!
		if checknum == races[currentrace]['lastcheckpoint'] + 1 then
			-- racing, correct checkpoint!
			if checknum == races[currentrace]['numcheckpoints'] and races[currentrace]['isloop'] then
				setupArrow(1)
			else
				setupArrow(checknum+1)
			end
			races[currentrace]['lastcheckpoint'] = checknum
			races[currentrace]['checkpointspassed'] = races[currentrace]['checkpointspassed'] + 1
			time = getTime() - races[currentrace]['startTime']
			msg = "Passed checkpoint "..checknum.." of "..(races[currentrace]['numcheckpoints']).." after "..string.format("%.3f", time).." seconds."
			flashMessage(msg, 4)
		else
			if not checknum == races[currentrace]['lastcheckpoint'] then
				-- racing, wrong checkpoint, prevent trigger of the same checkpoint twice
				flashMessage("Wrong gate! You must find and pass Checkpoint "..races[currentrace]['lastcheckpoint'] + 1, 4)
			end
		end
		if checknum == races[currentrace]['goalnum'] and races[currentrace]['checkpointspassed'] == races[racename]['numcheckpoints'] then
			-- racing, reached finish
			--time = getTime() - starttime
			time = stopTimer()
			msg = "Finished! You needed "..string.format("%.3f", time).." seconds!"

			if races[currentrace]['besttime'] == 9999 or time < tonumber(races[currentrace]['besttime']) then
				races[currentrace]['besttime'] = time
				writeScore(races[currentrace]['racename'], time)
				msg = msg .. "\nNew Best Lap Time!"
			end
			msg = msg .. "\n (Best Lap: "..string.format("%.3f", races[currentrace]['besttime'])..")"
			
			
			setupArrow(-1)
			-- reset some values
			races[currentrace]['checkpointspassed'] = 0
			
			currentrace = ""
			-- flash finish message for 10 seconds
			flashMessage(msg, 10)
		end
	else
		-- flashMessage("This Checkpoint belongs to race"..racename.."!", 4)
	end

end

race_gp_long = {
{882.132996,     0.120613,  1324.317139,    0.0,    90.0,     0.0},
{658.905884,     0.076029,  1324.323730,    0.0,    90.0,    0.0},
{575.903259,     0.062041,  1231.623169,    0.0,     0.0,     0.0},
{565.184814,     0.063519,  1037.515503,    0.0,    22.0,     0.0},
{313.121979,     0.079952,   822.904663,    0.0,     5.0,     0.0},
{385.599213,     0.071390,   722.493469,    0.0,   -90.0,     0.0},
{770.934998,     0.012638,   761.321411,    0.0,   -90.5,    0.0},
{1055.889404,     0.078151,   664.507324,     0.0,   -89.0,     0.0},
{1388.452026,     0.030632,   663.976257,     0.0,    92.0,    0.0},
{1457.364014,     0.041678,   783.509460,     0.0,   168.0,    0.0},
{1493.774048,     0.104160,  1309.505859,     0.0,    18.5,    0.0},
{1348.787964,     0.099335,  1324.566406,    0.0,    90.0,    0.0},
{909.298462,     0.044833,  1324.610596,    0.0,    88.5,     0.0},
}

race_gp_short = {
{1176.429688,     0.063195,  1254.195313,    -0.0,    90.0,    0.0},
{693.874573,     0.090642,  1251.470825,    -0.0,    90.0,    0.0},
{693.383728,     0.071324,  1182.933594,    -0.0,   -90.0,     0.0},
{844.552612,     0.095163,  1168.225586,    -0.0,   -90.0,    0.0},
{941.776978,     0.052285,  1183.067139,    -0.0,   -90.0,    0.0},
{1079.778198,     0.096842,  1183.057373,    -0.0,   -90.0,    0.0},
{1177.627563,     0.067999,  1125.772461,    -0.0,   -40.0,    0.0},
{1282.897095,     0.938393,  1045.571899,     0.0,   -90.0,     0.0},
{1395.055054,     0.107390,  1148.677734,    -0.0,     0.0,     0.0},
{1290.430908,     0.098327,  1254.477905,     0.0,    90.0,    0.0},
}
race_oval = {
{1117.230103,     0.067576,   700.704956,     0.0,   -90.0,     0.0},
{1136.480469,     0.072812,  1030.468628,    0.0,    90.0,    0.0},
{1101.686768,     0.032589,   701.005127,    0.0,   -90.0,    0.0},
}
race_drag = {
{1187.875977,     0.0,  1220.567383,     0.0,    90.0,    0.0},
{784.379578,     0.0,  1221.171143,    0.0,   -90.0,     0.0},
}

function PitStopEvent(instance,box)
 flashMessage("Repairing in 3 seconds...", 3)
 repairVehicle(instance, box) 
end

function init()
	setupRace("GP-Long", race_gp_long, false)
	setupRace("GP-Short", race_gp_short, false)
	setupRace("Drag", race_drag, false)
	setupRace("Oval", race_oval, false)
	log("Good Luck")
	spawnObject("trucktrigger","pitstop",883.356262,     0.340250,  1302.838745,     0.000010,     0.000000,     0.000000 ,PitStopEvent)	
end

init()