-- thanks to sweetman for contributing parts of the race store code

races = {}
racescount = 0
currentrace = ""
cache_file = getSetting("Cache Path") .. "race_scores_bajarama.dat"

checkPointName = 'new-checkpoint'
startCheckPointName = 'new-checkpoint-start'


log("race system using scores file: "..cache_file)

function writeScore(racename,score)
	local f = io.open(cache_file, "a+")
	f:write(racename.."|"..score.."\n")
	f:close()
	log('race score file written')
end

function findScore(racename)
	local f = io.open(cache_file, "r")
	minval = 9999
	if not f == nil then
		for line in f:lines()
		do
			line_ar = explode('|', line)
			if line_ar[1] == racename or tonumber(line_ar[2]) < minval then
				minval = tonumber(rcdt[2])
			end
		end
		log('race score file read')
	else
		log('race score file not existant')
	end
	return minval
end

function setupRace(racename, positions, loop)
	for a,v in ipairs(positions) do
		if a == 1 then
			oname = startCheckPointName
		else
			oname = checkPointName
		end
		if a == table.getn(positions) and not loop then
			-- put the finish thing at the end, not a normal checkpoint, only on non-loop races
			oname = startCheckPointName
		end
		iname = 'race_'..racename..'_'..a
		log("*creating object '"..oname.."' with name '"..iname.."'.")
		spawnObject(oname, iname, v[1],v[2],v[3], v[4],v[5],v[6], raceEventHandler)
	end
	-- add the race finally
	races[racename] = {}
	races[racename]['besttime'] = findScore(racename)
	races[racename]['racename'] = racename
	races[racename]['positions'] = positions
	races[racename]['isloop'] = loop
	races[racename]['startTime'] = 0
	races[racename]['lastcheckpoint'] = 1
	races[racename]['checkpointspassed'] = 1
	races[racename]['numcheckpoints'] = table.getn(positions)
	if loop then
		races[racename]['goalnum'] = 1
	else
		races[racename]['goalnum'] = table.getn(positions)
	end
	
end

function getCheckPointFromName(instance)
	ar = explode('_', instance)
	return tonumber(ar[3])
end

function getRacenameFromName(instance)
	ar = explode('_', instance)
	return tostring(ar[2])
end

function setupArrow(position)
	--log("reposition arrow: "..position)
	txt = currentrace.."\ncheckpoint "..tostring(position).." / "..races[currentrace]['numcheckpoints']
	if position == 1 and races[currentrace]['isloop'] then
		txt = "Finish"
	end
	if position == -1 then
		-- hide it
		pointArrow(0, 0, 0, "")
	else
		data = races[currentrace]['positions'][position]
		if data then
			pointArrow(data[1], data[2], data[3], txt)
		else
			pointArrow(0, 0, 0, "")
		end
	end
end

function raceEventHandler(instance, box)
	log("racehandler: "..instance.." - "..box)
	checknum = getCheckPointFromName(instance)
	racename = getRacenameFromName(instance)
	
	--log("just passed checkpoint number "..checknum.." of race "..racename)

	-- create an array with all required names in it
	if currentrace == "" then
		-- not racing currently
		if checknum == 1 then
			-- start of the race
			currentrace = racename
			--log(races[currentrace]['racename'])
			races[currentrace]['startTime'] = getTime()
			races[racename]['lastcheckpoint'] = 1
			races[currentrace]['checkpointspassed'] = 1
			setupArrow(2)
			startTimer()
			flashMessage("Race "..racename.." started!", 4)
		--else
			-- passed some not-start checkpoint
			--flashMessage("This is checkpoint "..checknum.." of the Race "..racename.."!", 4)
		end
	elseif currentrace == racename then
		--log(checknum.."###"..races[currentrace]['numcheckpoints'].."###"..races[currentrace]['lastcheckpoint'].."###"..tostring(races[currentrace]['isloop']))
		--log("passed: "..races[currentrace]['checkpointspassed'])
		-- we hit a checkpoint from the same race!
		if checknum == races[currentrace]['lastcheckpoint'] + 1 then
			-- racing, correct checkpoint!
			if checknum == races[currentrace]['numcheckpoints'] and races[currentrace]['isloop'] then
				setupArrow(1)
			else
				setupArrow(checknum+1)
			end
			races[currentrace]['lastcheckpoint'] = checknum
			races[currentrace]['checkpointspassed'] = races[currentrace]['checkpointspassed'] + 1
			time = getTime() - races[currentrace]['startTime']
			msg = "Passed checkpoint "..checknum.." of "..(races[currentrace]['numcheckpoints']).." after "..string.format("%.3f", time).." seconds."
			flashMessage(msg, 4)
		else
			if not checknum == races[currentrace]['lastcheckpoint'] then
				-- racing, wrong checkpoint, prevent trigger of the same checkpoint twice
				flashMessage("Wrong gate! You must find and pass Checkpoint "..races[currentrace]['lastcheckpoint'] + 1, 4)
			end
		end
		if checknum == races[currentrace]['goalnum'] and races[currentrace]['checkpointspassed'] == races[racename]['numcheckpoints'] then
			-- racing, reached finish
			--time = getTime() - starttime
			time = stopTimer()
			msg = "Finished! You needed "..string.format("%.3f", time).." seconds!"

			if races[currentrace]['besttime'] == 9999 or time < tonumber(races[currentrace]['besttime']) then
				races[currentrace]['besttime'] = time
				writeScore(races[currentrace]['racename'], time)
				msg = msg .. "\nNew Best Lap Time!"
			end
			msg = msg .. "\n (Best Lap: "..string.format("%.3f", races[currentrace]['besttime'])..")"
			
			
			setupArrow(-1)
			-- reset some values
			races[currentrace]['checkpointspassed'] = 0
			
			currentrace = ""
			-- flash finish message for 10 seconds
			flashMessage(msg, 10)
		end
	else
		-- flashMessage("This Checkpoint belongs to race"..racename.."!", 4)
	end

end

race_bajarama = {
{179.088196,     1.351834,   203.319107,    -0.000006,    75.500044,    -0.849956},
{56.070511,     1.247547,   119.811401,     0.000001,   109.500097,     1.700087},
{88.742783,     2.674362,   332.812042,     0.000071,   127.500016,    -7.299959},
{157.537796,     1.121414,   478.227203,     0.595164,   -29.497634,    -0.456070},
{202.784286,     1.830205,   240.792023,     0.446688,   -87.490632,    -2.408985},
{326.742004,     1.115725,   436.851685,     0.000000,     0.000003,    -0.200001},
{360.338379,     1.100020,   102.170441,     0.000033,  -140.500010,    -0.700087},
{482.216766,     1.089854,   430.449249,     0.000000,     0.000000,    -0.500001},
{478.902618,     1.325789,    90.371094,     0.000000,    -0.000014,     0.000000},
{92.562027,     1.122820,    86.679283,     0.000002,   -91.000017,     0.000002},
{264.193359,     1.481601,   121.791405,     0.000000,  -179.999991,    -0.700000}

}

function init()
	setupRace("Bajarama", race_bajarama, true)
	log("Bajarama.terrn.lua file loaded succefully")	
end

init()