######################################################################
# PagedGeometry SAMPLES BUILD SYSTEM
######################################################################

cmake_minimum_required(VERSION 2.6)
set(CMAKE_ALLOW_LOOSE_LOOP_CONSTRUCTS TRUE)
cmake_policy(SET CMP0003 NEW)

project(PagedGeometry)

# Find actual PagedGeometry root
if (WIN32)
  get_filename_component(PagedGeometry_ROOT_DIR "${PagedGeometry_SOURCE_DIR}/../" ABSOLUTE)
  set(PagedGeometry_TEMPLATES_DIR "${PagedGeometry_ROOT_DIR}/cmake")
  set(PagedGeometry_WORK_DIR "${PagedGeometry_ROOT_DIR}")
  set(CMAKE_MODULE_PATH "${PagedGeometry_ROOT_DIR}/cmake")
elseif (UNIX)
  get_filename_component(PagedGeometry_ROOT_DIR "${PagedGeometry_SOURCE_DIR}/../../../" ABSOLUTE)
  set(PagedGeometry_TEMPLATES_DIR "${PagedGeometry_ROOT_DIR}/lib/PagedGeometry/cmake")
  set(PagedGeometry_WORK_DIR "${PagedGeometry_ROOT_DIR}")
  set(CMAKE_MODULE_PATH "${PagedGeometry_ROOT_DIR}/lib/PagedGeometry/cmake")
endif ()

if (CMAKE_INSTALL_PREFIX_INITIALIZED_TO_DEFAULT)
  #  By default, install to the PagedGeometry SDK root
  SET(CMAKE_INSTALL_PREFIX
   "${PagedGeometry_ROOT_DIR}" CACHE PATH "PagedGeometry install prefix" FORCE
  )
endif ()

# Include necessary submodules
include(PagedGeometryConfigTargets)
set(CMAKE_PREFIX_PATH "${PagedGeometry_ROOT_DIR}")
set(PagedGeometry_INSTALL_SAMPLES TRUE)

set(PagedGeometry_STATIC @PagedGeometry_STATIC@)


#####################################################################
# Set up the basic build environment
#####################################################################

# Set compiler specific build flags
if (CMAKE_COMPILER_IS_GNUCXX)
  add_definitions(-msse)
endif ()
if (MSVC)
  add_definitions(/fp:fast)
endif ()

# Find dependencies
find_package(OGRE REQUIRED)
find_package(PagedGeometry REQUIRED)
find_package(OIS REQUIRED)

include_directories(
  ${OGRE_INCLUDE_DIRS}
  ${PagedGeometry_INCLUDE_DIRS}
  ${OIS_INCLUDE_DIRS}
  ${CMAKE_CURRENT_SOURCE_DIR}/Common/include
)

if (PagedGeometry_STATIC)
  # need to link against all plugins
  if (PagedGeometry_RenderSystem_Direct3D9_FOUND)
    include_directories(${PagedGeometry_RenderSystem_Direct3D9_INCLUDE_DIRS})
    set(PagedGeometry_PLUGIN_LIBRARIES ${PagedGeometry_PLUGIN_LIBRARIES} ${PagedGeometry_RenderSystem_Direct3D9_LIBRARIES})
  endif ()
endif ()


# Configure Samples build

if (NOT OIS_FOUND)
  message(STATUS "Could not find dependency: OIS")
  message(STATUS "Skipping GUI samples")
else ()
  add_subdirectory(Demo_Colour)
  add_subdirectory(Demo_Console)
  add_subdirectory(Demo_Controllers)
  add_subdirectory(Demo_Font)
  add_subdirectory(Demo_Gui)
  add_subdirectory(Demo_ItemBox)
  add_subdirectory(Demo_PanelView)
  add_subdirectory(Demo_Picking)
  add_subdirectory(Demo_PluginStrangeButton)
  add_subdirectory(Demo_ScrollView)
  add_subdirectory(Demo_StaticImage)
  add_subdirectory(Demo_Themes)
endif ()
