#######################################################################
# This file takes care of configuring Ogre to build with the settings
# given in CMake. It creates the necessary config.h file and will 
# also prepare package files for pkg-config and CMake.
#######################################################################

# should we build static libs?
set(PagedGeometry_LIB_TYPE STATIC)
set(PagedGeometry_STATIC_LIB 1)

# Create the pkg-config package files on Unix systems
if (UNIX)
  set(PagedGeometry_LIB_SUFFIX "")
  set(PagedGeometry_PLUGIN_PREFIX "")
  set(PagedGeometry_PLUGIN_EXT ".so")
  set(PagedGeometry_LIB_SUFFIX "${PagedGeometry_LIB_SUFFIX}Static")
  set(PagedGeometry_PLUGIN_PREFIX "lib")
  set(PagedGeometry_PLUGIN_EXT ".a")
  string(TOLOWER "${CMAKE_BUILD_TYPE}" PagedGeometry_BUILD_TYPE)
  if (PagedGeometry_BUILD_TYPE STREQUAL "debug")
    set(PagedGeometry_LIB_SUFFIX "${PagedGeometry_LIB_SUFFIX}_d")
  endif ()

  set(PagedGeometry_ADDITIONAL_LIBS "")
  set(PagedGeometry_CFLAGS "")
  set(PagedGeometry_PREFIX_PATH ${CMAKE_INSTALL_PREFIX})
  set(PagedGeometry_ADDITIONAL_LIBS "${PagedGeometry_ADDITIONAL_LIBS} -luuid")
  configure_file(${PagedGeometry_TEMPLATES_DIR}/PagedGeometryStatic.pc.in ${PagedGeometry_BINARY_DIR}/pkgconfig/PagedGeometry${PagedGeometry_LIB_SUFFIX}.pc @ONLY)
  install(FILES ${PagedGeometry_BINARY_DIR}/pkgconfig/PagedGeometry${PagedGeometry_LIB_SUFFIX}.pc DESTINATION lib/pkgconfig)

  # configure additional packages
  
endif ()

if (PagedGeometry_STANDALONE_BUILD)
  set(CMAKE_USE_RELATIVE_PATHS true)
  set(CMAKE_SUPPRESS_REGENERATION true)
endif()
