/*
* Check multiple checkboxes on page
* INPUT:
*   Checkbox_Clicked by user
* OUTPUT:
*   Checks checkboxes on page if:
*		checkbox name starts with "row_" and checkbox value == value of clicked checkbox
*		OR
*		checkbox name starts with "row_" and Checkbox_Clicked name == "checkall"
*		
*/
function checkValue( theBox ) {

	form = theBox.form;

	for(i=0; i<form.length; i++) {
		
		elementName  = form.elements[i].name.split("_", 2);
		elementValue = form.elements[i].value;
		
		if( elementName[0]=="row" && elementValue==theBox.value ) {
			
			// Set the element "checked" value = theBox "checked" value
			form.elements[i].checked = theBox.checked;
		}
	}
}

function checkAll( theBox ) {

	form = theBox.form;

	for(i=0; i<form.length; i++) {
		
		elementName  = form.elements[i].name.split("_", 2);
		elementValue = form.elements[i].value;
		
		if( elementName[0]=="row" ) {
			
			// Set the element "checked" value = theBox "checked" value
			form.elements[i].checked = theBox.checked;
		}
	}
}