# fmt-xhtml.rb
# @Author:      Thomas Link (micathom AT gmail com)
# @Website:     http://deplate.sf.net/
# @License:     GPL (see http://www.gnu.org/licenses/gpl.txt)
# @Created:     03-Aug-2004.
# @Last Change: 23-Okt-2005.
# @Revision:    0.35

require "deplate/fmt/html"

class Deplate::Formatter::XHTML10transitional <  Deplate::Formatter::HTML
    self.myname   = "xhtml10t"
    self.rx     = /x?html?/i
    self.suffix = ".xhtml"

    def head_doctype
        return %Q{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
            "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">}
    end
    
    def html_lang(stripped=false)
    end

    def html_def
        acc = [%{xmlns="http://www.w3.org/1999/xhtml"}]
        lang = @deplate.options.messages.prop('lang', self)
        if lang
            acc << %{lang="#{lang}"} << %{xml:lang="#{lang}"}
        end
        "<html #{acc.join(" ")}>"
    end
    
    def head_meta_tag(text)
        return %Q{<meta #{text} />}
    end
    
    def head_link_tag(text)
        return %Q{<link #{text} />}
    end
end

